/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.util;

import com.docmosis.util.Base64Helper;
import com.docmosis.util.FileUtilities;
import com.docmosis.util.MultipleStringReplacer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class StringUtilities {
    private static final HashSet<String> C = new HashSet();
    private static final char[][] B;
    private static final MultipleStringReplacer A;
    private static final MultipleStringReplacer D;
    public static final char CHAR_DODGY_WORD_SINGLE_OPEN_QUOTE = '\u2018';
    public static final char CHAR_DODGY_WORD_SINGLE_CLOSE_QUOTE = '\u2019';

    public static String fileToURLString(File file) throws IOException {
        StringBuffer stringBuffer = new StringBuffer("file:///");
        stringBuffer.append(file.getCanonicalPath());
        for (int i = 0; i < stringBuffer.length(); ++i) {
            if (stringBuffer.charAt(i) != '\\') continue;
            stringBuffer.setCharAt(i, '/');
        }
        return stringBuffer.toString().replaceAll(" ", "%20").replaceAll("#", "%23");
    }

    public static String filePathToURLString(String string) throws IOException {
        return StringUtilities.fileToURLString(new File(string));
    }

    public static String appendDirectoryAndFile(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(string);
        if (!string.endsWith(File.separator)) {
            stringBuffer.append("/");
        }
        stringBuffer.append(string2);
        return stringBuffer.toString();
    }

    public static String stripDirectoryFromPath(String string) {
        int n = string.lastIndexOf(47);
        if (n != -1) {
            if (n == string.length() - 1) {
                throw new IllegalArgumentException("Cannot strip directory from a directory path");
            }
            return string.substring(n + 1);
        }
        return string;
    }

    public static String[] splitNoRegex(String string, String string2) {
        if (string == null) {
            return null;
        }
        if (string2 == null || "".equals(string2)) {
            return new String[]{string};
        }
        if (string.equals(string2)) {
            return new String[]{""};
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = string2.length();
        int n2 = 0;
        while (true) {
            int n3;
            if ((n3 = string.indexOf(string2, n2)) == -1) break;
            arrayList.add(string.substring(n2, n3));
            n2 = n3 + n;
        }
        arrayList.add(string.substring(n2));
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    public static String addURLComponentPrefix(String string) {
        return "file:///" + string;
    }

    public static boolean hasValue(String string) {
        return !StringUtilities.isEmpty(string);
    }

    public static boolean isEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }

    public static boolean isNull(String string) {
        return string == null || "null".equalsIgnoreCase(string) || "".equals(string);
    }

    public static String sanitise(String string) {
        if (string != null) {
            return string.trim();
        }
        return string;
    }

    public static String escapeParsedXmlChars(String string) {
        return A.replaceAll(string);
    }

    public static String decodeXmlChars(String string) {
        return D.replaceAll(string);
    }

    public static String coalesce(String string, String string2) {
        if (string != null) {
            return string;
        }
        return string2;
    }

    public static boolean startsWith(String string, String string2, char[] cArray) {
        if (string == null || string2 == null || string2.length() >= string.length()) {
            return false;
        }
        boolean bl = false;
        if (cArray != null) {
            char c = string.charAt(string2.length());
            for (int i = 0; i < cArray.length; ++i) {
                if (c != cArray[i]) continue;
                bl = true;
                break;
            }
        }
        return bl && string.startsWith(string2);
    }

    public static String[] reverse(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return stringArray;
        }
        int n = stringArray.length;
        int n2 = n / 2;
        for (int i = 0; i < n2; ++i) {
            String string = stringArray[i];
            stringArray[i] = stringArray[n - 1 - i];
            stringArray[n - 1 - i] = string;
        }
        return stringArray;
    }

    public static String listToString(List<String> list) {
        return StringUtilities.listToString(list, null);
    }

    public static String listToString(List<String> list, String string) {
        if (list == null || list.isEmpty()) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        Iterator<String> iterator = list.iterator();
        while (iterator.hasNext()) {
            if (string != null && stringBuffer.length() > 0) {
                stringBuffer.append(string);
            }
            stringBuffer.append(String.valueOf(iterator.next()));
        }
        return stringBuffer.toString();
    }

    public static boolean isAffirmative(String string) {
        return StringUtilities.isAffirmative(string, false);
    }

    public static boolean isAffirmative(String string, boolean bl) {
        boolean bl2 = false;
        if (string != null) {
            string = string.toLowerCase();
            return C.contains(string);
        }
        bl2 = bl;
        return bl2;
    }

    public static String toCharCodes(String string) {
        if (string == null) {
            return "<null>";
        }
        if (string.length() == 0) {
            return "<empty>";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            char c2 = c;
            if (c2 < '\n') {
                stringBuffer.append(' ');
            }
            if (c2 < 'd') {
                stringBuffer.append(' ');
            }
            stringBuffer.append((int)c2);
            if (c2 == '\n') {
                stringBuffer.append('\n');
                n2 = 0;
            } else if (n2 > 0 && n2 % 20 == 0) {
                stringBuffer.append('\n');
                n2 = 0;
            } else {
                stringBuffer.append(' ');
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String getShortPeriodSepName(String string) {
        String string2 = null;
        if (string != null) {
            int n = string.lastIndexOf(46);
            string2 = n != -1 && n != string.length() - 1 ? string.substring(n + 1, string.length()) : string;
        }
        return string2;
    }

    public static StringToken[] tokenizeQuoteAware(String string, String string2) {
        StringToken[] stringTokenArray = null;
        if (string != null && string.length() > 0 && string2 != null && string2.length() > 0) {
            ArrayList<StringToken> arrayList = new ArrayList<StringToken>();
            int n = string.length();
            int n2 = string2.length();
            int n3 = 0;
            int n4 = 0;
            QuotedRegions quotedRegions = QuotedRegions.process(string);
            while (n3 < n) {
                String string3;
                int n5 = string.indexOf(string2, n3);
                if (n5 == -1) {
                    string3 = string.substring(n4, n);
                    arrayList.add(new StringToken(string3, false));
                    break;
                }
                if (quotedRegions.isWithinQuotedRegion(n5)) {
                    n3 = quotedRegions.getEndOfQuoteIdx(n5) + 1;
                    if (n3 == -1) {
                        throw new IllegalStateException("Index in unexpected state:" + n5 + " data=[" + string + "]");
                    }
                    if (n3 != n) continue;
                    string3 = string.substring(n4, n);
                    arrayList.add(new StringToken(string3, false));
                    continue;
                }
                string3 = string.substring(n4, n5);
                if (!"".equals(string3)) {
                    arrayList.add(new StringToken(string3, false));
                }
                n4 = n3 = n5 + n2;
            }
            if (!arrayList.isEmpty()) {
                stringTokenArray = new StringToken[arrayList.size()];
                arrayList.toArray(stringTokenArray);
            }
        }
        if (stringTokenArray == null && string != null) {
            stringTokenArray = new StringToken[]{new StringToken(string, false)};
        }
        return stringTokenArray;
    }

    public static StringToken[] tokenize(String string, Pattern pattern, boolean bl) {
        StringToken[] stringTokenArray = null;
        if (string != null) {
            ArrayList<StringToken> arrayList = new ArrayList<StringToken>();
            Matcher matcher = pattern.matcher(string);
            int n = 0;
            int n2 = string.length();
            if (matcher.find()) {
                do {
                    int n3 = matcher.start();
                    int n4 = matcher.end();
                    if (n != n3) {
                        arrayList.add(new StringToken(string.substring(n, n3), false));
                    }
                    if (bl) {
                        arrayList.add(new StringToken(string.substring(n3, n4), true));
                    }
                    n = n4;
                } while (matcher.find());
                if (n < n2) {
                    arrayList.add(new StringToken(string.substring(n), false));
                }
                stringTokenArray = new StringToken[arrayList.size()];
                arrayList.toArray(stringTokenArray);
            } else {
                stringTokenArray = new StringToken[]{new StringToken(string, false)};
            }
        }
        return stringTokenArray;
    }

    public static String compressString(String string) {
        Object object;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            object = new GZIPOutputStream(byteArrayOutputStream);
            byte[] byArray = string.getBytes();
            byte[] byArray2 = new byte[4096];
            FileUtilities.streamOut(new ByteArrayInputStream(byArray), (OutputStream)object, byArray2);
            ((DeflaterOutputStream)object).close();
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Could not compress String:" + iOException.getMessage());
        }
        object = Base64Helper.toBase64(byteArrayOutputStream.toByteArray());
        return object;
    }

    public static String decompressString(String string) {
        Object object;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            object = new GZIPInputStream(new ByteArrayInputStream(Base64Helper.toBytes(string)));
            byte[] byArray = new byte[4096];
            FileUtilities.streamOut((InputStream)object, (OutputStream)byteArrayOutputStream, byArray);
            ((GZIPInputStream)object).close();
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Could not compress String:" + iOException.getMessage());
        }
        object = new String(byteArrayOutputStream.toByteArray());
        return object;
    }

    public static String trimTo(String string, int n) {
        if (string != null && n >= 3 && string.length() > n) {
            string = string.substring(0, n - 3) + "...";
        }
        return string;
    }

    public static String trim(String string) {
        if (string == null) {
            return null;
        }
        return string.trim();
    }

    public static String arrayToString(String[] stringArray, String string, String string2) {
        if (stringArray == null) {
            return null;
        }
        if (stringArray.length == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            if (string != null && i > 0 && i < stringArray.length) {
                stringBuffer.append(string);
            }
            if (string2 != null) {
                stringBuffer.append(string2);
            }
            stringBuffer.append(stringArray[i]);
            if (string2 == null) continue;
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public static String normalizePath(String string) {
        if (StringUtilities.isEmpty(string)) {
            string = null;
        } else {
            string = string.trim().replace("\\", "/");
            while (string.startsWith("/")) {
                string = string.substring(1);
            }
            if (StringUtilities.isEmpty(string)) {
                string = null;
            } else {
                while (string.endsWith("/")) {
                    string = string.substring(0, string.length() - 1);
                }
                if (StringUtilities.isEmpty(string)) {
                    string = null;
                }
            }
            if (string != null) {
                string = string + "/";
            }
        }
        return string;
    }

    public static String stripBOM(String string) {
        if (string != null) {
            for (int i = 0; i < B.length; ++i) {
                char[] cArray = B[i];
                if (string.length() < cArray.length) continue;
                boolean bl = true;
                for (int j = 0; j < cArray.length; ++j) {
                    if (string.charAt(j) == cArray[j]) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                string = string.substring(cArray.length);
                break;
            }
        }
        return string;
    }

    public static boolean equivalent(String string, String string2) {
        if (string == null && string2 == null) {
            return true;
        }
        if (string == null || string2 == null) {
            return false;
        }
        return string.trim().equals(string2.trim());
    }

    public static int[] getMultipleIndexOfs(String string, String ... stringArray) {
        if (StringUtilities.isEmpty(string)) {
            return new int[0];
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        String[] objectArray = stringArray;
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            String string2 = objectArray[i];
            if (string2 == null || string2.length() == 0) continue;
            int n2 = string.indexOf(string2);
            while (n2 >= 0) {
                arrayList.add(n2);
                n2 = string.indexOf(string2, n2 + 1);
            }
        }
        int[] nArray = new int[arrayList.size()];
        for (n = 0; n < arrayList.size(); ++n) {
            nArray[n] = (Integer)arrayList.get(n);
        }
        return nArray;
    }

    public static boolean isSingleQuote(char c) {
        return c == '\'' || c == '\u2018' || c == '\u2019';
    }

    public static int countSingleQuote(String string) {
        return StringUtilities.getMultipleIndexOfs(string, String.valueOf('\'')).length + StringUtilities.getMultipleIndexOfs(string, String.valueOf('\u2018')).length + StringUtilities.getMultipleIndexOfs(string, String.valueOf('\u2019')).length;
    }

    public static boolean validateHexColourFormat(String string) {
        Pattern pattern = Pattern.compile("^(#|0x|0X)(?:[0-9a-fA-F]{3}){1,2}$");
        Matcher matcher = pattern.matcher(string);
        return matcher.find();
    }

    public static boolean includesNull(Object[] objectArray) {
        boolean bl = false;
        if (objectArray != null) {
            for (Object object : objectArray) {
                if (object != null) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    static {
        C.add("yes");
        C.add("y");
        C.add("true");
        B = new char[][]{{'\ufffd', '\ufffd'}, {'\ufeff'}};
        A = new MultipleStringReplacer(MultipleStringReplacer.XML_ENCODE_MAPPING);
        D = new MultipleStringReplacer(MultipleStringReplacer.XML_DECODE_MAPPING);
    }

    static class QuotedRegions {
        private static final char A = '\'';
        private static final char C = '\"';
        private List<List<Integer>> B = new ArrayList<List<Integer>>();

        QuotedRegions() {
        }

        public boolean isWithinQuotedRegion(int n) {
            return this.getEndOfQuoteIdx(n) != -1;
        }

        public int getEndOfQuoteIdx(int n) {
            for (List<Integer> list : this.B) {
                int n2 = list.get(0);
                int n3 = list.get(1);
                if (n < n2 || n > n3) continue;
                return n3 + 1;
            }
            return -1;
        }

        private void record(int n, int n2) {
            if (n2 - n < 0) {
                return;
            }
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            arrayList.add(new Integer(n));
            arrayList.add(new Integer(n2));
            this.B.add(arrayList);
        }

        public static QuotedRegions process(String string) {
            QuotedRegions quotedRegions = new QuotedRegions();
            if (string != null && string.length() > 0) {
                boolean bl = false;
                boolean bl2 = false;
                int n = -1;
                int n2 = -1;
                for (int i = 0; i < string.length(); ++i) {
                    char c = string.charAt(i);
                    if (c == '\'') {
                        if (bl2) continue;
                        if (bl) {
                            n2 = i - 1;
                            quotedRegions.record(n, n2);
                            bl = false;
                            continue;
                        }
                        n = i + 1;
                        bl = true;
                        continue;
                    }
                    if (c != '\"' || bl) continue;
                    if (bl2) {
                        n2 = i - 1;
                        quotedRegions.record(n, n2);
                        bl2 = false;
                        continue;
                    }
                    n = i + 1;
                    bl2 = true;
                }
            }
            return quotedRegions;
        }
    }

    public static class StringToken {
        public final boolean isToken;
        public final String text;

        public StringToken(String string, boolean bl) {
            this.isToken = bl;
            this.text = string;
        }
    }
}

