/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.util;

import com.docmosis.util.DMProperties;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.util.Date;
import java.util.Set;

public class SqlUtilities {
    private static final boolean B = DMProperties.getBoolean("docmosis.data.provider.sql.treatDatesAsTimestamps", true);
    private static final Set A = DMProperties.getStringSet("docmosis.data.provider.sql.platformTimeStampClasses", ";", null);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeAll(Connection connection, PreparedStatement preparedStatement, ResultSet resultSet) throws SQLException {
        try {
            if (connection != null) {
                connection.close();
            }
        }
        finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
        }
    }

    public static Object getSQLObject(ResultSet resultSet, String string, Class clazz) throws SQLException {
        if (B && clazz != null) {
            if (Date.class.isAssignableFrom(clazz) && !clazz.equals(Time.class)) {
                return SqlUtilities.getTimeStamp(resultSet.getTimestamp(string));
            }
            Object object = resultSet.getObject(string);
            if (object == null) {
                return null;
            }
            String string2 = object.getClass().getName();
            if (A.contains(string2)) {
                return SqlUtilities.getTimeStamp(resultSet.getTimestamp(string));
            }
            return resultSet.getObject(string);
        }
        return resultSet.getObject(string);
    }

    private static Date getTimeStamp(Date date) {
        if (date == null) {
            return null;
        }
        return new Date(date.getTime());
    }
}

