/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.util;

import com.docmosis.util.logging.LogManager;
import com.docmosis.util.logging.Logger;
import java.util.HashSet;
import java.util.Set;

public class ShutdownHookRegistry {
    private static final Logger A = LogManager.getLogger(ShutdownHookRegistry.class);
    private static final Set B = new HashSet();

    public static synchronized void addShutdownHook(Thread thread) {
        B.remove(thread);
        Runtime.getRuntime().addShutdownHook(thread);
        B.add(thread);
    }

    public static synchronized void shutdown() {
        for (Thread thread : B) {
            try {
                Runtime.getRuntime().removeShutdownHook(thread);
            }
            catch (RuntimeException runtimeException) {
                A.warn("Unable to remove shutdown hook", runtimeException);
            }
            try {
                thread.run();
            }
            catch (Throwable throwable) {
                A.error(throwable);
            }
        }
    }
}

