/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.util;

import com.docmosis.util.FileUtilities;
import com.docmosis.util.HashUtilities;
import com.docmosis.util.logging.LogManager;
import com.docmosis.util.logging.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class SHA256Utilities
extends HashUtilities {
    static final Logger log = LogManager.getLogger(SHA256Utilities.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSHA256Hash(File file) throws IOException {
        MessageDigest messageDigest = SHA256Utilities.getSHA256Digest();
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            String string = SHA256Utilities.digest(messageDigest, fileInputStream);
            return string;
        }
        finally {
            FileUtilities.close(fileInputStream);
        }
    }

    public static String getSHA256Hash(InputStream inputStream) throws IOException {
        MessageDigest messageDigest = SHA256Utilities.getSHA256Digest();
        return SHA256Utilities.digest(messageDigest, inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSHA256HashBase64(File file) throws IOException {
        MessageDigest messageDigest = SHA256Utilities.getSHA256Digest();
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            String string = SHA256Utilities.digestBase64(messageDigest, fileInputStream);
            return string;
        }
        finally {
            FileUtilities.close(fileInputStream);
        }
    }

    public static String getSHA256HashBase64(byte[] byArray, byte[] byArray2) {
        MessageDigest messageDigest = SHA256Utilities.getSHA256Digest();
        return SHA256Utilities.digestBase64(messageDigest, byArray, byArray2);
    }

    public static String getSHA256HashBase64(InputStream inputStream) throws IOException {
        MessageDigest messageDigest = SHA256Utilities.getSHA256Digest();
        return SHA256Utilities.digestBase64(messageDigest, inputStream);
    }

    public static MessageDigest getSHA256Digest() {
        try {
            return MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            log.error("Could not instantiate MessageDigest", noSuchAlgorithmException);
            return null;
        }
    }
}

