/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.util;

public class PlatformUtilities {
    public static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().startsWith("windows");
    }

    public static boolean isMac() {
        return System.getProperty("os.name").toLowerCase().startsWith("mac");
    }

    public static String getExeName(String string) {
        if (PlatformUtilities.isWindows() && !string.toLowerCase().endsWith(".exe")) {
            return string + ".exe";
        }
        return string;
    }

    public static boolean isJVM64Bit() {
        return System.getProperty("sun.arch.data.model").equals("64");
    }

    public static Integer getJVMMajorVerNumber() {
        Integer n;
        String string = System.getProperty("java.version");
        if (string.startsWith("1.")) {
            String string2 = string.substring(2);
            string2 = string2.replaceAll("\\..*$", "");
            try {
                n = Integer.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {
                n = null;
            }
        } else if (string.indexOf(".") != -1 && string.indexOf(".") < string.length() - 1) {
            String string3 = string.substring(0, string.indexOf("."));
            string3 = string3.replaceAll("\\..*$", "");
            try {
                n = Integer.valueOf(string3);
            }
            catch (NumberFormatException numberFormatException) {
                n = null;
            }
        } else {
            try {
                n = Integer.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                n = null;
            }
        }
        return n;
    }

    public static Boolean isJVMAtLeastVersion8() {
        Boolean bl = null;
        Integer n = PlatformUtilities.getJVMMajorVerNumber();
        if (n != null) {
            bl = n >= 8;
        }
        return bl;
    }

    public static Boolean isJVMAtLeastVersion9() {
        Boolean bl = null;
        Integer n = PlatformUtilities.getJVMMajorVerNumber();
        if (n != null) {
            bl = n >= 9;
        }
        return bl;
    }
}

