/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.util;

import com.docmosis.util.Base64Helper;
import com.docmosis.util.SHA256Utilities;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Random;

public class PasswordEncrypter {
    private static final Random A = new SecureRandom();

    public static String hash(char[] cArray, byte[][] byArray) throws UnsupportedEncodingException {
        return PasswordEncrypter.hash(PasswordEncrypter.toBytes(cArray), byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String hash(byte[] byArray, byte[][] byArray2) throws UnsupportedEncodingException {
        try {
            if (byArray2 != null && byArray2.length > 0) {
                String string = SHA256Utilities.getSHA256HashBase64(byArray, byArray2[0]);
                for (int i = 1; i < byArray2.length; ++i) {
                    string = SHA256Utilities.getSHA256HashBase64(Base64Helper.toBytes(string), byArray2[i]);
                }
                String string2 = string;
                return string2;
            }
            String string = SHA256Utilities.getSHA256HashBase64(byArray, null);
            return string;
        }
        finally {
            Arrays.fill(byArray, (byte)0);
        }
    }

    public static boolean isExpectedPassword(char[] cArray, byte[][] byArray, char[] cArray2) throws UnsupportedEncodingException {
        String string = PasswordEncrypter.hash(PasswordEncrypter.toBytes(cArray), byArray);
        return Arrays.equals(string.toCharArray(), cArray2);
    }

    public static boolean isExpectedPassword(byte[] byArray, byte[][] byArray2, byte[] byArray3) throws UnsupportedEncodingException {
        String string = PasswordEncrypter.hash(byArray, byArray2);
        return Arrays.equals(string.getBytes("UTF-8"), byArray3);
    }

    public static byte[] getSalt() {
        byte[] byArray = new byte[16];
        A.nextBytes(byArray);
        return byArray;
    }

    public static String getSaltyString() {
        return Base64Helper.toBase64(PasswordEncrypter.getSalt());
    }

    private static byte[] toBytes(char[] cArray) {
        CharBuffer charBuffer = CharBuffer.wrap(cArray);
        ByteBuffer byteBuffer = Charset.forName("UTF-8").encode(charBuffer);
        byte[] byArray = Arrays.copyOfRange(byteBuffer.array(), byteBuffer.position(), byteBuffer.limit());
        Arrays.fill(byteBuffer.array(), (byte)0);
        return byArray;
    }
}

