/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.util;

import com.docmosis.util.DMProperties;
import com.docmosis.util.FileUtilities;
import com.docmosis.util.logging.LogManager;
import com.docmosis.util.logging.Logger;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.Set;

public class NativeLibraryLoaderUtilities {
    private static final Logger F = LogManager.getLogger(NativeLibraryLoaderUtilities.class);
    private static final String E = DMProperties.getString("docmosis.openoffice.location");
    private static final String C = "docmosis.openoffice.libraries.searchpath";
    private static final String D = "docmosis.openoffice.libraries.list";
    private static final boolean H = DMProperties.getBoolean("docmosis.openoffice.libraries.copy", true);
    private static NativeLibraryLoaderUtilities B;
    private final File[] A;
    private final File[] G;

    private static File getTmpDir() throws IOException {
        File file = new File(System.getProperty("java.io.tmpdir"));
        if (!(file = new File(file, "docmosis/libs")).exists()) {
            file.mkdirs();
        } else {
            NativeLibraryLoaderUtilities.cleanupOld(file);
            if (!file.exists()) {
                file.mkdirs();
            }
        }
        int n = 1000;
        File file2 = null;
        for (int i = 0; i < 1000; ++i) {
            String string = "lib_" + System.currentTimeMillis() + (int)(Math.random() * 124523.0) + "_" + i;
            File file3 = new File(file, string);
            if (file3.exists()) continue;
            file3.mkdirs();
            file2 = file3;
            break;
        }
        if (file2 == null) {
            throw new IOException("Could not create unique random dir after 1000 attempts.");
        }
        if (!file2.canWrite()) {
            throw new IOException("Unable to write into temp area:" + file2.getPath());
        }
        return file2;
    }

    private static void cleanupOld(File file) {
        long l = System.currentTimeMillis() - 120000L;
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].lastModified() >= l) continue;
            if (fileArray[i].getName().startsWith("TODELETE")) {
                FileUtilities.deleteRecursively(fileArray[i]);
                continue;
            }
            fileArray[i].renameTo(new File(fileArray[i].getAbsoluteFile().getParent(), "TODELETE" + fileArray[i].getName()));
        }
    }

    public static File[] getOONativeLibraryDirectories() {
        NativeLibraryLoaderUtilities.init();
        return NativeLibraryLoaderUtilities.B.G;
    }

    public static synchronized File[] getOONativeLibraries() {
        NativeLibraryLoaderUtilities.init();
        return NativeLibraryLoaderUtilities.B.A;
    }

    private static synchronized void init() {
        File file = null;
        boolean bl = H;
        if (F.isDebugEnabled()) {
            F.debug("Loading native libraries.  Copying to temp area=" + bl);
        }
        if (bl) {
            try {
                file = NativeLibraryLoaderUtilities.getTmpDir();
                if (F.isDebugEnabled()) {
                    F.debug("Copying native libraries to " + file.getAbsolutePath());
                }
            }
            catch (IOException iOException) {
                F.error("Unable to create tmp area, library copying disabled", iOException);
                bl = false;
            }
        }
        if (F.isDebugEnabled()) {
            F.debug("LOADING LIBRARIES from classloader: " + NativeLibraryLoaderUtilities.class.getClassLoader() + "@" + System.identityHashCode(NativeLibraryLoaderUtilities.class.getClassLoader()));
        }
        String[] stringArray = DMProperties.getStringArray(C, ";", new DMProperties.LeadingHomePropertyValueProcessor(E + "/"));
        String[] stringArray2 = DMProperties.getStringArray(D, ";");
        LinkedHashSet<File> linkedHashSet = new LinkedHashSet<File>();
        if (stringArray != null && stringArray2 != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!new File(stringArray[i]).exists()) continue;
                for (int j = 0; j < stringArray2.length; ++j) {
                    String string = System.mapLibraryName(stringArray2[j]);
                    File file2 = new File(stringArray[i], string);
                    if (F.isDebugEnabled()) {
                        F.debug("Candidate library:" + file2.getPath() + " exists? " + file2.exists());
                    }
                    if (!file2.exists() && stringArray2[j].indexOf(46) != -1 && !string.equals(stringArray2[j])) {
                        file2 = new File(stringArray[i], stringArray2[j]);
                    }
                    if (F.isDebugEnabled()) {
                        F.debug("Candidate library:" + file2.getPath() + " exists? " + file2.exists());
                    }
                    if (!file2.exists()) continue;
                    if (bl) {
                        try {
                            File file3 = new File(file, file2.getName());
                            if (!file3.exists()) {
                                FileUtilities.copyFile(file2, file3);
                            }
                            file2 = file3;
                        }
                        catch (IOException iOException) {
                            F.error("Unable to copy lib " + file2.getName(), iOException);
                        }
                    }
                    linkedHashSet.add(file2);
                }
            }
        }
        if (F.isDebugEnabled()) {
            F.debug("Native libraries: " + linkedHashSet.size() + " found");
        }
        B = new NativeLibraryLoaderUtilities(linkedHashSet);
    }

    private NativeLibraryLoaderUtilities(Set set) {
        Serializable serializable;
        if (!set.isEmpty()) {
            this.A = new File[set.size()];
            set.toArray(this.A);
            serializable = new LinkedHashSet();
            for (File file : set) {
                serializable.add(file.getParentFile());
            }
            this.G = new File[serializable.size()];
            serializable.toArray(this.G);
        } else {
            this.A = null;
            this.G = null;
        }
        if (F.isDebugEnabled()) {
            if (this.A == null) {
                F.debug("Native library files: <none>");
            } else {
                serializable = new StringBuffer();
                ((StringBuffer)serializable).append('[');
                for (int i = 0; i < this.A.length; ++i) {
                    if (i > 0) {
                        ((StringBuffer)serializable).append(',');
                    }
                    ((StringBuffer)serializable).append(this.A[i].getAbsolutePath());
                }
                F.debug("Native library files:" + ((StringBuffer)serializable).toString());
            }
            if (this.G == null) {
                F.debug("Native library dirs: <none>");
            } else {
                serializable = new StringBuffer();
                ((StringBuffer)serializable).append('[');
                for (int i = 0; i < this.G.length; ++i) {
                    if (i > 0) {
                        ((StringBuffer)serializable).append(',');
                    }
                    ((StringBuffer)serializable).append(this.G[i].getAbsolutePath());
                }
                ((StringBuffer)serializable).append(']');
                F.debug("Native library dirs:" + ((StringBuffer)serializable).toString());
            }
        }
    }
}

