/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.util;

import com.docmosis.util.image.ExifOrientationApplicationException;
import com.docmosis.util.image.ImageInfoProvider;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class ImageUtilities {
    public static boolean applyExifOrientation(ImageInfoProvider imageInfoProvider, File file) throws ExifOrientationApplicationException {
        AffineTransform affineTransform = ImageUtilities.getExifTransformation(imageInfoProvider);
        if (affineTransform == null) {
            return false;
        }
        try {
            BufferedImage bufferedImage = ImageIO.read(file);
            if (bufferedImage == null) {
                return false;
            }
            BufferedImage bufferedImage2 = ImageUtilities.transformImage(bufferedImage, affineTransform);
            ImageIO.write((RenderedImage)bufferedImage2, imageInfoProvider.getFormatName(), file);
        }
        catch (IOException iOException) {
            throw new ExifOrientationApplicationException(iOException);
        }
        catch (Exception exception) {
            throw new ExifOrientationApplicationException(exception);
        }
        return true;
    }

    public static AffineTransform getExifTransformation(ImageInfoProvider imageInfoProvider) {
        AffineTransform affineTransform = new AffineTransform();
        switch (imageInfoProvider.getOrientation().getValue()) {
            case 1: {
                affineTransform = null;
                break;
            }
            case 2: {
                affineTransform.scale(-1.0, 1.0);
                affineTransform.translate(-imageInfoProvider.getWidth(), 0.0);
                break;
            }
            case 3: {
                affineTransform.translate(imageInfoProvider.getWidth(), imageInfoProvider.getHeight());
                affineTransform.rotate(Math.PI);
                break;
            }
            case 4: {
                affineTransform.scale(1.0, -1.0);
                affineTransform.translate(0.0, -imageInfoProvider.getHeight());
                break;
            }
            case 5: {
                affineTransform.rotate(-1.5707963267948966);
                affineTransform.scale(-1.0, 1.0);
                break;
            }
            case 6: {
                affineTransform.translate(imageInfoProvider.getHeight(), 0.0);
                affineTransform.rotate(1.5707963267948966);
                break;
            }
            case 7: {
                affineTransform.scale(-1.0, 1.0);
                affineTransform.translate(-imageInfoProvider.getHeight(), 0.0);
                affineTransform.translate(0.0, imageInfoProvider.getWidth());
                affineTransform.rotate(4.71238898038469);
                break;
            }
            case 8: {
                affineTransform.translate(0.0, imageInfoProvider.getWidth());
                affineTransform.rotate(4.71238898038469);
                break;
            }
            default: {
                affineTransform = null;
            }
        }
        return affineTransform;
    }

    public static BufferedImage transformImage(BufferedImage bufferedImage, AffineTransform affineTransform) throws Exception {
        AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, 1);
        BufferedImage bufferedImage2 = affineTransformOp.createCompatibleDestImage(bufferedImage, bufferedImage.getType() == 10 ? bufferedImage.getColorModel() : null);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.setBackground(Color.WHITE);
        graphics2D.clearRect(0, 0, bufferedImage2.getWidth(), bufferedImage2.getHeight());
        bufferedImage2 = affineTransformOp.filter(bufferedImage, bufferedImage2);
        return bufferedImage2;
    }
}

