/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.util;

import com.docmosis.util.Base64Helper;
import com.docmosis.util.logging.LogManager;
import com.docmosis.util.logging.Logger;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;

public class HashUtilities {
    static final Logger log = LogManager.getLogger(HashUtilities.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void digest(MessageDigest messageDigest, File file) throws IOException {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                HashUtilities.digest(messageDigest, fileArray[i]);
            }
        } else {
            InputStream inputStream = null;
            try {
                inputStream = new BufferedInputStream(new FileInputStream(file));
                log.debug(HashUtilities.digest(messageDigest, inputStream) + " : " + file.getName());
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
    }

    public static String getHexString(MessageDigest messageDigest, DigestInputStream digestInputStream) throws IOException {
        byte[] byArray = messageDigest.digest();
        return HashUtilities.getHexString(byArray);
    }

    public static String getHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(HashUtilities.hexDigit(byArray[i]));
        }
        return stringBuffer.toString();
    }

    public static String getBase64String(MessageDigest messageDigest, DigestInputStream digestInputStream) throws IOException {
        byte[] byArray = messageDigest.digest();
        return Base64Helper.toBase64(byArray);
    }

    public static String digest(MessageDigest messageDigest, InputStream inputStream) throws IOException {
        return HashUtilities.digest(messageDigest, inputStream, _A.A);
    }

    public static String digestBase64(MessageDigest messageDigest, InputStream inputStream) throws IOException {
        return HashUtilities.digest(messageDigest, inputStream, _A.C);
    }

    public static String digestBase64(MessageDigest messageDigest, byte[] byArray, byte[] byArray2) {
        return HashUtilities.digest(messageDigest, byArray, byArray2, _A.C);
    }

    private static String digest(MessageDigest messageDigest, InputStream inputStream, _A _A2) throws IOException {
        messageDigest.reset();
        DigestInputStream digestInputStream = new DigestInputStream(inputStream, messageDigest);
        byte[] byArray = new byte[4096];
        while (digestInputStream.read(byArray) != -1) {
        }
        if (_A.C.equals((Object)_A2)) {
            return HashUtilities.getBase64String(messageDigest, digestInputStream);
        }
        return HashUtilities.getHexString(messageDigest, digestInputStream);
    }

    private static String digest(MessageDigest messageDigest, byte[] byArray, byte[] byArray2, _A _A2) {
        messageDigest.reset();
        if (byArray2 != null) {
            messageDigest.update(byArray2);
        }
        byte[] byArray3 = messageDigest.digest(byArray);
        if (_A.C.equals((Object)_A2)) {
            return Base64Helper.toBase64(byArray3);
        }
        return HashUtilities.getHexString(byArray3);
    }

    private static String hexDigit(byte by) {
        StringBuffer stringBuffer = new StringBuffer();
        char c = (char)(by >> 4 & 0xF);
        c = c > '\t' ? (char)(c - 10 + 97) : (char)(c + 48);
        stringBuffer.append(c);
        c = (char)(by & 0xF);
        c = c > '\t' ? (char)(c - 10 + 97) : (char)(c + 48);
        stringBuffer.append(c);
        return stringBuffer.toString();
    }

    private static enum _A {
        A,
        C;

    }
}

