/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.util;

import com.docmosis.util.Base64Helper;
import com.docmosis.util.DMProperties;
import com.docmosis.util.J;
import com.docmosis.util.StringUtilities;
import com.docmosis.util.logging.LogManager;
import com.docmosis.util.logging.Logger;
import com.docmosis.util.mime.MimeUtilities;
import com.docmosis.util.zip.ZipEntryProcessor;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class FileUtilities {
    private static final Logger A = LogManager.getLogger(FileUtilities.class);
    private static final int B = DMProperties.getInt("docmosis.stream.buffer.size", 4096);
    public static final int KB = 1024;
    public static final int MB = 0x100000;
    public static final int GB = 0x40000000;
    static final String[] URL_VARIANTS_DOT = new String[]{".", "%2e", "%2E"};
    static final String[] URL_VARIANTS_SLASH = new String[]{"/", "%2f", "%2F"};
    static final String[] URL_VARIANTS_BACKSLASH = new String[]{"\\", "%5c", "%5C"};
    static Set<String> UNACCEPTABLE_PATH_SNIPPETS = new HashSet<String>();

    public static String convertBytesToString(long l) {
        String string = l / 0x40000000L > 0L ? String.valueOf(l / 0x40000000L) + " Gb" : (l / 0x100000L > 0L ? String.valueOf(l / 0x100000L) + " Mb" : (l / 1024L > 0L ? String.valueOf(l / 1024L) + " Kb" : String.valueOf(l) + " bytes"));
        return string;
    }

    public static File createTempDir(String string, String string2) throws IOException {
        File file = File.createTempFile(string, string2);
        if (!file.delete()) {
            throw new IOException();
        }
        if (!file.mkdir()) {
            throw new IOException();
        }
        return file;
    }

    public static File createTempFile(String string, String string2) throws IOException {
        File file = File.createTempFile(string, string2);
        return file;
    }

    public static File createTempFile(String string, String string2, File file) throws IOException {
        File file2 = File.createTempFile(string, string2, file);
        return file2;
    }

    public static boolean deleteRecursively(File file) {
        if (file != null) {
            if (file.isDirectory()) {
                File[] fileArray = file.listFiles();
                boolean bl = true;
                if (fileArray != null) {
                    for (int i = 0; i < fileArray.length; ++i) {
                        bl &= FileUtilities.deleteRecursively(fileArray[i]);
                    }
                } else {
                    A.warn("Unable to clear away folder:" + file.getAbsolutePath());
                    bl = false;
                }
                return bl &= file.delete();
            }
            return file.delete();
        }
        return false;
    }

    public static boolean delete(File[] fileArray) {
        boolean bl = true;
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                bl &= fileArray[i].delete();
            }
        }
        return bl;
    }

    public static boolean delete(File file) {
        boolean bl = true;
        if (file != null) {
            bl = file.delete();
        }
        return bl;
    }

    public static void zip(File file, File file2) throws IOException {
        FileUtilities.zip(file, file2, null);
    }

    public static void zip(File file, File file2, List list) throws IOException {
        FileUtilities.zip(file, file2, list, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zip(File file, File file2, List list, int n) throws IOException {
        ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(file));
        zipOutputStream.setLevel(n);
        byte[] byArray = new byte[B];
        try {
            if (byArray.length == 0) {
                throw new IllegalStateException("BUFFER_SIZE is zero - bad configuration");
            }
            File[] fileArray = file2.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                if (!fileArray[i].isFile() || list != null && !list.contains(fileArray[i])) continue;
                zipOutputStream.putNextEntry(new ZipEntry(fileArray[i].getName()));
                FileInputStream fileInputStream = new FileInputStream(fileArray[i]);
                try {
                    int n2;
                    while ((n2 = fileInputStream.read(byArray)) != -1) {
                        zipOutputStream.write(byArray, 0, n2);
                    }
                }
                finally {
                    fileInputStream.close();
                }
                zipOutputStream.closeEntry();
            }
        }
        finally {
            zipOutputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] unzip(File file, File file2) throws IOException {
        ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(file));
        try {
            String[] stringArray;
            String[] stringArray2 = stringArray = FileUtilities.unzip(zipInputStream, file2);
            return stringArray2;
        }
        finally {
            FileUtilities.close(zipInputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] unzip(ZipInputStream zipInputStream, File file) throws IOException {
        Object object;
        ZipEntry zipEntry;
        ArrayList<String> arrayList = new ArrayList<String>();
        byte[] byArray = new byte[B];
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            if (zipEntry.isDirectory()) {
                new File(file, zipEntry.getName()).mkdirs();
                continue;
            }
            arrayList.add(zipEntry.getName());
            object = new File(file, zipEntry.getName());
            ((File)object).getParentFile().mkdirs();
            FileOutputStream fileOutputStream = new FileOutputStream((File)object);
            try {
                FileUtilities.streamOut(zipInputStream, (OutputStream)fileOutputStream, byArray);
            }
            finally {
                FileUtilities.close(fileOutputStream);
            }
        }
        object = new String[arrayList.size()];
        arrayList.toArray((T[])object);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void jar(File file, File file2) throws IOException {
        JarOutputStream jarOutputStream = null;
        try {
            jarOutputStream = new JarOutputStream(new FileOutputStream(file2));
            FileUtilities.jar(file, jarOutputStream);
        }
        catch (Throwable throwable) {
            FileUtilities.close(jarOutputStream);
            throw throwable;
        }
        FileUtilities.close(jarOutputStream);
    }

    public static void jar(File file, JarOutputStream jarOutputStream) throws IOException {
        FileUtilities.jar(file, jarOutputStream, "", new byte[B]);
    }

    public static void jar(File file, JarOutputStream jarOutputStream, String string, byte[] byArray) throws IOException {
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            JarEntry jarEntry;
            StringBuffer stringBuffer = new StringBuffer();
            if (string != null) {
                stringBuffer.append(string);
            }
            if (stringBuffer.length() > 0 && stringBuffer.charAt(stringBuffer.length() - 1) != '/') {
                stringBuffer.append('/');
            }
            stringBuffer.append(fileArray[i].getName());
            if (fileArray[i].isDirectory()) {
                stringBuffer.append('/');
                jarEntry = new JarEntry(stringBuffer.toString());
                jarOutputStream.putNextEntry(jarEntry);
                jarOutputStream.closeEntry();
                FileUtilities.jar(fileArray[i], jarOutputStream, stringBuffer.toString(), byArray);
                continue;
            }
            jarEntry = new JarEntry(stringBuffer.toString());
            jarOutputStream.putNextEntry(jarEntry);
            FileUtilities.streamOut(fileArray[i], (OutputStream)jarOutputStream, byArray);
            jarOutputStream.closeEntry();
        }
    }

    public static void storeToFile(InputStream inputStream, File file) throws IOException {
        FileUtilities.storeToFile(inputStream, file, new byte[B]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storeToFile(InputStream inputStream, File file, byte[] byArray) throws IOException {
        if (byArray == null || byArray.length == 0) {
            throw new IllegalArgumentException("buffer cannot be null or zero-sized");
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            int n;
            while ((n = inputStream.read(byArray)) != -1) {
                ((OutputStream)fileOutputStream).write(byArray, 0, n);
            }
        }
        finally {
            ((OutputStream)fileOutputStream).close();
        }
    }

    public static void storeToFile(InputStream inputStream, File file, long l) throws IOException {
        FileUtilities.storeToFile(inputStream, file, new byte[B], l);
    }

    public static void storeToFile(Reader reader, File file, long l) throws IOException {
        FileUtilities.storeToFile(reader, file, new char[B], l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storeToFile(Reader reader, File file, char[] cArray, long l) throws IOException {
        if (cArray == null || cArray.length == 0) {
            throw new IllegalArgumentException("buffer cannot be null or zero-sized");
        }
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
        try {
            int n;
            for (long i = 0L; i < l; i += (long)n) {
                int n2 = Math.min(cArray.length, (int)(l - i));
                n = reader.read(cArray, 0, n2);
                if (n == -1) {
                    throw new IOException("End of stream before length");
                }
                ((Writer)outputStreamWriter).write(cArray, 0, n);
            }
        }
        finally {
            FileUtilities.close(outputStreamWriter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storeToFile(InputStream inputStream, File file, byte[] byArray, long l) throws IOException {
        if (byArray == null || byArray.length == 0) {
            throw new IllegalArgumentException("buffer cannot be null or zero-sized");
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            int n;
            for (long i = 0L; i < l; i += (long)n) {
                int n2 = Math.min(byArray.length, (int)(l - i));
                n = inputStream.read(byArray, 0, n2);
                if (n == -1) {
                    throw new IOException("End of stream before length");
                }
                ((OutputStream)fileOutputStream).write(byArray, 0, n);
            }
        }
        finally {
            FileUtilities.close(fileOutputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storeToFile(String string, File file) throws IOException {
        PrintWriter printWriter = new PrintWriter(file);
        try {
            printWriter.print(string);
        }
        finally {
            printWriter.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File file, File file2) throws IOException {
        if (file == null || !file.exists()) {
            throw new IOException("Source file for copy does not exist");
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file2);
            FileUtilities.streamOut(file, fileOutputStream);
        }
        catch (Throwable throwable) {
            FileUtilities.close(fileOutputStream);
            throw throwable;
        }
        FileUtilities.close(fileOutputStream);
    }

    public static void copyDir(File file, final File file2) throws IOException {
        if (file == null || !file.exists()) {
            throw new IOException("Source dir for copy does not exist");
        }
        if (!file.isDirectory()) {
            throw new IOException("Source dir for copy is not a directory");
        }
        if (!file2.exists()) {
            file2.mkdirs();
        } else if (!file2.isDirectory()) {
            throw new IOException("Dest dir for copy is not a directory");
        }
        final ArrayList arrayList = new ArrayList();
        file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (!arrayList.isEmpty()) {
                    return false;
                }
                try {
                    if (file.isDirectory()) {
                        FileUtilities.copyDir(file, new File(file2, file.getName()));
                    } else {
                        FileUtilities.copyFile(file, new File(file2, file.getName()));
                    }
                }
                catch (IOException iOException) {
                    arrayList.add(iOException);
                }
                return true;
            }
        });
        if (!arrayList.isEmpty()) {
            throw (IOException)arrayList.get(0);
        }
    }

    public static long streamOut(File file, File file2) throws IOException {
        return FileUtilities.streamOut(file, file2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long streamOut(File file, File file2, boolean bl) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file2, bl);
        try {
            long l = FileUtilities.streamOut(file, (OutputStream)fileOutputStream, new byte[B]);
            return l;
        }
        finally {
            FileUtilities.close(fileOutputStream);
        }
    }

    public static long streamOut(File file, OutputStream outputStream) throws IOException {
        return FileUtilities.streamOut(file, outputStream, new byte[B]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long streamOut(File file, OutputStream outputStream, byte[] byArray) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            long l = FileUtilities.streamOut(fileInputStream, outputStream, byArray);
            return l;
        }
        finally {
            ((InputStream)fileInputStream).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long streamOut(InputStream inputStream, File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            long l = FileUtilities.streamOut(inputStream, (OutputStream)fileOutputStream, new byte[B]);
            return l;
        }
        finally {
            FileUtilities.close(fileOutputStream);
        }
    }

    public static long streamOut(InputStream inputStream, OutputStream outputStream, byte[] byArray) throws IOException {
        int n;
        if (byArray == null || byArray.length == 0) {
            throw new IllegalArgumentException("buffer cannot be null or zero-sized");
        }
        long l = 0L;
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
            l += (long)n;
        }
        outputStream.flush();
        return l;
    }

    public static long streamOut(Reader reader, Writer writer) throws IOException {
        char[] cArray = new char[4096];
        return FileUtilities.streamOut(reader, writer, cArray, -1L);
    }

    public static long streamOut(Reader reader, Writer writer, char[] cArray, long l) throws IOException {
        int n;
        int n2;
        if (cArray == null || cArray.length == 0) {
            throw new IllegalArgumentException("buffer cannot be null or zero-sized");
        }
        long l2 = 0L;
        int n3 = n2 = l < 0L ? cArray.length : (int)Math.min((long)cArray.length, l - l2);
        while ((n = reader.read(cArray, 0, n2)) > 0) {
            writer.write(cArray, 0, n);
            n2 = l < 0L ? cArray.length : (int)Math.min((long)cArray.length, l - (l2 += (long)n));
        }
        writer.flush();
        return l2;
    }

    public static void close(OutputStream outputStream) {
        if (outputStream != null) {
            try {
                outputStream.close();
            }
            catch (IOException iOException) {
                A.warn("Close failed", iOException);
            }
        }
    }

    public static void close(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                A.warn("Close failed", iOException);
            }
        }
    }

    public static void close(Writer writer) {
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException iOException) {
                A.warn("Close failed", iOException);
            }
        }
    }

    public static void close(Reader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException iOException) {
                A.warn("Close failed", iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readPartial(File file, int n) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n);
        try {
            int n2;
            byte[] byArray = new byte[4096];
            for (int i = n; i > 0 && (n2 = ((InputStream)fileInputStream).read(byArray, 0, i)) != -1; i -= n2) {
                byteArrayOutputStream.write(byArray, 0, n2);
            }
        }
        finally {
            FileUtilities.close(fileInputStream);
        }
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readIntoMemory(File file, int n, int n2) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            byte[] byArray = FileUtilities.readIntoMemory(fileInputStream, n, n2);
            return byArray;
        }
        finally {
            FileUtilities.close(fileInputStream);
        }
    }

    public static byte[] readIntoMemory(InputStream inputStream, int n, int n2) throws IOException {
        byte[] byArray;
        int n3;
        byte[] byArray2 = new byte[B];
        byte[] byArray3 = new byte[n2];
        if (byArray2 == null || byArray2.length == 0) {
            throw new IllegalArgumentException("buffer cannot be null or zero-sized");
        }
        int n4 = 0;
        while ((n3 = inputStream.read(byArray2, 0, B)) != -1) {
            if (n3 + n4 > byArray3.length) {
                byArray = new byte[byArray3.length + Math.max(n2, n3)];
                System.arraycopy(byArray3, 0, byArray, 0, byArray3.length);
                byArray3 = byArray;
            }
            System.arraycopy(byArray2, 0, byArray3, n4, n3);
            if (n <= -1 || (n4 += n3) <= n) continue;
            return null;
        }
        if (byArray3.length != n4) {
            byArray = new byte[n4];
            System.arraycopy(byArray3, 0, byArray, 0, byArray.length);
            byArray3 = byArray;
        }
        return byArray3;
    }

    public static String relativePathToAbsolute(String string) {
        if (string != null && string.indexOf(".") != -1) {
            String[] stringArray = string.split("/");
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("..")) {
                    if (arrayList.size() <= 0) continue;
                    arrayList.remove(arrayList.size() - 1);
                    continue;
                }
                if (stringArray[i].equals(".")) continue;
                arrayList.add(stringArray[i]);
            }
            J j = new J(100);
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                j.B((String)iterator.next());
                if (!iterator.hasNext()) continue;
                j.B('/');
            }
            return j.toString();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addToZip(File file, String string, File file2) throws IOException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file2);
            FileUtilities.addToZip(file, string, fileInputStream);
        }
        catch (Throwable throwable) {
            FileUtilities.close(fileInputStream);
            throw throwable;
        }
        FileUtilities.close(fileInputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addToZip(File file, String string, InputStream inputStream) throws IOException {
        File file2 = FileUtilities.createTempFile("dmfu", "atzip");
        ZipInputStream zipInputStream = null;
        ZipOutputStream zipOutputStream = null;
        try {
            ZipEntry zipEntry;
            FileUtilities.copyFile(file, file2);
            zipInputStream = new ZipInputStream(new FileInputStream(file2));
            zipOutputStream = new ZipOutputStream(new FileOutputStream(file));
            boolean bl = false;
            byte[] byArray = new byte[B];
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                zipOutputStream.putNextEntry(new ZipEntry(zipEntry.getName()));
                if (string.equals(zipEntry.getName())) {
                    FileUtilities.streamOut(inputStream, (OutputStream)zipOutputStream, byArray);
                    bl = true;
                    continue;
                }
                FileUtilities.streamOut(zipInputStream, (OutputStream)zipOutputStream, byArray);
            }
            if (!bl) {
                zipOutputStream.putNextEntry(new ZipEntry(string));
                FileUtilities.streamOut(inputStream, (OutputStream)zipOutputStream, byArray);
            }
        }
        catch (Throwable throwable) {
            FileUtilities.close(zipInputStream);
            FileUtilities.close(zipOutputStream);
            FileUtilities.delete(file2);
            throw throwable;
        }
        FileUtilities.close(zipInputStream);
        FileUtilities.close(zipOutputStream);
        FileUtilities.delete(file2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean extractFromZip(File file, String string, File file2) throws IOException {
        boolean bl = false;
        ZipInputStream zipInputStream = null;
        try {
            ZipEntry zipEntry;
            zipInputStream = new ZipInputStream(new FileInputStream(file));
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (!string.equals(zipEntry.getName())) continue;
                FileUtilities.streamOut(zipInputStream, file2);
                bl = true;
            }
        }
        catch (Throwable throwable) {
            FileUtilities.close(zipInputStream);
            throw throwable;
        }
        FileUtilities.close(zipInputStream);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean extractFromZip(File file, String string, OutputStream outputStream) throws IOException {
        boolean bl = false;
        ZipInputStream zipInputStream = null;
        try {
            ZipEntry zipEntry;
            zipInputStream = new ZipInputStream(new FileInputStream(file));
            byte[] byArray = new byte[B];
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (!string.equals(zipEntry.getName())) continue;
                FileUtilities.streamOut(zipInputStream, outputStream, byArray);
                bl = true;
            }
        }
        catch (Throwable throwable) {
            FileUtilities.close(zipInputStream);
            throw throwable;
        }
        FileUtilities.close(zipInputStream);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int extractFromZip(File file, List<String> list, List<File> list2) throws IOException {
        int n = 0;
        if (list.size() != list2.size()) {
            throw new IllegalArgumentException("entryNames must be same size as writeToFiles");
        }
        ZipInputStream zipInputStream = null;
        try {
            ZipEntry zipEntry;
            zipInputStream = new ZipInputStream(new FileInputStream(file));
            block2: while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                for (int i = 0; i < list.size(); ++i) {
                    String string = list.get(i);
                    if (!string.equals(zipEntry.getName())) continue;
                    File file2 = list2.get(i);
                    FileUtilities.streamOut(zipInputStream, file2);
                    ++n;
                    continue block2;
                }
            }
        }
        catch (Throwable throwable) {
            FileUtilities.close(zipInputStream);
            throw throwable;
        }
        FileUtilities.close(zipInputStream);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateZip(File file, ZipEntryProcessor zipEntryProcessor) throws IOException {
        File file2 = FileUtilities.createTempFile("dmfu", "zep");
        ZipInputStream zipInputStream = null;
        ZipOutputStream zipOutputStream = null;
        try {
            ZipEntry zipEntry;
            FileUtilities.copyFile(file, file2);
            zipInputStream = new ZipInputStream(new FileInputStream(file2));
            zipOutputStream = new ZipOutputStream(new FileOutputStream(file));
            byte[] byArray = new byte[B];
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                ZipEntryProcessor.ProcessResult processResult = zipEntryProcessor.process(zipEntry, zipInputStream);
                try {
                    zipOutputStream.putNextEntry(new ZipEntry(zipEntry.getName()));
                    if (ZipEntryProcessor.ProcessResult.ResultAction.UPDATE.equals((Object)processResult.action)) {
                        FileUtilities.streamOut(processResult.replacementStream, (OutputStream)zipOutputStream, byArray);
                        continue;
                    }
                    FileUtilities.streamOut(zipInputStream, (OutputStream)zipOutputStream, byArray);
                }
                finally {
                    if (processResult.cleanup == null) continue;
                    processResult.cleanup.run();
                }
            }
        }
        catch (Throwable throwable) {
            FileUtilities.close(zipInputStream);
            FileUtilities.close(zipOutputStream);
            FileUtilities.delete(file2);
            throw throwable;
        }
        FileUtilities.close(zipInputStream);
        FileUtilities.close(zipOutputStream);
        FileUtilities.delete(file2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void scanZip(File file, ZipEntryProcessor zipEntryProcessor) throws IOException {
        ZipInputStream zipInputStream = null;
        try {
            ZipEntry zipEntry;
            zipInputStream = new ZipInputStream(new FileInputStream(file));
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                ZipEntryProcessor.ProcessResult processResult = zipEntryProcessor.process(zipEntry, zipInputStream);
                if (processResult.cleanup == null) continue;
                processResult.cleanup.run();
            }
        }
        catch (Throwable throwable) {
            FileUtilities.close(zipInputStream);
            throw throwable;
        }
        FileUtilities.close(zipInputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getZipEntries(File file) throws IOException {
        String[] stringArray = null;
        if (file != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(file));
            try {
                ZipEntry zipEntry;
                while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                    arrayList.add(zipEntry.getName());
                }
            }
            finally {
                FileUtilities.close(zipInputStream);
            }
            stringArray = new String[arrayList.size()];
            arrayList.toArray(stringArray);
        }
        return stringArray;
    }

    public static String getFilenameExtension(String string) {
        if (StringUtilities.isEmpty(string)) {
            return "";
        }
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return "";
        }
        return string.substring(n + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isDocxFormat(File file) throws IOException {
        boolean bl = false;
        if (file.canRead()) {
            FileInputStream fileInputStream = new FileInputStream(file);
            try {
                boolean bl2 = FileUtilities.isDocxFormat(fileInputStream);
                return bl2;
            }
            finally {
                FileUtilities.close(fileInputStream);
            }
        }
        return bl;
    }

    public static boolean isDocxFormat(InputStream inputStream) throws IOException {
        return MimeUtilities.isDocxFormat(inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isOdtFormat(File file) throws IOException {
        boolean bl = false;
        if (file.canRead()) {
            FileInputStream fileInputStream = new FileInputStream(file);
            try {
                boolean bl2 = FileUtilities.isOdtFormat(fileInputStream);
                return bl2;
            }
            finally {
                FileUtilities.close(fileInputStream);
            }
        }
        return bl;
    }

    public static boolean isOdtFormat(InputStream inputStream) throws IOException {
        return MimeUtilities.isOdtFormat(inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void toBase64(File file, File file2) throws IOException {
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            fileOutputStream = new FileOutputStream(file2);
            FileUtilities.toBase64(fileInputStream, fileOutputStream);
        }
        catch (Throwable throwable) {
            FileUtilities.close(fileInputStream);
            FileUtilities.close(fileOutputStream);
            throw throwable;
        }
        FileUtilities.close(fileInputStream);
        FileUtilities.close(fileOutputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void toBase64(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n = 3072;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, 3072);
        try {
            byte[] byArray = new byte[3072];
            int n2 = 0;
            while ((n2 = bufferedInputStream.read(byArray)) == 3072) {
                outputStream.write(Base64Helper.toBase64(byArray).getBytes());
            }
            if (n2 > 0) {
                byte[] byArray2 = new byte[n2];
                System.arraycopy(byArray, 0, byArray2, 0, n2);
                outputStream.write(Base64Helper.toBase64(byArray2).getBytes());
            }
        }
        finally {
            FileUtilities.close(bufferedInputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean stripByteOrderMark(File file) throws IOException {
        boolean bl;
        int n;
        File file2;
        FileOutputStream fileOutputStream;
        FileInputStream fileInputStream;
        byte[] byArray;
        block10: {
            if (file.length() < 2L) {
                return false;
            }
            byArray = new byte[8192];
            byte[] byArray2 = new String("\ufeff").getBytes("UTF-8");
            fileInputStream = null;
            fileOutputStream = null;
            file2 = null;
            fileInputStream = new FileInputStream(file);
            n = ((InputStream)fileInputStream).read(byArray, 0, byArray2.length);
            boolean bl2 = false;
            if (n == byArray2.length) {
                bl2 = true;
                for (bl = false; bl < byArray2.length; bl += 1) {
                    if (byArray[bl] == byArray2[bl]) continue;
                    bl2 = false;
                    break;
                }
            }
            if (bl2) break block10;
            bl = false;
            FileUtilities.close(fileInputStream);
            FileUtilities.close(fileOutputStream);
            if (file2 != null) {
                FileUtilities.copyFile(file2, file);
                FileUtilities.delete(file2);
            }
            return bl;
        }
        try {
            file2 = FileUtilities.createTempFile("dm_", "bom");
            fileOutputStream = new FileOutputStream(file2);
            while ((n = ((InputStream)fileInputStream).read(byArray)) != -1) {
                ((OutputStream)fileOutputStream).write(byArray, 0, n);
            }
            bl = true;
        }
        catch (Throwable throwable) {
            FileUtilities.close(fileInputStream);
            FileUtilities.close(fileOutputStream);
            if (file2 != null) {
                FileUtilities.copyFile(file2, file);
                FileUtilities.delete(file2);
            }
            throw throwable;
        }
        FileUtilities.close(fileInputStream);
        FileUtilities.close(fileOutputStream);
        if (file2 != null) {
            FileUtilities.copyFile(file2, file);
            FileUtilities.delete(file2);
        }
        return bl;
    }

    public static boolean isRtfFormat(File file) throws IOException {
        return MimeUtilities.isRtfFormat(file);
    }

    public static String getParentPath(String string) {
        String string2 = "";
        if (string != null) {
            char c;
            int n;
            for (n = string.length() - 1; n >= 0 && ((c = string.charAt(n)) == '/' || c == '\\'); --n) {
            }
            while (n >= 0 && (c = string.charAt(n)) != '/' && c != '\\') {
                --n;
            }
            if (n > 0) {
                string2 = string.substring(0, n + 1);
            }
        }
        return string2;
    }

    public static boolean includesRelativePathSnippet(String string) {
        boolean bl = false;
        for (String string2 : UNACCEPTABLE_PATH_SNIPPETS) {
            if (string == null || string.indexOf(string2) == -1) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private static List<String> getEncodedVariants(String string) {
        ArrayList<String> arrayList = null;
        if (string != null && !string.isEmpty()) {
            String[] stringArray;
            arrayList = new ArrayList<String>();
            char c = string.charAt(0);
            String[] stringArray2 = stringArray = FileUtilities.getEncodingVariants(c);
            int n = stringArray2.length;
            for (int i = 0; i < n; ++i) {
                String string2;
                String string3 = string2 = stringArray2[i];
                if (string.length() == 1) {
                    arrayList.add(string3);
                    continue;
                }
                for (String string4 : FileUtilities.getEncodedVariants(string.substring(1))) {
                    arrayList.add(string3 + string4);
                }
            }
        }
        return arrayList;
    }

    private static String[] getEncodingVariants(char c) {
        if (c == '.') {
            return URL_VARIANTS_DOT;
        }
        if (c == '/') {
            return URL_VARIANTS_SLASH;
        }
        if (c == '\\') {
            return URL_VARIANTS_BACKSLASH;
        }
        return new String[]{String.valueOf(c)};
    }

    static {
        UNACCEPTABLE_PATH_SNIPPETS.addAll(FileUtilities.getEncodedVariants("../"));
        UNACCEPTABLE_PATH_SNIPPETS.addAll(FileUtilities.getEncodedVariants("..\\"));
        UNACCEPTABLE_PATH_SNIPPETS.addAll(FileUtilities.getEncodedVariants(".//"));
    }

    public static class FileCleanupOnFinalize
    extends File {
        public FileCleanupOnFinalize(String string) {
            super(string);
        }

        public FileCleanupOnFinalize(File file) {
            this(file.getPath());
        }

        protected void finalize() throws Throwable {
            super.finalize();
            if (!this.exists()) {
                return;
            }
            if (!FileUtilities.delete(this)) {
                if (A.isDebugEnabled()) {
                    A.debug("COULD NOT CLEANUP (DELETE) " + this.getPath());
                }
            } else if (A.isDebugEnabled()) {
                A.debug("Cleaned up self " + this.getPath());
            }
        }
    }
}

