/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.util;

import com.docmosis.util.DMProperties;
import com.docmosis.util.EngineVersion;
import com.docmosis.util.FileUtilities;
import com.docmosis.util.PlatformUtilities;
import com.docmosis.util.logging.LogManager;
import com.docmosis.util.logging.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;

public class EngineVersionExtractor {
    static final Logger log = LogManager.getLogger(EngineVersionExtractor.class);
    private static final String K = "docmosis.openoffice.location.config.searchpath";
    private static final String B = "docmosis.openoffice.location";
    private static final String G = "bootstrap";
    private static final String E = "version";
    private static final String O = "ProductKey=";
    private static final String I = "OOOBaseVersion=";
    private static final String C = "MsiProductVersion=";
    private static final String J = "Vendor=";
    private String F;
    private String N;
    private String D;
    private String L;
    private EngineVersion.EngineType H;
    private float M;
    private String A;

    public EngineVersion getEngineVersionInfo(String string) throws IllegalStateException, IOException {
        return this.getEngineVersionInfo(DMProperties.getString(B), DMProperties.getStringArray(K, ";"), string);
    }

    private EngineVersion getEngineVersionInfo(String string, String[] stringArray, String string2) throws IOException {
        String string3 = PlatformUtilities.isWindows() ? ".ini" : "rc";
        this.processBootstrapFile(EngineVersionExtractor.locate(G + string3, string, stringArray));
        this.processVersionFile(EngineVersionExtractor.locate(E + string3, string, stringArray));
        if (this.N != null) {
            this.extractVersionNumber(this.N);
        }
        if ((double)this.M == 0.0) {
            this.extractVersionNumber(this.F);
        }
        if (string2 != null) {
            this.A = string2;
        }
        return new EngineVersion(string3, string3, string, this.D, this.H, this.M, this.A, this.L);
    }

    private static File locate(String string, String string2, String[] stringArray) throws IOException {
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException("subPaths must be specified");
        }
        File file = new File(string2);
        if (!file.canRead() || !file.isDirectory()) {
            throw new IOException("Cannot read directory [" + string2 + "]");
        }
        File file2 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            File file3 = new File(file, stringArray[i] + "/" + string);
            if (!file3.canRead()) continue;
            file2 = file3;
            break;
        }
        if (file2 == null) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < stringArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(';');
                }
                stringBuffer.append(stringArray[i]);
            }
            throw new IOException("Unable to locate [" + string + "] under: [" + file + "] using subPaths = [" + stringBuffer.toString() + "]");
        }
        return file2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processBootstrapFile(File file) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                if (!(string = string.trim()).startsWith(O)) continue;
                this.F = string.substring(O.length());
                String[] stringArray = this.F.split(" ");
                if (stringArray != null && stringArray.length > 1) {
                    if (stringArray[0].startsWith("LibreOffice")) {
                        this.H = EngineVersion.EngineType.LIBRE_OFFICE;
                    } else if (stringArray[0].startsWith("OpenOffice")) {
                        this.H = EngineVersion.EngineType.OPEN_OFFICE;
                    }
                }
                break;
            }
        }
        finally {
            FileUtilities.close(bufferedReader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processVersionFile(File file) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                if ((string = string.trim()).startsWith(I)) {
                    this.D = string.substring(I.length());
                    continue;
                }
                if (string.startsWith(C)) {
                    this.N = string.substring(C.length());
                    if (!this.N.startsWith("<")) continue;
                    this.N = null;
                    continue;
                }
                if (!string.startsWith(J)) continue;
                this.L = string.substring(J.length());
            }
        }
        finally {
            FileUtilities.close(bufferedReader);
        }
    }

    private void extractVersionNumber(String string) {
        int n;
        int n2;
        if (string == null) {
            return;
        }
        int n3 = -1;
        for (n2 = 0; n2 < string.length(); ++n2) {
            n = string.charAt(n2);
            if (!Character.isDigit((char)n)) continue;
            n3 = n2;
            break;
        }
        if (n3 == -1) {
            return;
        }
        this.A = string.substring(n3);
        n2 = 0;
        n = this.A.length();
        for (int i = 0; i < this.A.length(); ++i) {
            char c = this.A.charAt(i);
            if (c == '.') {
                ++n2;
            }
            if (n2 != 2) continue;
            n = i;
            break;
        }
        try {
            this.M = Float.parseFloat(this.A.substring(0, n));
        }
        catch (NumberFormatException numberFormatException) {
            log.warn("version string not in expected format [" + string + "]");
        }
    }

    public static void main(String[] stringArray) throws IOException {
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray2 = new String[]{"MacOS", "Resources", "program"};
        String[] stringArray3 = new String[]{"c:/Program Files (x86)/LO_SAVES/LibreOffice 3.6.7.2", "c:/Program Files (x86)/LO_SAVES/LibreOffice 5.0.6.3", "c:/Program Files (x86)/LO_SAVES/LibreOffice 4.3.7.2", "c:/Program Files/LibreOffice6.2.8.2", "c:/Program Files/LibreOffice7.5.7.1", "c:/Program Files (x86)/OpenOffice 4.1.14"};
        for (n = 0; n < stringArray3.length; ++n) {
            EngineVersion engineVersion = new EngineVersionExtractor().getEngineVersionInfo(stringArray3[n], stringArray2, null);
            System.out.println(engineVersion);
            arrayList.add(engineVersion.getVersionNumberString());
        }
        System.out.println("Sorted versions");
        Collections.sort(arrayList);
        for (n = 0; n < arrayList.size(); ++n) {
            System.out.println("  " + (String)arrayList.get(n));
        }
    }
}

