/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.util;

import com.docmosis.util.sort.AlphaNumericSortComparator;
import java.io.Serializable;

public class EngineVersion
implements Serializable {
    private String A;
    private String F;
    private String D;
    private String H;
    private String G;
    private EngineType B;
    private float E;
    private String C;

    public EngineVersion() {
    }

    public EngineVersion(String string, String string2, String string3, String string4, EngineType engineType, float f, String string5, String string6) {
        this.A = string;
        this.F = string2;
        this.D = string3;
        this.H = string4;
        this.B = engineType;
        this.E = f;
        this.C = string5;
        this.G = string6;
    }

    public float getVersionNumberAsNumber() {
        return this.E;
    }

    public String getVersionNumberString() {
        return this.C;
    }

    public String getProductKey() {
        return this.A;
    }

    public boolean isLibreOffice() {
        return EngineType.LIBRE_OFFICE.equals((Object)this.B);
    }

    public boolean isVersion(String string) {
        return this.getVersionNumberString().startsWith(string);
    }

    public boolean isVersionAtLeast(EngineType engineType, float f) {
        return this.getVersionNumberAsNumber() >= f && (engineType == null || engineType.equals((Object)this.getEngineType()));
    }

    public boolean isVersionAtLeast(String string) {
        return EngineVersion.isVersionAtLeast(this.getVersionNumberString(), string);
    }

    public static boolean isVersionAtLeast(String string, String string2) {
        AlphaNumericSortComparator alphaNumericSortComparator = new AlphaNumericSortComparator(true, true, true);
        return alphaNumericSortComparator.compare(string, string2) >= 0;
    }

    public EngineType getEngineType() {
        return this.B;
    }

    public String getVendor() {
        return this.G;
    }

    public String toString() {
        return "EngineVersion [productKey=" + this.A + ", productMajorVersion=" + this.F + ", msiProductVersion=" + this.D + ", OOOBaseVersion=" + this.H + ", officeEngineType=" + (Object)((Object)this.B) + ", versionAsNumber=" + this.E + ", versionNumberAsString=" + this.C + ", vendor=" + this.G + "]";
    }

    public static enum EngineType {
        LIBRE_OFFICE("LibreOffice"),
        OPEN_OFFICE("OpenOffice");

        private final String A;

        private EngineType(String string2) {
            this.A = string2;
        }
    }
}

