/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.util;

import com.docmosis.util.Base64Helper;
import com.docmosis.util.StringUtilities;
import com.docmosis.util.logging.LogManager;
import com.docmosis.util.logging.Logger;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class EncryptionUtilities {
    private static final Logger C = LogManager.getLogger(EncryptionUtilities.class);
    private static final String E = "RSA";
    private static final int A = 2048;
    private static final String G = "RSA/ECB/PKCS1Padding";
    private static final String B = "AES";
    private static final int F = 128;
    private static final String D = "AES";

    public static String[] generateKeyPairRSA() throws NoSuchAlgorithmException {
        return EncryptionUtilities.generateKeyPair(E, 2048);
    }

    public static String generateSecretKeyAES() throws NoSuchAlgorithmException {
        return EncryptionUtilities.generateSecretKey("AES", 128);
    }

    public static String[] generateKeyPair(String string, int n) throws NoSuchAlgorithmException {
        if (StringUtilities.isEmpty(string)) {
            string = E;
        }
        KeyPairGenerator keyPairGenerator = null;
        try {
            keyPairGenerator = KeyPairGenerator.getInstance(string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            C.error("Unsupported algorithm: " + string, noSuchAlgorithmException);
            throw noSuchAlgorithmException;
        }
        keyPairGenerator.initialize(n);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(keyPair.getPublic().getEncoded());
        String string2 = Base64Helper.toBase64(x509EncodedKeySpec.getEncoded());
        X509EncodedKeySpec x509EncodedKeySpec2 = new X509EncodedKeySpec(keyPair.getPrivate().getEncoded());
        String string3 = Base64Helper.toBase64(x509EncodedKeySpec2.getEncoded());
        String[] stringArray = new String[]{string2, string3};
        return stringArray;
    }

    public static String generateSecretKey(String string, int n) throws NoSuchAlgorithmException {
        if (StringUtilities.isEmpty(string)) {
            string = "AES";
        }
        KeyGenerator keyGenerator = null;
        try {
            keyGenerator = KeyGenerator.getInstance(string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            C.error("Unsupported algorithm: " + string, noSuchAlgorithmException);
            throw noSuchAlgorithmException;
        }
        keyGenerator.init(n);
        SecretKey secretKey = keyGenerator.generateKey();
        String string2 = Base64Helper.toBase64(secretKey.getEncoded());
        return string2;
    }

    public static String encryptRSA(String string, String string2) {
        String string3 = null;
        if (string != null) {
            try {
                Cipher cipher = Cipher.getInstance(G);
                byte[] byArray = Base64Helper.toBytes(string2);
                X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray);
                KeyFactory keyFactory = KeyFactory.getInstance(E);
                PublicKey publicKey = keyFactory.generatePublic(x509EncodedKeySpec);
                cipher.init(1, publicKey);
                cipher.update(string.getBytes());
                byte[] byArray2 = cipher.doFinal();
                string3 = Base64Helper.toBase64(byArray2);
            }
            catch (NoSuchPaddingException noSuchPaddingException) {
                C.error("Invalid padding scheme", noSuchPaddingException);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                C.error("Algorithm not available in environment", noSuchAlgorithmException);
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
                C.error("Invalid Key Specification for Public Key", invalidKeySpecException);
            }
            catch (InvalidKeyException invalidKeyException) {
                C.error("Invalid Public Key", invalidKeyException);
            }
            catch (IllegalBlockSizeException illegalBlockSizeException) {
                C.error("llegal Block size error", illegalBlockSizeException);
            }
            catch (BadPaddingException badPaddingException) {
                C.error("Bad padding error", badPaddingException);
            }
        }
        return string3;
    }

    public static String decryptRSA(String string, String string2) {
        String string3 = null;
        if (string != null) {
            try {
                Cipher cipher = Cipher.getInstance(G);
                byte[] byArray = Base64Helper.toBytes(string2);
                PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray);
                KeyFactory keyFactory = KeyFactory.getInstance(E);
                PrivateKey privateKey = keyFactory.generatePrivate(pKCS8EncodedKeySpec);
                cipher.init(2, privateKey);
                cipher.update(Base64Helper.toBytes(string));
                byte[] byArray2 = cipher.doFinal();
                string3 = new String(byArray2, "UTF-8");
            }
            catch (NoSuchPaddingException noSuchPaddingException) {
                C.error("Invalid padding scheme", noSuchPaddingException);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                C.error("Algorithm not available in environment", noSuchAlgorithmException);
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
                C.error("Invalid Key Specification for Private Key", invalidKeySpecException);
            }
            catch (InvalidKeyException invalidKeyException) {
                C.error("Invalid Private Key", invalidKeyException);
            }
            catch (IllegalBlockSizeException illegalBlockSizeException) {
                C.error("llegal Block size error", illegalBlockSizeException);
            }
            catch (BadPaddingException badPaddingException) {
                C.error("Bad padding error", badPaddingException);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                C.error("Unsupported Encoding", unsupportedEncodingException);
            }
        }
        return string3;
    }

    public static String encryptAES(String string, String string2) {
        String string3 = null;
        if (string != null) {
            try {
                Cipher cipher = Cipher.getInstance("AES");
                byte[] byArray = Base64Helper.toBytes(string2);
                SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, 0, byArray.length, "AES");
                cipher.init(1, secretKeySpec);
                byte[] byArray2 = cipher.doFinal(string.getBytes());
                string3 = Base64Helper.toBase64(byArray2);
            }
            catch (NoSuchPaddingException noSuchPaddingException) {
                C.error("Invalid padding scheme", noSuchPaddingException);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                C.error("Algorithm not available in environment", noSuchAlgorithmException);
            }
            catch (InvalidKeyException invalidKeyException) {
                C.error("Invalid Public Key", invalidKeyException);
            }
            catch (IllegalBlockSizeException illegalBlockSizeException) {
                C.error("llegal Block size error", illegalBlockSizeException);
            }
            catch (BadPaddingException badPaddingException) {
                C.error("Bad padding error", badPaddingException);
            }
        }
        return string3;
    }

    public static String decryptAES(String string, String string2) {
        String string3 = null;
        if (string != null) {
            try {
                Cipher cipher = Cipher.getInstance("AES");
                byte[] byArray = Base64Helper.toBytes(string2);
                SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, 0, byArray.length, "AES");
                cipher.init(2, secretKeySpec);
                byte[] byArray2 = cipher.doFinal(Base64Helper.toBytes(string));
                string3 = new String(byArray2, "UTF-8");
            }
            catch (NoSuchPaddingException noSuchPaddingException) {
                C.error("Invalid padding scheme", noSuchPaddingException);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                C.error("Algorithm not available in environment", noSuchAlgorithmException);
            }
            catch (InvalidKeyException invalidKeyException) {
                C.error("Invalid Private Key", invalidKeyException);
            }
            catch (IllegalBlockSizeException illegalBlockSizeException) {
                C.error("llegal Block size error", illegalBlockSizeException);
            }
            catch (BadPaddingException badPaddingException) {
                C.error("Bad padding error", badPaddingException);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                C.error("Unsupported Encoding", unsupportedEncodingException);
            }
        }
        return string3;
    }

    public static String encryptAES(String string, String string2, String string3) {
        String string4 = EncryptionUtilities.decryptRSA(string2, string3);
        return EncryptionUtilities.encryptAES(string, string4);
    }

    public static String decryptAES(String string, String string2, String string3) {
        String string4 = EncryptionUtilities.decryptRSA(string2, string3);
        return EncryptionUtilities.decryptAES(string, string4);
    }
}

