/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.util;

import com.docmosis.util.StringUtilities;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TimeZone;

public class DateUtilities {
    static final String DATE_FORMAT = "dd-MMM-yyyy";

    public static Timestamp getDateStringAsTimestamp(String string) {
        if (StringUtilities.hasValue(string)) {
            try {
                Date date = new SimpleDateFormat(DATE_FORMAT).parse(string);
                return new Timestamp(date.getTime());
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return null;
    }

    public static String getTimestampAsDateString(Date date) {
        if (date != null) {
            try {
                return new SimpleDateFormat(DATE_FORMAT).format(date);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static Date getEpoch() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, 1970);
        calendar.set(2, 0);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date parseStrict(SimpleDateFormat simpleDateFormat, String string, boolean bl) throws ParseException {
        Date date = simpleDateFormat.parse(string);
        String string2 = simpleDateFormat.format(date);
        if (bl && string.equalsIgnoreCase(string2)) {
            return date;
        }
        if (!bl && string.equals(string2)) {
            return date;
        }
        throw new ParseException("Date not a strict match for format. Format=[" + simpleDateFormat.toPattern() + "], dateStr=[" + string + "]", 0);
    }

    public static Date getStartOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(DateUtilities.getMidnight(date));
        calendar.set(5, 1);
        return calendar.getTime();
    }

    public static Date getStartOfNextMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(DateUtilities.getMidnight(date));
        calendar.set(5, 1);
        calendar.add(2, 1);
        return calendar.getTime();
    }

    public static Date getEndOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(DateUtilities.getMidnight(date));
        calendar.set(5, 1);
        calendar.add(2, 1);
        calendar.add(14, -1);
        return calendar.getTime();
    }

    public static Date getEndOfDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(DateUtilities.getMidnight(date));
        calendar.add(5, 1);
        calendar.add(14, -1);
        return calendar.getTime();
    }

    public static Date getMidnight(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(14, 0);
        calendar.set(13, 0);
        calendar.set(12, 0);
        calendar.set(11, 0);
        return calendar.getTime();
    }

    public static Date getEndOfYear(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(2, 11);
        calendar.set(5, 31);
        return DateUtilities.getEndOfDay(calendar.getTime());
    }

    public static String getAgoString(long l) {
        long l2 = System.currentTimeMillis() - l;
        if (l2 < 2000L) {
            return "just now";
        }
        return DateUtilities.getDurationString(l2) + " ago";
    }

    public static String getAgoString(Date date) {
        return DateUtilities.getAgoString(date.getTime());
    }

    public static String getDurationString(long l) {
        String string = l < 2000L ? "1 second" : (l < 120000L ? l / 1000L + " seconds" : (l < 0x6DDD00L ? l / 60000L + " minutes" : (l < 172800000L ? l / 3600000L + " hours" : (l < 1209600000L ? l / 86400000L + " days" : (l < 5184000000L ? l / 604800000L + " weeks" : (l < 63072000000L ? l / 2592000000L + " months" : "years"))))));
        return string;
    }

    public static abstract class Unit {
        private static Map B = new LinkedHashMap();
        public static Unit MILLISECOND = Unit.register(new Unit("milli", 1L){

            @Override
            protected int getCalendarField() {
                return 14;
            }
        });
        public static Unit SECOND = Unit.register(new Unit("second", 1000L){

            @Override
            public int getCalendarField() {
                return 13;
            }
        });
        public static Unit MINUTE = Unit.register(new Unit("minute", 60000L){

            @Override
            protected int getCalendarField() {
                return 12;
            }
        });
        public static Unit HOUR = Unit.register(new Unit("hour", 3600000L){

            @Override
            protected int getCalendarField() {
                return 10;
            }
        });
        public static Unit DAY = Unit.register(new Unit("day", 86400000L){

            @Override
            protected int getCalendarField() {
                return 6;
            }
        });
        public static Unit WEEK = Unit.register(new Unit("week", 604800000L){

            @Override
            protected int getCalendarField() {
                return 3;
            }
        });
        public static Unit MONTH = Unit.register(new Unit("month", 2629800000L){

            @Override
            protected int getCalendarField() {
                return 2;
            }
        });
        public static Unit YEAR = Unit.register(new Unit("year", 31557600000L){

            @Override
            protected int getCalendarField() {
                return 1;
            }
        });
        private final String A;
        private final long C;

        private static Unit register(Unit unit) {
            if (B.containsKey(unit.A)) {
                throw new IllegalStateException("UNIT " + unit.A + " is already registered");
            }
            B.put(unit.A, unit);
            return unit;
        }

        public Unit(String string, long l) {
            this.A = string;
            this.C = l;
        }

        private long calcDelta(int n, long l, TimeZone timeZone) {
            Calendar calendar = Calendar.getInstance();
            if (timeZone != null) {
                calendar.setTimeZone(timeZone);
            }
            calendar.setTimeInMillis(l);
            calendar.add(this.getCalendarField(), n);
            return calendar.getTimeInMillis();
        }

        protected abstract int getCalendarField();

        public String getName() {
            return this.A;
        }

        public static Unit valueOf(String string) {
            Unit unit = (Unit)B.get(string = string.toLowerCase());
            if (unit == null && string.endsWith("s")) {
                unit = (Unit)B.get(string.substring(0, string.length() - 1));
            }
            return unit;
        }

        public static String[] supportedUnitsList() {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string : B.keySet()) {
                arrayList.add(string);
                arrayList.add(string + "s");
            }
            String[] stringArray = new String[arrayList.size()];
            arrayList.toArray(stringArray);
            return stringArray;
        }

        public long add(int n, long l) {
            return this.add(n, l, null);
        }

        public long add(int n, long l, TimeZone timeZone) {
            return this.calcDelta(n, l, timeZone);
        }

        public Date add(int n, Date date) {
            return new Date(this.add(n, date.getTime()));
        }

        public Date add(int n, Date date, TimeZone timeZone) {
            return new Date(this.add(n, date.getTime(), timeZone));
        }

        public double diff(Date date, Date date2) {
            double d = date2.getTime() - date.getTime();
            return d / (double)this.C;
        }
    }
}

