/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.util;

import com.docmosis.util.Configuration;
import com.docmosis.util.FileUtilities;
import com.docmosis.util.StringUtilities;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DMProperties {
    private static final String E = "docmosis.override.filename";
    private static final String C = "docmosis/defaults/docmosisdefault.properties";
    private static final String A = "docmosis.properties";
    private static Properties B;
    private static final Logger D;

    private static String getOverrideFilename(Configuration configuration) {
        if (configuration != null && configuration.getProperties().get(E) != null) {
            return configuration.getProperties().getProperty(E);
        }
        String string = System.getProperty(E);
        if (string == null) {
            string = A;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void findAndLoadProperties(String string) {
        boolean bl = false;
        try {
            InputStream inputStream = DMProperties.class.getClassLoader().getResourceAsStream(string);
            try {
                if (inputStream != null) {
                    B.load(inputStream);
                } else {
                    D.log(Level.FINE, "No properties to load from: " + string);
                    bl = true;
                }
            }
            finally {
                FileUtilities.close(inputStream);
            }
        }
        catch (IOException iOException) {
            D.log(Level.WARNING, "Error loading " + string);
            bl = true;
        }
        if (bl && !A.equals(string)) {
            DMProperties.findAndLoadProperties(A);
        }
    }

    private static void loadSystemProperties(String string) {
        Properties properties = System.getProperties();
        int n = 0;
        if (properties != null) {
            for (String string2 : properties.keySet()) {
                if (string2 == null || !string2.startsWith(string)) continue;
                B.setProperty(string2, System.getProperty(string2));
                ++n;
            }
        }
        D.log(Level.FINE, n + " system properties loaded.");
    }

    public static Properties getProperties() throws IllegalStateException {
        DMProperties.checkState();
        return B;
    }

    public static String getString(String string) throws IllegalStateException {
        DMProperties.checkState();
        return B.getProperty(string);
    }

    public static String getString(String string, String string2) throws IllegalStateException {
        DMProperties.checkState();
        return B.getProperty(string, string2);
    }

    public static String getString(String string, PropertyValueProcessor propertyValueProcessor) throws IllegalStateException {
        DMProperties.checkState();
        return propertyValueProcessor.process(B.getProperty(string));
    }

    public static boolean getBoolean(String string) {
        return DMProperties.getBoolean(string, false);
    }

    public static boolean getBoolean(String string, boolean bl) throws IllegalStateException {
        boolean bl2 = bl;
        String string2 = DMProperties.getString(string);
        if (string2 != null) {
            if ("true".equalsIgnoreCase(string2)) {
                bl2 = true;
            } else if ("false".equalsIgnoreCase(string2)) {
                bl2 = false;
            } else {
                D.log(Level.WARNING, "getBoolean() found a non-boolean for key: [" + string + "].  Defaulting to " + bl);
            }
        }
        return bl2;
    }

    public static int getInt(String string) throws IllegalStateException {
        return DMProperties.getInt(string, 0);
    }

    public static int getInt(String string, int n) throws IllegalStateException {
        int n2 = n;
        String string2 = DMProperties.getString(string);
        if (string2 != null) {
            try {
                n2 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                D.log(Level.WARNING, "getInt() found a non-int for key: [" + string + "].  Value: [" + string2 + "].  Defaulting to " + n2);
            }
        }
        return n2;
    }

    public static long getLong(String string) throws IllegalStateException {
        return DMProperties.getLong(string, 0L);
    }

    public static long getLong(String string, long l) throws IllegalStateException {
        long l2 = l;
        String string2 = DMProperties.getString(string);
        if (string2 != null) {
            try {
                l2 = Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {
                D.log(Level.WARNING, "getLong() found a non-long for key: [" + string + "].  Value: [" + string2 + "].  Defaulting to " + l2);
            }
        }
        return l2;
    }

    public static double getDouble(String string) throws IllegalStateException {
        return DMProperties.getDouble(string, 0.0);
    }

    public static double getDouble(String string, double d) throws IllegalStateException {
        double d2 = d;
        String string2 = DMProperties.getString(string);
        if (string2 != null) {
            try {
                d2 = Double.parseDouble(string2);
            }
            catch (NumberFormatException numberFormatException) {
                D.log(Level.WARNING, "getDouble() found a non-double for key: [" + string + "].  Value: [" + string2 + "].  Defaulting to " + d2);
            }
        }
        return d2;
    }

    public static void initialise() {
        DMProperties.initialise(null);
    }

    public static void initialise(Configuration configuration) {
        try {
            Object object;
            B = new Properties();
            DMProperties.findAndLoadProperties(C);
            DMProperties.findAndLoadProperties(DMProperties.getOverrideFilename(configuration));
            DMProperties.loadSystemProperties("docmosis.");
            if (configuration != null) {
                object = configuration.getProperties().entrySet().iterator();
                while (object.hasNext()) {
                    Map.Entry entry = (Map.Entry)object.next();
                    B.put(entry.getKey(), entry.getValue());
                }
            }
            if ((object = B.getProperty("docmosis.site")) != null && "true".equalsIgnoreCase(B.getProperty("docmosis.site.decode.utf8"))) {
                D.log(Level.FINE, "UTF-8 decoding site");
                object = new String(((String)object).getBytes("ISO-8859-1"), "UTF-8");
                B.put("docmosis.site", object);
            }
            if (!Boolean.getBoolean("docmosis.properties.notrim")) {
                for (Map.Entry entry : B.entrySet()) {
                    B.put(entry.getKey(), ((String)entry.getValue()).trim());
                }
            }
        }
        catch (Exception exception) {
            D.log(Level.SEVERE, "Error initializing properties");
            exception.printStackTrace();
        }
    }

    public static void release() {
        B = null;
    }

    public static boolean isInitialised() {
        return B != null;
    }

    private static void checkState() throws IllegalStateException {
        if (B == null) {
            throw new IllegalStateException("Properties not initialised.  Release may have been called.  Call initialise() to use this class again.");
        }
    }

    public static String[] getStringArray(String string, String string2) {
        return DMProperties.getStringArray(string, string2, null);
    }

    public static String[] getStringArray(String[] stringArray, String string) {
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2;
            if (stringArray[i] == null || (stringArray2 = DMProperties.getStringArray(stringArray[i], string)) == null || stringArray2.length == 1 && StringUtilities.isEmpty(stringArray2[0])) continue;
            for (int j = 0; j < stringArray2.length; ++j) {
                arrayList.add(stringArray2[j]);
            }
        }
        String[] stringArray3 = null;
        if (!arrayList.isEmpty()) {
            stringArray3 = new String[arrayList.size()];
            arrayList.toArray(stringArray3);
        }
        return stringArray3;
    }

    public static String[] getStringArray(String string, String string2, PropertyValueProcessor propertyValueProcessor) {
        String[] stringArray = null;
        String string3 = DMProperties.getString(string);
        if (string3 != null) {
            String[] stringArray2 = string3.split(string2);
            if (stringArray2 != null && propertyValueProcessor != null) {
                for (int i = 0; i < stringArray2.length; ++i) {
                    stringArray2[i] = propertyValueProcessor.process(stringArray2[i]);
                }
            }
            stringArray = stringArray2;
        }
        return stringArray;
    }

    public static Set getStringSet(String string, String string2, PropertyValueProcessor propertyValueProcessor) {
        String[] stringArray = DMProperties.getStringArray(string, string2, propertyValueProcessor);
        HashSet<String> hashSet = null;
        if (stringArray != null) {
            hashSet = new HashSet<String>();
            for (int i = 0; i < stringArray.length; ++i) {
                hashSet.add(stringArray[i]);
            }
        }
        return hashSet;
    }

    static {
        D = Logger.getLogger(DMProperties.class.getName());
        DMProperties.initialise();
    }

    public static class LeadingHomePropertyValueProcessor
    implements PropertyValueProcessor {
        private final String A;

        public LeadingHomePropertyValueProcessor(String string) {
            this.A = string;
        }

        @Override
        public String process(String string) {
            if (string != null && string.startsWith("[home]")) {
                return this.A + string.substring("[home]".length());
            }
            return string;
        }
    }

    public static interface PropertyValueProcessor {
        public String process(String var1);
    }
}

