/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.util;

import java.util.Map;
import java.util.Properties;

public class Configuration {
    public static String P_KEY = "docmosis.key";
    public static String P_SITE = "docmosis.site";
    public static String P_TEMPLATE_STORE_LOCATION = "docmosis.template.store.location";
    public static String P_CONVERTER_POOL_CONFIG = "docmosis.document.converter.pool.config.override";
    public static String P_OFFICE_LOCATION = "docmosis.openoffice.location";
    public static String P_PLAIN_FIELD_PREFIX = "docmosis.analyzer.field.plainText.prefix";
    public static String P_PLAIN_FIELD_SUFFIX = "docmosis.analyzer.field.plainText.suffix";
    public static String P_FIELD_MARKUP_ENABLED = "docmosis.populator.field.markup.process";
    private final Properties A = new Properties();

    public Configuration() {
    }

    public Configuration(String string, String string2, String string3) {
        this(Configuration.getStandardConfiguration());
        this.setKeyAndSite(string, string2);
        this.setOfficeLocation(string3);
    }

    public Configuration(Properties properties) {
        if (properties != null) {
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                this.A.put(entry.getKey(), entry.getValue());
            }
        }
    }

    public Configuration setKeyAndSite(String string, String string2) {
        if (string != null && string.startsWith("docmosis.key=")) {
            string = string.substring("docmosis.key=".length());
        }
        if (string2 != null && string2.startsWith("docmosis.site=")) {
            string2 = string2.substring("docmosis.site=".length());
        }
        this.setProperty(P_KEY, string);
        this.setProperty(P_SITE, string2);
        return this;
    }

    public Configuration setOfficeLocation(String string) {
        this.setProperty(P_OFFICE_LOCATION, string);
        return this;
    }

    public Configuration setConverterPoolConfiguration(String string) {
        this.setProperty(P_CONVERTER_POOL_CONFIG, string);
        return this;
    }

    public Configuration setTemplateStoreLocation(String string) {
        this.setProperty(P_TEMPLATE_STORE_LOCATION, string);
        return this;
    }

    public Configuration setProperty(String string, String string2) {
        if (string2 == null) {
            this.A.remove(string);
        } else {
            this.A.put(string, string2);
        }
        return this;
    }

    public static Properties getStandardConfiguration() {
        Properties properties = new Properties();
        properties.setProperty(P_CONVERTER_POOL_CONFIG, "1");
        properties.setProperty(P_TEMPLATE_STORE_LOCATION, "./templatestore");
        properties.setProperty(P_FIELD_MARKUP_ENABLED, "true");
        properties.setProperty(P_PLAIN_FIELD_PREFIX, "<<");
        properties.setProperty(P_PLAIN_FIELD_SUFFIX, ">>");
        return properties;
    }

    public static Configuration standard() {
        return new Configuration(Configuration.getStandardConfiguration());
    }

    public Properties getProperties() {
        return (Properties)this.A.clone();
    }
}

