/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.util;

import com.docmosis.util.DMProperties;
import com.docmosis.util.FileUtilities;
import com.docmosis.util.NativeLibraryLoaderUtilities;
import com.docmosis.util.logging.LogManager;
import com.docmosis.util.logging.Logger;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;

public class ClassLoaderUtilities {
    private static final Logger E = LogManager.getLogger(ClassLoaderUtilities.class);
    private static final String D = DMProperties.getString("docmosis.openoffice.location");
    public static final String ADD_TO_SYSTEM_LOADER_PROPERTY = "docmosis.openoffice.libraries.loadIntoSystemCL";
    public static final boolean ADD_TO_SYSTEM_LOADER = DMProperties.getBoolean("docmosis.openoffice.libraries.loadIntoSystemCL", false);
    private static final String[] B;
    private static final String[] C;
    private static final boolean A;
    private static boolean F;

    public static void addOpenOfficeJars() throws IOException {
        E.debug("Adding OpenOffice JARs to existing classloader");
        if (!F) {
            ClassLoader classLoader;
            if (ADD_TO_SYSTEM_LOADER) {
                E.debug("Loading jars into System classloader");
                classLoader = ClassLoader.getSystemClassLoader();
            } else {
                E.debug("Loading jars into nearest URL classloader");
                for (classLoader = ClassLoaderUtilities.class.getClassLoader(); classLoader != null && !(classLoader instanceof URLClassLoader) && classLoader != ClassLoader.getSystemClassLoader(); classLoader = classLoader.getParent()) {
                }
            }
            ClassLoaderUtilities.addOpenOfficeJars(classLoader);
        } else {
            E.debug("Open Office Libraries are already loaded.");
        }
    }

    public static void addOpenOfficeJars(ClassLoader classLoader) throws IOException {
        if (classLoader instanceof URLClassLoader) {
            URLClassLoader uRLClassLoader = (URLClassLoader)classLoader;
            Class<URLClassLoader> clazz = URLClassLoader.class;
            try {
                File[] fileArray;
                Method method = clazz.getDeclaredMethod("addURL", URL.class);
                method.setAccessible(true);
                File[] fileArray2 = ClassLoaderUtilities.locateJars();
                if (fileArray2 != null) {
                    for (int i = 0; i < fileArray2.length; ++i) {
                        method.invoke((Object)uRLClassLoader, fileArray2[i].toURL());
                    }
                }
                if ((fileArray = NativeLibraryLoaderUtilities.getOONativeLibraryDirectories()) != null) {
                    for (int i = 0; i < fileArray.length; ++i) {
                        method.invoke((Object)uRLClassLoader, fileArray[i].toURL());
                    }
                }
                F = true;
            }
            catch (Throwable throwable) {
                E.fatal(throwable);
                throw new RuntimeException("Error, could not add URL to system classloader.  Consider setting property\"docmosis.openoffice.useCustomLoader\"=true", throwable);
            }
        } else {
            String string = classLoader == null ? "[null]" : classLoader.getClass().toString();
            E.fatal("Error occured, URLClassLoader expected but " + string + " received.  Could not continue.  Consider setting property" + "\"docmosis.openoffice.useCustomLoader\"=true");
        }
    }

    public static ClassLoader getOpenOfficeJarsClassLoader(ClassLoader classLoader) throws IOException {
        File[] fileArray;
        Object object;
        URL uRL;
        E.debug("Getting OpenOffice jars classloader");
        if (classLoader instanceof BarrierClassLoader) {
            E.debug("Reusing existing classloader");
            return classLoader;
        }
        ArrayList<URL> arrayList = new ArrayList<URL>();
        File[] fileArray2 = ClassLoaderUtilities.locateJars();
        if (fileArray2 != null) {
            for (int i = 0; i < fileArray2.length; ++i) {
                arrayList.add(fileArray2[i].toURL());
            }
        }
        if ((uRL = ClassLoaderUtilities.class.getClassLoader().getResource("com/docmosis/converter/openoffice/deployment marker.txt")) == null) {
            E.error("Class Path is missing the Docmosis OpenOffice code");
        } else {
            if (E.isDebugEnabled()) {
                E.debug("src base: " + uRL);
            }
            object = uRL.toString();
            if ((object = ((String)object).replaceAll("%20", " ")) != null) {
                object = ((String)object).substring(0, ((String)object).length() - "com/docmosis/converter/openoffice/deployment marker.txt".length());
            }
            if (object != null && ((String)object).indexOf("jar") != -1 && ((String)object).lastIndexOf(".jar") < ((String)object).length() - ".jar".length()) {
                object = ((String)object).substring(0, ((String)object).lastIndexOf(".jar") + ".jar".length());
            }
            if (object != null) {
                boolean bl = false;
                try {
                    arrayList.add(new URL((String)object));
                    bl = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (((String)object).endsWith(".jar")) {
                        arrayList.add(new URL((String)object + "!/"));
                    }
                    bl = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!bl) {
                    E.warn("Could not add \"" + (String)object + "\" (or derivative) as class loader URL");
                }
            }
        }
        object = new File("c:/projects/docmagnet/src/Test");
        if (((File)object).exists()) {
            arrayList.add(((File)object).toURL());
        }
        if ((fileArray = NativeLibraryLoaderUtilities.getOONativeLibraryDirectories()) != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                arrayList.add(fileArray[i].toURL());
            }
        }
        URL[] uRLArray = null;
        if (arrayList.size() > 0) {
            uRLArray = new URL[arrayList.size()];
            arrayList.toArray(uRLArray);
        }
        if (uRLArray == null) {
            return null;
        }
        BarrierClassLoader barrierClassLoader = new BarrierClassLoader(new String[]{"com.docmosis."}, uRLArray, classLoader);
        if (E.isDebugEnabled()) {
            E.debug("Custom ClassLoader created [" + barrierClassLoader + "] with parent [" + barrierClassLoader.getParent() + "]");
        }
        return barrierClassLoader;
    }

    private static File getTmpDir() throws IOException {
        File file = new File(System.getProperty("java.io.tmpdir"));
        if (!(file = new File(file, "docmosis/jars")).exists()) {
            file.mkdirs();
        } else {
            ClassLoaderUtilities.cleanupOld(file);
            if (!file.exists()) {
                file.mkdirs();
            }
        }
        int n = 1000;
        File file2 = null;
        for (int i = 0; i < 1000; ++i) {
            String string = "jar_" + System.currentTimeMillis() + (int)(Math.random() * 124523.0) + "_" + i;
            File file3 = new File(file, string);
            if (file3.exists()) continue;
            file3.mkdirs();
            file2 = file3;
            break;
        }
        if (file2 == null) {
            throw new IOException("Could not create unique random dir after 1000 attempts.");
        }
        if (!file2.canWrite()) {
            throw new IOException("Unable to write into temp area:" + file2.getPath());
        }
        return file2;
    }

    private static void cleanupOld(File file) {
        long l = System.currentTimeMillis() - 120000L;
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].lastModified() >= l) continue;
            if (fileArray[i].getName().startsWith("TODELETE")) {
                FileUtilities.deleteRecursively(fileArray[i]);
                continue;
            }
            fileArray[i].renameTo(new File(fileArray[i].getAbsoluteFile().getParent(), "TODELETE" + fileArray[i].getName()));
        }
    }

    private static File[] locateJars() {
        int n;
        Object object;
        int n2;
        HashMap<String, File[]> hashMap = new HashMap<String, File[]>();
        for (n2 = 0; n2 < C.length; ++n2) {
            object = null;
            for (n = 0; n < B.length; ++n) {
                Object object2;
                if (!new File(B[n]).isDirectory() || !((File)(object2 = new File(B[n], C[n2]))).exists()) continue;
                if (E.isDebugEnabled()) {
                    E.debug("Located:" + ((File)object2).getPath());
                }
                object = object2;
                break;
            }
            if (object == null) continue;
            hashMap.put(object.getName(), (File[])object);
        }
        if (hashMap.isEmpty()) {
            E.error("None of the required JAR files have been found");
        } else {
            for (n2 = 0; n2 < C.length; ++n2) {
                object = C[n2];
                n = hashMap.containsKey(object) ? 1 : 0;
                if (n != 0) {
                    E.info("Jar " + (String)object + " located");
                    continue;
                }
                if (!E.isDebugEnabled()) continue;
                E.info("Jar " + (String)object + " not found");
            }
        }
        ArrayList<Object> arrayList = new ArrayList(hashMap.values());
        if (A) {
            try {
                object = ClassLoaderUtilities.getTmpDir();
                ArrayList<File> arrayList2 = new ArrayList<File>();
                for (File file : arrayList) {
                    File file2 = new File((File)object, file.getName());
                    FileUtilities.copyFile(file, file2);
                    arrayList2.add(file2);
                }
                arrayList = arrayList2;
                if (E.isDebugEnabled()) {
                    E.debug("jars copied to temp location:" + object);
                }
            }
            catch (IOException iOException) {
                E.error("Error copying office jar files to temp", iOException);
            }
        }
        object = null;
        if (!arrayList.isEmpty()) {
            object = new File[arrayList.size()];
            arrayList.toArray((T[])object);
        }
        return object;
    }

    private static final String[] getJarLocationArray(String string) {
        return DMProperties.getStringArray(string, ";", new DMProperties.LeadingHomePropertyValueProcessor(D + "/"));
    }

    public static void dumpClassLoaderLineage(Class clazz) {
        String string = clazz == null ? "<null>" : clazz.getName();
        System.out.println("Dumping ClassLoader Lineage for class:" + string);
        if (clazz != null) {
            ClassLoaderUtilities.dumpClassLoaderLineage(clazz.getClassLoader(), "  ");
        }
    }

    public static void dumpClassLoaderLineage(ClassLoader classLoader, String string) {
        if (classLoader == null) {
            return;
        }
        System.out.println(string + "ClassLoader:" + classLoader.getClass().getName() + "@" + System.identityHashCode(classLoader));
        if (classLoader.getParent() != classLoader) {
            ClassLoaderUtilities.dumpClassLoaderLineage(classLoader.getParent(), string + "  ");
        }
    }

    static {
        A = DMProperties.getBoolean("docmosis.openoffice.jars.copy", true);
        F = false;
        try {
            B = ClassLoaderUtilities.getJarLocationArray("docmosis.openoffice.jars.searchpath");
            C = DMProperties.getStringArray("docmosis.openoffice.jars.list", ";");
        }
        catch (RuntimeException runtimeException) {
            E.fatal("Unexpected error using static initialiser");
            throw runtimeException;
        }
    }

    public static class BarrierClassLoader
    extends URLClassLoader {
        private static final Logger B = LogManager.getLogger(BarrierClassLoader.class);
        private final String[] A;

        public BarrierClassLoader(String[] stringArray, URL[] uRLArray, ClassLoader classLoader) {
            super(uRLArray, classLoader);
            this.A = stringArray;
            if (B.isDebugEnabled()) {
                for (int i = 0; i < uRLArray.length; ++i) {
                    B.debug("BARRIER url:" + uRLArray[i]);
                }
            }
        }

        public Class loadClass(String string) throws ClassNotFoundException {
            boolean bl = B.isDebugEnabled();
            boolean bl2 = false;
            for (int i = 0; i < this.A.length; ++i) {
                if (!string.startsWith(this.A[i]) || string.indexOf("openoffice") == -1) continue;
                bl2 = true;
                break;
            }
            if (bl2) {
                Class<?> clazz;
                if (bl) {
                    B.debug("barrier: might load " + string);
                }
                if ((clazz = this.findLoadedClass(string)) == null) {
                    try {
                        clazz = this.findClass(string);
                        this.resolveClass(clazz);
                        if (bl) {
                            B.debug("CUSTOM Loaded:" + string);
                        }
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        if (bl) {
                            B.debug("Barrier: could not load class: " + string + " exception ClassNotFoundException:" + classNotFoundException.getMessage());
                        }
                        clazz = super.loadClass(string);
                    }
                }
                return clazz;
            }
            if (bl) {
                B.debug("barrier: parent can load " + string);
            }
            return super.loadClass(string);
        }
    }
}

