/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.util;

import java.math.BigInteger;

public class Base62Util {
    public static final String ALPHABET = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    public static final int ALPHABET_LEN = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".length();
    public static final BigInteger ALPHABET_LEN_BI = new BigInteger(String.valueOf("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".length()));

    public static String fromBase10(long l) {
        return Base62Util.fromBase10(String.valueOf(l));
    }

    public static String fromBase10(String string) {
        StringBuffer stringBuffer = new StringBuffer("");
        if ("0".equals(string)) {
            return String.valueOf(ALPHABET.charAt(0));
        }
        BigInteger bigInteger = new BigInteger("0");
        BigInteger bigInteger2 = new BigInteger(string);
        while (bigInteger2.compareTo(bigInteger) > 0) {
            bigInteger2 = Base62Util.fromBase10(bigInteger2, stringBuffer);
        }
        return stringBuffer.reverse().toString();
    }

    private static BigInteger fromBase10(BigInteger bigInteger, StringBuffer stringBuffer) {
        int n = bigInteger.mod(ALPHABET_LEN_BI).intValue();
        stringBuffer.append(ALPHABET.charAt(n));
        return bigInteger.divide(ALPHABET_LEN_BI);
    }

    public static String toBase10(String string) {
        return Base62Util.toBase10(new StringBuffer(string).reverse().toString().toCharArray()).toString();
    }

    private static BigInteger toBase10(char[] cArray) {
        BigInteger bigInteger = new BigInteger("0");
        for (int i = cArray.length - 1; i >= 0; --i) {
            bigInteger = bigInteger.add(Base62Util.toBase10(ALPHABET.indexOf(cArray[i]), i));
        }
        return bigInteger;
    }

    private static BigInteger toBase10(int n, int n2) {
        return new BigInteger(String.valueOf(n)).multiply(ALPHABET_LEN_BI.pow(n2));
    }

    public static void main(String[] stringArray) {
        BigInteger bigInteger = new BigInteger(String.valueOf(Integer.MAX_VALUE)).add(new BigInteger("15"));
        System.out.println(bigInteger + "=>" + Base62Util.fromBase10(bigInteger.toString()));
        System.out.println("min base:2");
        System.out.println("max base:36");
    }
}

