/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.util;

import java.math.BigInteger;

public class Base36Util {
    public static final String ALPHABET = "PYTKEJBDAISM64W8U975VCNLRFO0ZX1Q3G2H";
    public static final int ALPHABET_LEN = "PYTKEJBDAISM64W8U975VCNLRFO0ZX1Q3G2H".length();
    public static final BigInteger ALPHABET_LEN_BI = new BigInteger(String.valueOf("PYTKEJBDAISM64W8U975VCNLRFO0ZX1Q3G2H".length()));

    public static String fromBase10(long l) {
        return Base36Util.fromBase10(String.valueOf(l));
    }

    public static String fromBase10(String string) {
        StringBuffer stringBuffer = new StringBuffer("");
        if ("0".equals(string)) {
            return String.valueOf(ALPHABET.charAt(0));
        }
        BigInteger bigInteger = new BigInteger("0");
        BigInteger bigInteger2 = new BigInteger(string);
        while (bigInteger2.compareTo(bigInteger) > 0) {
            bigInteger2 = Base36Util.fromBase10(bigInteger2, stringBuffer);
        }
        return stringBuffer.reverse().toString();
    }

    private static BigInteger fromBase10(BigInteger bigInteger, StringBuffer stringBuffer) {
        int n = bigInteger.mod(ALPHABET_LEN_BI).intValue();
        stringBuffer.append(ALPHABET.charAt(n));
        return bigInteger.divide(ALPHABET_LEN_BI);
    }

    public static String toBase10(String string) {
        return Base36Util.toBase10(new StringBuffer(string).reverse().toString().toCharArray()).toString();
    }

    private static BigInteger toBase10(char[] cArray) {
        BigInteger bigInteger = new BigInteger("0");
        for (int i = cArray.length - 1; i >= 0; --i) {
            bigInteger = bigInteger.add(Base36Util.toBase10(ALPHABET.indexOf(cArray[i]), i));
        }
        return bigInteger;
    }

    public static char[] getAlphabet() {
        return ALPHABET.toCharArray();
    }

    public static char randomCharacter() {
        return ALPHABET.charAt((int)(Math.random() * (double)ALPHABET_LEN));
    }

    private static BigInteger toBase10(int n, int n2) {
        return new BigInteger(String.valueOf(n)).multiply(ALPHABET_LEN_BI.pow(n2));
    }
}

