/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.template.store.openoffice;

import com.docmosis.template.Template;
import com.docmosis.template.TemplateAlreadyExistsException;
import com.docmosis.template.TemplateDetails;
import com.docmosis.template.TemplateNotFoundException;
import com.docmosis.template.TemplateParseException;
import com.docmosis.template.TemplateStoreException;
import com.docmosis.template.analysis.ImageAnalysis;
import com.docmosis.template.analysis.TemplateAnalysis;
import com.docmosis.template.analysis.openoffice.ODFContentAnalyzer;
import com.docmosis.template.analysis.openoffice.ODFTemplateAnalysis;
import com.docmosis.template.analysis.openoffice.ProcessingContentFile;
import com.docmosis.template.store.TemplateContext;
import com.docmosis.template.store.TemplateIdentifier;
import com.docmosis.template.store.TemplateStore;
import com.docmosis.template.store.openoffice.TemplatePreProcessor;
import com.docmosis.util.B;
import com.docmosis.util.DMProperties;
import com.docmosis.util.Equivalence;
import com.docmosis.util.FileUtilities;
import com.docmosis.util.J;
import com.docmosis.util.MultiInputStreamBuilder;
import com.docmosis.util.StringUtilities;
import com.docmosis.util.logging.LogManager;
import com.docmosis.util.logging.Logger;
import com.docmosis.util.properties.PropertiesProvider;
import com.docmosis.util.thirdparty.ImageInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ODFAnalyzingStore
implements TemplateStore {
    private static final Logger G = LogManager.getLogger(ODFAnalyzingStore.class);
    private static final String H = "docmosis.analyzer.preprocessor.enabled";
    private static final String J = "docmosis.populator.metaFile.processing.enabled";
    private static final boolean E = DMProperties.getBoolean("docmosis.populator.metaFile.processing.enabled", false);
    private static boolean M = DMProperties.getBoolean("docmosis.analyzer.stripLayoutCache", false);
    private static final String F = "Pictures/";
    private static final List L = new ArrayList();
    private static final int I = 8192;
    private static final ThreadLocal N;
    private TemplateStore K;

    public ODFAnalyzingStore(TemplateStore templateStore) {
        this.K = templateStore;
    }

    @Override
    public TemplateDetails[] findByContext(TemplateContext templateContext, boolean bl) throws IOException, TemplateStoreException {
        return this.K.findByContext(templateContext, bl);
    }

    @Override
    public InputStream getOriginalTemplate(TemplateIdentifier templateIdentifier) throws IOException, TemplateNotFoundException {
        return this.K.getOriginalTemplate(templateIdentifier);
    }

    @Override
    public void deleteAll() throws TemplateStoreException {
        this.K.deleteAll();
    }

    @Override
    public void deleteTemplate(TemplateIdentifier templateIdentifier) throws TemplateStoreException {
        this.K.deleteTemplate(templateIdentifier);
    }

    @Override
    public void deleteTemplates(TemplateContext templateContext, boolean bl) throws TemplateStoreException {
        this.K.deleteTemplates(templateContext, bl);
    }

    @Override
    public long getTemplateStoredTime(TemplateIdentifier templateIdentifier) throws TemplateStoreException {
        return this.K.getTemplateStoredTime(templateIdentifier);
    }

    @Override
    public Template getTemplate(TemplateIdentifier templateIdentifier) throws IOException, TemplateNotFoundException, TemplateStoreException {
        return this.K.getTemplate(templateIdentifier);
    }

    @Override
    public TemplateDetails storeTemplate(TemplateIdentifier templateIdentifier, InputStream inputStream, Long l, InputStream inputStream2, TemplateAnalysis templateAnalysis, InputStream inputStream3, boolean bl, boolean bl2, String string, String string2, boolean bl3, PropertiesProvider propertiesProvider) throws IOException, TemplateAlreadyExistsException, TemplateStoreException {
        TemplateDetails templateDetails;
        MessageDigest messageDigest = B.B();
        DigestInputStream digestInputStream = new DigestInputStream(inputStream, messageDigest);
        File file = FileUtilities.createTempFile("dms", ".tmp");
        ExplodedFileSet explodedFileSet = null;
        FileInputStream fileInputStream = null;
        FileInputStream fileInputStream2 = null;
        try {
            Object object;
            FileUtilities.storeToFile(digestInputStream, file);
            explodedFileSet = this.explodeTemplate(inputStream2);
            boolean bl4 = DMProperties.getBoolean(H, true);
            if (bl4) {
                object = new TemplatePreProcessor();
                ((TemplatePreProcessor)object).preProcess(explodedFileSet);
            }
            if (explodedFileSet.getThumbnail() != null) {
                fileInputStream = new FileInputStream(explodedFileSet.getThumbnail());
            }
            object = (ODFTemplateAnalysis)this.analyze(explodedFileSet, bl2, string, string2, templateAnalysis, bl3, propertiesProvider);
            ((ODFTemplateAnalysis)object).setOriginalMD5(B.getHexString(messageDigest, digestInputStream));
            MultiInputStreamBuilder multiInputStreamBuilder = new MultiInputStreamBuilder(explodedFileSet.getFiles());
            fileInputStream2 = new FileInputStream(file);
            TemplateDetails templateDetails2 = this.K.storeTemplate(templateIdentifier, fileInputStream2, l, multiInputStreamBuilder, (TemplateAnalysis)object, fileInputStream, bl, bl2, string, string2, bl3, propertiesProvider);
            if (G.isDebugEnabled()) {
                G.debug("Stored Name: " + templateIdentifier.getName());
                G.debug("Stored Context: " + templateIdentifier.getContext());
                G.debug("Stored MD5: " + ((ODFTemplateAnalysis)object).getOriginalMD5());
            }
            templateDetails = templateDetails2;
        }
        catch (TemplateParseException templateParseException) {
            try {
                throw new TemplateStoreException(templateParseException);
            }
            catch (Throwable throwable) {
                FileUtilities.close(fileInputStream2);
                FileUtilities.delete(file);
                digestInputStream = null;
                FileUtilities.close(fileInputStream);
                ExplodedFileSet.delete(explodedFileSet);
                throw throwable;
            }
        }
        FileUtilities.close(fileInputStream2);
        FileUtilities.delete(file);
        digestInputStream = null;
        FileUtilities.close(fileInputStream);
        ExplodedFileSet.delete(explodedFileSet);
        return templateDetails;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TemplateAnalysis analyze(ExplodedFileSet explodedFileSet, boolean bl, String string, String string2, TemplateAnalysis templateAnalysis, boolean bl2, PropertiesProvider propertiesProvider) throws IOException, TemplateParseException {
        Object object;
        FileInputStream fileInputStream = null;
        try {
            Object object2;
            Object object3;
            ODFContentAnalyzer oDFContentAnalyzer;
            ODFTemplateAnalysis oDFTemplateAnalysis = null;
            fileInputStream = new FileInputStream(explodedFileSet.getFiles()[0]);
            J j = null;
            try {
                oDFContentAnalyzer = new ODFContentAnalyzer(ProcessingContentFile.CONTENT, templateAnalysis);
                oDFTemplateAnalysis = oDFContentAnalyzer.process(fileInputStream, bl, string, string2, bl2, propertiesProvider);
                j = oDFContentAnalyzer.getStylesToPromoteToStylesXml();
            }
            finally {
                FileUtilities.close(fileInputStream);
            }
            ODFTemplateAnalysis oDFTemplateAnalysis2 = null;
            fileInputStream = new FileInputStream(explodedFileSet.getFiles()[1]);
            try {
                object3 = new ODFContentAnalyzer(ProcessingContentFile.STYLES, null);
                ((ODFContentAnalyzer)object3).setStylesToPromoteToStylesXml(j);
                ((ODFContentAnalyzer)object3).setListStylesOfInterest(oDFContentAnalyzer.getListStylesOfInterest());
                oDFTemplateAnalysis2 = ((ODFContentAnalyzer)object3).process(fileInputStream, bl, string, string2, bl2, propertiesProvider);
            }
            finally {
                FileUtilities.close(fileInputStream);
            }
            object3 = null;
            if (E) {
                fileInputStream = new FileInputStream(explodedFileSet.getFiles()[3]);
                try {
                    object2 = new ODFContentAnalyzer(ProcessingContentFile.META, null);
                    object3 = ((ODFContentAnalyzer)object2).process(fileInputStream, bl, string, string2, bl2, propertiesProvider);
                }
                finally {
                    FileUtilities.close(fileInputStream);
                }
            }
            object2 = null;
            fileInputStream = new FileInputStream(explodedFileSet.getFiles()[2]);
            try {
                object = new ODFContentAnalyzer(ProcessingContentFile.MANIFEST, null);
                object2 = ((ODFContentAnalyzer)object).process(fileInputStream, bl, string, string2, bl2, propertiesProvider);
            }
            finally {
                FileUtilities.close(fileInputStream);
            }
            oDFTemplateAnalysis.setStyleAnalysis(oDFTemplateAnalysis2);
            oDFTemplateAnalysis.setManifestAnalysis(((ODFTemplateAnalysis)object2).getManifestAnalysis());
            oDFTemplateAnalysis.setMetaAnalysis((TemplateAnalysis)object3);
            oDFTemplateAnalysis.setTemplateImages(explodedFileSet.getImageAnalysis());
            if (templateAnalysis != null) {
                oDFTemplateAnalysis.setProcessedWithExternalConverter(templateAnalysis.getProcessedWithExternalConverter());
                oDFTemplateAnalysis.setFontInfo(templateAnalysis.getFontInfo());
                oDFTemplateAnalysis.setSensitivityLabelInfo(templateAnalysis.getSensitivityLabelInfo());
                oDFTemplateAnalysis.setExternalResources(templateAnalysis.getExternalResources());
                oDFTemplateAnalysis.setHasExternalResourcesPermissionFailures(templateAnalysis.hasExternalResourcesPermisionFailures());
            }
            oDFTemplateAnalysis.setProcessedAllowingPaddedFields(bl2);
            object = oDFTemplateAnalysis;
        }
        catch (Throwable throwable) {
            FileUtilities.close(fileInputStream);
            throw throwable;
        }
        FileUtilities.close(fileInputStream);
        return object;
    }

    @Override
    public TemplateAnalysis getTemplateAnalysis(TemplateIdentifier templateIdentifier) throws IOException, TemplateNotFoundException, TemplateStoreException {
        return this.K.getTemplateAnalysis(templateIdentifier);
    }

    private ExplodedFileSet explodeTemplate(InputStream inputStream) throws IOException {
        return this.explodeTemplate(inputStream, L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExplodedFileSet explodeTemplate(InputStream inputStream, List list) throws IOException {
        File file = ExplodedFileSet.createExplodedWorkingDir(null);
        ZipOutputStream zipOutputStream = null;
        OutputStream outputStream = null;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        File file2 = null;
        try {
            ImageAnalysis.ImageDetail[] imageDetailArray;
            File[] fileArray;
            ZipEntry zipEntry;
            file2 = FileUtilities.createTempFile("dm_", "xpl", file);
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            ZipInputStream zipInputStream = new ZipInputStream(inputStream);
            zipOutputStream = new ZipOutputStream(new FileOutputStream(file2));
            File file3 = null;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                Object object;
                fileArray = _A.A(list, zipEntry.getName());
                if (fileArray != null) {
                    String string = StringUtilities.stripDirectoryFromPath(zipEntry.getName());
                    object = new _B(new File(file, string), fileArray.B());
                    imageDetailArray = new FileOutputStream(((_B)object).B);
                    try {
                        this.writeOut(zipInputStream, zipEntry, (OutputStream)imageDetailArray);
                    }
                    finally {
                        imageDetailArray.close();
                    }
                    if (fileArray.C()) {
                        arrayList2.add(object);
                    } else {
                        zipOutputStream.putNextEntry(new ZipEntry(zipEntry.getName()));
                        FileUtilities.streamOut(((_B)object).B, zipOutputStream);
                        zipOutputStream.closeEntry();
                    }
                    if (!fileArray.A()) continue;
                    file3 = ((_B)object).B;
                    continue;
                }
                if (M && "layout-cache".equals(zipEntry.getName())) {
                    G.debug("dropping layout-cache");
                    continue;
                }
                if (zipEntry.getName().startsWith(F)) {
                    object = null;
                    try {
                        object = ODFAnalyzingStore.analyzeTemplateImage(zipInputStream, zipEntry, zipOutputStream);
                    }
                    catch (CannotDetermineImageInfoException cannotDetermineImageInfoException) {
                        G.info("Cannot determine template image details (not a problem unless image is for placeholding):" + cannotDetermineImageInfoException.getMessage());
                    }
                    if (object == null) continue;
                    arrayList.add(object);
                    continue;
                }
                zipOutputStream.putNextEntry(new ZipEntry(zipEntry.getName()));
                this.writeOut(zipInputStream, zipEntry, zipOutputStream);
                zipOutputStream.closeEntry();
            }
            zipOutputStream.close();
            fileArray = null;
            if (!arrayList2.isEmpty()) {
                Collections.sort(arrayList2, new Comparator(){

                    public int compare(Object object, Object object2) {
                        int n;
                        int n2 = ((_B)object).A;
                        if (n2 == (n = ((_B)object2).A)) {
                            return 0;
                        }
                        if (n2 < n) {
                            return -1;
                        }
                        return 1;
                    }
                });
                fileArray = new File[arrayList2.size()];
                for (int i = 0; i < fileArray.length; ++i) {
                    fileArray[i] = ((_B)arrayList2.get(i)).B;
                }
            }
            ImageAnalysis imageAnalysis = null;
            if (!arrayList.isEmpty()) {
                imageDetailArray = null;
                imageDetailArray = new ImageAnalysis.ImageDetail[arrayList.size()];
                arrayList.toArray(imageDetailArray);
                imageAnalysis = new ImageAnalysis();
                imageAnalysis.setImages(imageDetailArray);
            }
            return new ExplodedFileSet(file, fileArray, file2, file3, imageAnalysis);
        }
        catch (IOException iOException) {
            FileUtilities.close(zipOutputStream);
            FileUtilities.close(outputStream);
            FileUtilities.deleteRecursively(file);
            FileUtilities.delete(file2);
            throw iOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ImageAnalysis.ImageDetail analyzeTemplateImage(ZipInputStream zipInputStream, ZipEntry zipEntry, ZipOutputStream zipOutputStream) throws IOException, CannotDetermineImageInfoException {
        ImageAnalysis.ImageDetail imageDetail = null;
        if (!zipEntry.isDirectory()) {
            File file = FileUtilities.createTempFile("dmim", "zin");
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
            try {
                FileUtilities.streamOut(zipInputStream, file);
                ImageInfo imageInfo = new ImageInfo();
                imageInfo.setInput(randomAccessFile);
                imageInfo.setDetermineImageNumber(true);
                boolean bl = true;
                if (!imageInfo.check()) {
                    bl = false;
                }
                String string = zipEntry.getName().startsWith(F) ? zipEntry.getName().substring(F.length()) : zipEntry.getName();
                imageDetail = new ImageAnalysis.ImageDetail(string, file.length(), imageInfo.getWidth(), imageInfo.getHeight(), imageInfo.getBitsPerPixel());
                zipOutputStream.putNextEntry(new ZipEntry(zipEntry.getName()));
                FileUtilities.streamOut(file, zipOutputStream);
                zipOutputStream.closeEntry();
                if (!bl) {
                    throw new CannotDetermineImageInfoException("Image:" + zipEntry.getName());
                }
            }
            finally {
                randomAccessFile.close();
                FileUtilities.delete(file);
            }
        }
        return imageDetail;
    }

    private void writeOut(ZipInputStream zipInputStream, ZipEntry zipEntry, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = (byte[])N.get();
        while ((n = zipInputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    static {
        L.add(new _A("content.xml", true, L.size()));
        L.add(new _A("styles.xml", true, L.size()));
        L.add(new _A("META-INF/manifest.xml", true, L.size()));
        if (E) {
            L.add(new _A("meta.xml", true, L.size()));
        }
        L.add(new _A("Thumbnails/thumbnail.png", false, true, L.size()));
        N = new ThreadLocal(){

            protected Object initialValue() {
                return new byte[8192];
            }
        };
    }

    public static class CannotDetermineImageInfoException
    extends Exception {
        public CannotDetermineImageInfoException() {
        }

        public CannotDetermineImageInfoException(String string, Throwable throwable) {
            super(string, throwable);
        }

        public CannotDetermineImageInfoException(String string) {
            super(string);
        }

        public CannotDetermineImageInfoException(Throwable throwable) {
            super(throwable);
        }
    }

    public static class ExplodedFileSet {
        final File rootDir;
        final File[] explodedFiles;
        final File remainingODF;
        final File thumbnail;
        final ImageAnalysis imageAnalysis;

        public ExplodedFileSet(File file, File[] fileArray, File file2, File file3, ImageAnalysis imageAnalysis) {
            this.rootDir = file;
            this.remainingODF = file2;
            this.explodedFiles = fileArray;
            this.thumbnail = file3;
            this.imageAnalysis = imageAnalysis;
        }

        public File[] getFiles() {
            File[] fileArray = new File[this.explodedFiles.length + 1];
            System.arraycopy(this.explodedFiles, 0, fileArray, 0, this.explodedFiles.length);
            fileArray[fileArray.length - 1] = this.remainingODF;
            return fileArray;
        }

        public File getThumbnail() {
            return this.thumbnail;
        }

        public static void delete(ExplodedFileSet explodedFileSet) {
            if (explodedFileSet != null) {
                explodedFileSet.delete();
            }
        }

        public void delete() {
            FileUtilities.deleteRecursively(this.rootDir);
        }

        public ImageAnalysis getImageAnalysis() {
            return this.imageAnalysis;
        }

        public static File createExplodedWorkingDir(String string) throws IOException {
            return FileUtilities.createTempDir("dm_" + (string == null ? "" : string + "_"), "xpl");
        }

        public File duplicate(String string) throws IOException {
            File file = ExplodedFileSet.createExplodedWorkingDir(string);
            FileUtilities.copyDir(this.rootDir, file);
            return file;
        }
    }

    private static class _A {
        private final String B;
        private final boolean D;
        private final boolean C;
        private final int A;

        public _A(String string, boolean bl, int n) {
            this(string, bl, false, n);
        }

        public _A(String string, boolean bl, boolean bl2, int n) {
            this.B = string;
            this.D = bl;
            this.C = bl2;
            this.A = n;
        }

        public boolean C() {
            return this.D;
        }

        public boolean A() {
            return this.C;
        }

        public int B() {
            return this.A;
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof _A)) {
                return false;
            }
            if (object == this) {
                return true;
            }
            return Equivalence.equivalentObjects(this.B, ((_A)object).B);
        }

        public int hashCode() {
            return this.B == null ? 0 : this.B.hashCode();
        }

        public static _A A(List list, String string) {
            _A _A2 = null;
            if (list != null && string != null) {
                for (_A _A3 : list) {
                    if (!string.equals(_A3.B)) continue;
                    _A2 = _A3;
                    break;
                }
            }
            return _A2;
        }
    }

    private static class _B {
        private final File B;
        private final int A;

        public _B(File file, int n) {
            this.B = file;
            this.A = n;
        }
    }
}

