/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.template.store.file;

import com.docmosis.template.TemplateDetails;
import com.docmosis.template.analysis.TemplateAnalysis;
import com.docmosis.template.store.TemplateIdentifier;
import com.docmosis.util.FileUtilities;
import com.docmosis.util.logging.LogManager;
import com.docmosis.util.logging.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class SimpleTemplateFiles {
    private static final Logger F = LogManager.getLogger(SimpleTemplateFiles.class);
    public static final String TEMPLATE_DIR_MARKER_FILE = ".templateMarker";
    private static final String I = "analysis";
    private static final String J = "thumbnail.png";
    private static long A;
    protected File templateRoot;
    private TemplateIdentifier C;
    private File E;
    private File H;
    private File G;
    private File D;
    private File B;

    public SimpleTemplateFiles(File file, TemplateIdentifier templateIdentifier) throws IOException {
        if (F.isTraceEnabled()) {
            F.trace("Root Dir: " + file);
            F.trace("Template Name: " + templateIdentifier.getName());
            F.trace("Template Context: " + templateIdentifier.getContext());
        }
        this.C = templateIdentifier;
        if (this.C == null || this.C.getName() == null) {
            throw new IllegalArgumentException("bad templateId or templateId.name");
        }
        this.templateRoot = SimpleTemplateFiles.templateIdToFile(file, this.C);
        String string = FileUtilities.relativePathToAbsolute(file.getAbsolutePath().replaceAll("\\\\", "/"));
        String string2 = FileUtilities.relativePathToAbsolute(this.templateRoot.getAbsolutePath().replaceAll("\\\\", "/"));
        if (!string2.startsWith(string)) {
            throw new IOException("Bad template path (outside template store folder)");
        }
    }

    private File templateMarkerFile() {
        if (this.E == null) {
            this.E = new File(this.templateRoot, TEMPLATE_DIR_MARKER_FILE);
        }
        return this.E;
    }

    private File workingTemplateFile() {
        if (this.G == null) {
            this.G = new File(this.templateRoot, this.C.getName() + ".wrk");
        }
        return this.G;
    }

    private File origTemplateFile() {
        if (this.H == null) {
            this.H = new File(this.templateRoot, this.C.getName() + ".orig");
        }
        return this.H;
    }

    private File analysisFile() {
        if (this.D == null) {
            this.D = new File(this.templateRoot, I);
        }
        return this.D;
    }

    private File thumbnailFile() {
        if (this.B == null) {
            this.B = new File(this.templateRoot, J);
        }
        return this.B;
    }

    protected static File templateIdToFile(File file, TemplateIdentifier templateIdentifier) {
        File file2;
        if (templateIdentifier.getContext() == null) {
            file2 = new File(file, templateIdentifier.getName());
        } else {
            String string = templateIdentifier.getContext().getPath();
            boolean bl = string.startsWith("/");
            boolean bl2 = string.endsWith("/");
            StringBuffer stringBuffer = new StringBuffer(string.length() + templateIdentifier.getName().length() + 5);
            if (!bl) {
                stringBuffer.append("/");
            }
            stringBuffer.append(string);
            if (!bl2) {
                stringBuffer.append("/");
            }
            stringBuffer.append(templateIdentifier.getName());
            file2 = new File(file, stringBuffer.toString());
        }
        return file2;
    }

    public boolean exists() {
        return this.templateRoot.exists();
    }

    public File getAnalysisFile() {
        return this.analysisFile();
    }

    public boolean analysisExists() {
        return this.analysisFile().exists();
    }

    public boolean workingFileExists() {
        return this.workingTemplateFile().exists();
    }

    public File getWorkingFile() {
        return this.workingTemplateFile();
    }

    public File getThumbnailFile() {
        return this.thumbnailFile();
    }

    public boolean thumbnailFileExists() {
        return this.thumbnailFile().exists();
    }

    public InputStream getWorkingFileInputStream() throws IOException {
        return new FileInputStream(this.workingTemplateFile());
    }

    public boolean origFileExists() {
        return this.origTemplateFile().exists();
    }

    public File getOrigFile() {
        return this.origTemplateFile();
    }

    public InputStream getOrigFileInputStream() throws IOException {
        return new FileInputStream(this.origTemplateFile());
    }

    public OutputStream getWorkingFileOutputStream() throws IOException {
        return new FileOutputStream(this.workingTemplateFile());
    }

    public OutputStream getOrigFileOutputStream() throws IOException {
        return new FileOutputStream(this.origTemplateFile());
    }

    public OutputStream getAnalysisFileOutputStream() throws IOException {
        return new FileOutputStream(this.analysisFile());
    }

    public InputStream getAnalysisFileInputStream() throws IOException {
        return new FileInputStream(this.analysisFile());
    }

    public void clearFiles() throws IOException {
        CharSequence charSequence;
        File file;
        int n = 0;
        do {
            charSequence = new StringBuffer();
            charSequence.append(this.templateRoot.getName()).append(String.valueOf(System.currentTimeMillis())).append(".").append(String.valueOf(A++)).append(".").append(String.valueOf((long)(Math.random() * 1.240235345345345E15)));
            String string = charSequence.toString();
            file = new File(this.templateRoot.getParent(), string);
        } while (n++ < 10 && file.exists());
        if (file.exists()) {
            throw new IOException("can't create a safe delete point");
        }
        if (!this.templateRoot.renameTo(file)) {
            charSequence = "Unable to clear away old template [ " + this.templateRoot.toString() + "]. In use?";
            F.error(charSequence);
            throw new IOException((String)charSequence);
        }
        boolean bl = FileUtilities.deleteRecursively(file);
        if (!bl) {
            F.warn("Could not delete entire template:" + file.getPath());
        }
    }

    public void createTemplateRoot() throws IOException {
        if (!this.templateMarkerFile().exists()) {
            this.templateRoot.mkdirs();
            if (!this.templateRoot.exists()) {
                throw new IOException("Unable to create template in " + this.templateRoot.getPath());
            }
            new FileOutputStream(this.templateMarkerFile()).close();
        }
    }

    public TemplateDetails getTemplateDetails(TemplateAnalysis templateAnalysis) {
        File file = this.origTemplateFile();
        File file2 = this.workingTemplateFile();
        long l = file != null ? file.length() : -1L;
        long l2 = file != null ? file.lastModified() : -1L;
        long l3 = file2 != null ? file2.length() : -1L;
        long l4 = file2 != null ? file2.lastModified() : -1L;
        TemplateDetails templateDetails = new TemplateDetails(this.C, l, l2, l3, l4, templateAnalysis, this.thumbnailFile());
        return templateDetails;
    }

    public void cleanup() {
        this.templateRoot = null;
        this.C = null;
        this.H = null;
        this.G = null;
        this.D = null;
        this.B = null;
        this.E = null;
    }

    protected void finalize() throws Throwable {
        if (this.templateRoot != null || this.C != null || this.H != null || this.G != null || this.D != null || this.B != null) {
            F.warn("Cleanup in finalizer");
            this.cleanup();
        }
        super.finalize();
    }

    public static boolean isTemplateDirectory(File file) throws IOException {
        return file.isDirectory() && new File(file, TEMPLATE_DIR_MARKER_FILE).canRead();
    }
}

