/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.template.store.file;

import com.docmosis.template.SimpleTemplate;
import com.docmosis.template.Template;
import com.docmosis.template.TemplateAlreadyExistsException;
import com.docmosis.template.TemplateDetails;
import com.docmosis.template.TemplateNotFoundException;
import com.docmosis.template.TemplateStoreException;
import com.docmosis.template.analysis.TemplateAnalysis;
import com.docmosis.template.store.TemplateContext;
import com.docmosis.template.store.TemplateIdentifier;
import com.docmosis.template.store.TemplateStore;
import com.docmosis.template.store.file.SimpleTemplateFiles;
import com.docmosis.util.Equivalence;
import com.docmosis.util.FileUtilities;
import com.docmosis.util.StringUtilities;
import com.docmosis.util.logging.LogManager;
import com.docmosis.util.logging.Logger;
import com.docmosis.util.properties.PropertiesProvider;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.List;

public class FileTemplateStore
implements TemplateStore {
    private static final Logger c = LogManager.getLogger(FileTemplateStore.class);
    static final String ORIG_TEMPLATE_SUFFIX = ".orig";
    private File b;

    public FileTemplateStore(File file) {
        this.b = file;
        file.mkdirs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Template getTemplate(TemplateIdentifier templateIdentifier) throws IOException, TemplateStoreException {
        SimpleTemplateFiles simpleTemplateFiles = new SimpleTemplateFiles(this.b, templateIdentifier);
        try {
            SimpleTemplate simpleTemplate;
            block8: {
                if (!simpleTemplateFiles.workingFileExists()) {
                    throw new TemplateNotFoundException("working template not found: " + templateIdentifier);
                }
                SimpleTemplate simpleTemplate2 = new SimpleTemplate();
                boolean bl = false;
                InputStream inputStream = simpleTemplateFiles.getWorkingFileInputStream();
                try {
                    simpleTemplate2.setInputStream(inputStream);
                    simpleTemplate2.setId(templateIdentifier);
                    TemplateAnalysis templateAnalysis = this.getTemplateAnalysis(templateIdentifier, simpleTemplateFiles);
                    simpleTemplate2.setAnalysis(templateAnalysis);
                    simpleTemplate2.setDetails(simpleTemplateFiles.getTemplateDetails(templateAnalysis));
                    bl = true;
                    simpleTemplate = simpleTemplate2;
                    if (bl) break block8;
                }
                catch (Throwable throwable) {
                    if (!bl) {
                        FileUtilities.close(inputStream);
                        simpleTemplate2.cleanup();
                    }
                    throw throwable;
                }
                FileUtilities.close(inputStream);
                simpleTemplate2.cleanup();
            }
            return simpleTemplate;
        }
        finally {
            simpleTemplateFiles.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TemplateDetails getTemplateDetails(TemplateIdentifier templateIdentifier) throws IOException, TemplateStoreException {
        SimpleTemplateFiles simpleTemplateFiles = new SimpleTemplateFiles(this.b, templateIdentifier);
        try {
            TemplateDetails templateDetails;
            if (!simpleTemplateFiles.workingFileExists()) {
                throw new TemplateNotFoundException("working template not found: " + templateIdentifier);
            }
            TemplateDetails templateDetails2 = templateDetails = simpleTemplateFiles.getTemplateDetails(this.getTemplateAnalysis(templateIdentifier, simpleTemplateFiles));
            return templateDetails2;
        }
        finally {
            simpleTemplateFiles.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getOriginalTemplate(TemplateIdentifier templateIdentifier) throws IOException, TemplateNotFoundException {
        SimpleTemplateFiles simpleTemplateFiles = new SimpleTemplateFiles(this.b, templateIdentifier);
        InputStream inputStream = null;
        try {
            if (simpleTemplateFiles.origFileExists()) {
                inputStream = simpleTemplateFiles.getOrigFileInputStream();
            } else if (simpleTemplateFiles.workingFileExists()) {
                inputStream = simpleTemplateFiles.getWorkingFileInputStream();
            } else {
                throw new TemplateNotFoundException(templateIdentifier.toString());
            }
            InputStream inputStream2 = inputStream;
            return inputStream2;
        }
        finally {
            simpleTemplateFiles.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TemplateDetails storeTemplate(TemplateIdentifier templateIdentifier, InputStream inputStream, Long l, InputStream inputStream2, TemplateAnalysis templateAnalysis, InputStream inputStream3, boolean bl, boolean bl2, String string, String string2, boolean bl3, PropertiesProvider propertiesProvider) throws IOException, TemplateAlreadyExistsException {
        if (inputStream == null) {
            throw new IllegalArgumentException("origTemplateSource cannot be null");
        }
        if (templateIdentifier == null || templateIdentifier.getName() == null) {
            throw new IllegalArgumentException("null templateId or templateId.getName()");
        }
        SimpleTemplateFiles simpleTemplateFiles = this.getTemplateFiles(this.b, templateIdentifier);
        try {
            TemplateDetails templateDetails;
            Object object;
            Object object2;
            OutputStream outputStream;
            OutputStream outputStream2;
            block19: {
                if (simpleTemplateFiles.exists()) {
                    if (bl) {
                        simpleTemplateFiles.clearFiles();
                    } else {
                        throw new TemplateAlreadyExistsException(templateIdentifier.getName() + ". Specify overwrite to force.");
                    }
                }
                boolean bl4 = inputStream2 != null;
                simpleTemplateFiles.createTemplateRoot();
                outputStream2 = null;
                outputStream = null;
                try {
                    if (bl4) {
                        outputStream2 = simpleTemplateFiles.getOrigFileOutputStream();
                        outputStream = simpleTemplateFiles.getWorkingFileOutputStream();
                        object2 = this.storeFile(inputStream, outputStream2);
                        object = this.storeWorkingTemplate(inputStream2, outputStream);
                        templateDetails = new TemplateDetails(templateIdentifier, object2[0], object2[1], object[0], object[1], null, null);
                        break block19;
                    }
                    outputStream = simpleTemplateFiles.getWorkingFileOutputStream();
                    object2 = this.storeWorkingTemplate(inputStream, outputStream);
                    templateDetails = new TemplateDetails(templateIdentifier, object2[0], object2[1], 0L, 0L, null, null);
                }
                catch (Throwable throwable) {
                    FileUtilities.close(outputStream2);
                    FileUtilities.close(outputStream);
                    throw throwable;
                }
            }
            FileUtilities.close(outputStream2);
            FileUtilities.close(outputStream);
            if (l != null) {
                simpleTemplateFiles.getOrigFile().setLastModified(l);
            }
            if (simpleTemplateFiles.thumbnailFileExists()) {
                simpleTemplateFiles.getThumbnailFile().delete();
            }
            if (inputStream3 != null) {
                FileUtilities.storeToFile(inputStream3, simpleTemplateFiles.getThumbnailFile());
            }
            if (simpleTemplateFiles.analysisExists()) {
                simpleTemplateFiles.getAnalysisFile().delete();
            }
            if (templateAnalysis != null) {
                object2 = simpleTemplateFiles.getAnalysisFileOutputStream();
                object = null;
                try {
                    object = new ObjectOutputStream((OutputStream)object2);
                    ((ObjectOutputStream)object).writeObject(templateAnalysis);
                }
                finally {
                    FileUtilities.close((OutputStream)object);
                    FileUtilities.close((OutputStream)object2);
                }
            }
            object2 = templateDetails;
            return object2;
        }
        finally {
            simpleTemplateFiles.cleanup();
        }
    }

    private long[] storeWorkingTemplate(InputStream inputStream, OutputStream outputStream) throws IOException {
        return this.storeFile(inputStream, outputStream);
    }

    private long[] storeFile(InputStream inputStream, OutputStream outputStream) throws IOException {
        long l = FileUtilities.streamOut(inputStream, outputStream, new byte[4096]);
        return new long[]{l, System.currentTimeMillis()};
    }

    private List getTemplates(File file, boolean bl, boolean bl2) throws IOException, TemplateStoreException {
        ArrayList<TemplateDetails> arrayList = new ArrayList<TemplateDetails>();
        if (file.isDirectory()) {
            if (SimpleTemplateFiles.isTemplateDirectory(file)) {
                String string = file.getName();
                String string2 = file.getParentFile().getCanonicalPath();
                string2 = !string2.equals(this.b.getCanonicalPath()) ? string2.substring(this.b.getCanonicalPath().length() + 1) : ".";
                TemplateIdentifier templateIdentifier = new TemplateIdentifier(string, new TemplateContext(string2));
                try {
                    arrayList.add(this.getTemplateDetails(templateIdentifier));
                }
                catch (TemplateNotFoundException templateNotFoundException) {
                    c.error("Could not find template.  But I thought it was a template. Ignoring for now, but this should be investigated.", templateNotFoundException);
                }
            } else if (bl || bl2) {
                File[] fileArray = file.listFiles(new _A());
                if (fileArray != null && fileArray.length > 0) {
                    File file2 = null;
                    for (int i = 0; i < fileArray.length; ++i) {
                        file2 = new File(StringUtilities.appendDirectoryAndFile(file.getCanonicalPath(), fileArray[i].getName()));
                        arrayList.addAll(this.getTemplates(file2, false, bl2));
                    }
                } else if (bl && !bl2) {
                    c.warn("Could not find any templates in the given context.");
                }
            }
        } else {
            c.warn("Argument " + file + " wasn't a directory.  Returning empty list.");
        }
        return arrayList;
    }

    @Override
    public TemplateDetails[] findByContext(TemplateContext templateContext, boolean bl) throws IOException, TemplateStoreException {
        if (templateContext == null) {
            c.warn("Template Context may not be null.  Returning null.");
            return null;
        }
        if ("/..".contentEquals(templateContext.getPath()) || FileUtilities.includesRelativePathSnippet(templateContext.getPath())) {
            throw new IOException("Template Context cannot contain references to parent folders (..).");
        }
        File file = new File(StringUtilities.appendDirectoryAndFile(this.b.getCanonicalPath(), templateContext.getPath()));
        List list = this.getTemplates(file, true, bl);
        TemplateDetails[] templateDetailsArray = null;
        if (list != null && !list.isEmpty()) {
            templateDetailsArray = new TemplateDetails[list.size()];
            list.toArray(templateDetailsArray);
        }
        return templateDetailsArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TemplateAnalysis getTemplateAnalysis(TemplateIdentifier templateIdentifier) throws IOException, TemplateNotFoundException, TemplateStoreException {
        SimpleTemplateFiles simpleTemplateFiles = this.getTemplateFiles(this.b, templateIdentifier);
        try {
            TemplateAnalysis templateAnalysis;
            TemplateAnalysis templateAnalysis2 = templateAnalysis = this.getTemplateAnalysis(templateIdentifier, simpleTemplateFiles);
            return templateAnalysis2;
        }
        finally {
            simpleTemplateFiles.cleanup();
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private TemplateAnalysis getTemplateAnalysis(TemplateIdentifier templateIdentifier, SimpleTemplateFiles simpleTemplateFiles) throws IOException, TemplateNotFoundException, TemplateStoreException {
        TemplateAnalysis templateAnalysis;
        if (!simpleTemplateFiles.workingFileExists()) {
            throw new TemplateNotFoundException("working template not found: " + templateIdentifier);
        }
        if (!simpleTemplateFiles.analysisExists()) {
            return null;
        }
        InputStream inputStream = simpleTemplateFiles.getAnalysisFileInputStream();
        ObjectInputStream objectInputStream = null;
        try {
            objectInputStream = new ObjectInputStream(inputStream);
            templateAnalysis = (TemplateAnalysis)objectInputStream.readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                throw new TemplateStoreException("Unable to load analysis", classNotFoundException, true);
                catch (InvalidClassException invalidClassException) {
                    throw new TemplateStoreException("Unable to load analysis", invalidClassException, true);
                }
                catch (StreamCorruptedException streamCorruptedException) {
                    throw new TemplateStoreException("Unable to load analysis", streamCorruptedException, true);
                }
                catch (OptionalDataException optionalDataException) {
                    throw new TemplateStoreException("Unable to load analysis", optionalDataException, true);
                }
                catch (ClassCastException classCastException) {
                    throw new TemplateStoreException("Unable to load analysis", classCastException, true);
                }
            }
            catch (Throwable throwable) {
                FileUtilities.close(objectInputStream);
                FileUtilities.close(inputStream);
                throw throwable;
            }
        }
        FileUtilities.close(objectInputStream);
        FileUtilities.close(inputStream);
        return templateAnalysis;
    }

    protected SimpleTemplateFiles getTemplateFiles(File file, TemplateIdentifier templateIdentifier) throws IOException {
        return new SimpleTemplateFiles(file, templateIdentifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteTemplate(TemplateIdentifier templateIdentifier) throws TemplateStoreException {
        block10: {
            SimpleTemplateFiles simpleTemplateFiles;
            if (templateIdentifier == null || templateIdentifier.getName() == null) {
                throw new IllegalArgumentException("null templateId or templateId.getName()");
            }
            try {
                simpleTemplateFiles = this.getTemplateFiles(this.b, templateIdentifier);
            }
            catch (IOException iOException) {
                throw new TemplateStoreException(iOException.getMessage());
            }
            try {
                if (!simpleTemplateFiles.exists()) break block10;
                try {
                    simpleTemplateFiles.clearFiles();
                    if (templateIdentifier.getContext() != null) {
                        this.cascadeUpwardsDeleteEmptyDirectories(this.b.getCanonicalPath(), this.b.getCanonicalPath() + File.separator + templateIdentifier.getContext().toString());
                    }
                }
                catch (IOException iOException) {
                    throw new TemplateStoreException("Unable to delete template " + templateIdentifier.getName() + " in context " + templateIdentifier.getContext(), iOException);
                }
            }
            finally {
                if (simpleTemplateFiles != null) {
                    simpleTemplateFiles.cleanup();
                }
            }
        }
    }

    private void cascadeUpwardsDeleteEmptyDirectories(String string, String string2) throws IOException {
        String[] stringArray;
        File file = new File(string2);
        if (file.isDirectory() && ((stringArray = file.list()) == null || stringArray.length == 0)) {
            c.info("Directory " + string2 + " is empty.  Deleting it.");
            file.delete();
            int n = string2.lastIndexOf(File.separator);
            String string3 = string2.substring(0, n);
            if (!Equivalence.equivalentObjects(string, string3)) {
                this.cascadeUpwardsDeleteEmptyDirectories(string, string3);
            }
        }
    }

    @Override
    public void deleteTemplates(TemplateContext templateContext, boolean bl) throws TemplateStoreException {
        try {
            TemplateDetails[] templateDetailsArray = this.findByContext(templateContext, bl);
            if (templateDetailsArray != null && templateDetailsArray.length > 0) {
                for (int i = 0; i < templateDetailsArray.length; ++i) {
                    this.deleteTemplate(templateDetailsArray[i]);
                }
            }
            File file = new File(StringUtilities.appendDirectoryAndFile(this.b.getCanonicalPath(), templateContext.getPath()));
            File[] fileArray = file.listFiles();
            if (bl || fileArray == null || fileArray.length == 0) {
                if (file.getCanonicalPath().equals(this.b.getCanonicalPath())) {
                    if (fileArray != null) {
                        for (int i = 0; i < fileArray.length; ++i) {
                            FileUtilities.deleteRecursively(fileArray[i]);
                        }
                    }
                } else {
                    File file2 = new File(file.getParentFile(), file.getName() + ".old");
                    if (file.renameTo(file2)) {
                        FileUtilities.deleteRecursively(file2);
                    }
                }
            }
        }
        catch (IOException iOException) {
            throw new TemplateStoreException("Unable to delete templates in context " + templateContext, iOException);
        }
    }

    @Override
    public void deleteAll() throws TemplateStoreException {
        this.deleteTemplates(new TemplateContext(""), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getTemplateStoredTime(TemplateIdentifier templateIdentifier) throws TemplateStoreException {
        SimpleTemplateFiles simpleTemplateFiles;
        try {
            simpleTemplateFiles = this.getTemplateFiles(this.b, templateIdentifier);
        }
        catch (IOException iOException) {
            throw new TemplateStoreException(iOException.getMessage());
        }
        long l = -1L;
        try {
            if (simpleTemplateFiles.workingFileExists()) {
                l = simpleTemplateFiles.getWorkingFile().lastModified();
            }
        }
        finally {
            simpleTemplateFiles.cleanup();
        }
        return l;
    }

    private static class _A
    implements FileFilter {
        private _A() {
        }

        @Override
        public boolean accept(File file) {
            return file != null && file.isDirectory();
        }
    }
}

