/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.template.store.database;

import com.docmosis.template.SimpleTemplate;
import com.docmosis.template.Template;
import com.docmosis.template.TemplateAlreadyExistsException;
import com.docmosis.template.TemplateDetails;
import com.docmosis.template.TemplateNotFoundException;
import com.docmosis.template.TemplateStoreException;
import com.docmosis.template.analysis.TemplateAnalysis;
import com.docmosis.template.store.TemplateContext;
import com.docmosis.template.store.TemplateIdentifier;
import com.docmosis.template.store.TemplateStore;
import com.docmosis.template.store.database.DatabaseTemplateStoreTableStructureException;
import com.docmosis.util.FileUtilities;
import com.docmosis.util.SqlUtilities;
import com.docmosis.util.logging.LogManager;
import com.docmosis.util.logging.Logger;
import com.docmosis.util.properties.PropertiesProvider;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.sql.DataSource;

public class OracleTemplateStore
implements TemplateStore {
    private static final Logger P = LogManager.getLogger(OracleTemplateStore.class);
    private final DataSource Q;

    public OracleTemplateStore(DataSource dataSource) throws SQLException, DatabaseTemplateStoreTableStructureException {
        this.Q = dataSource;
        if (!this.storeTablesExist()) {
            this.createStoreTables();
        }
    }

    @Override
    public void deleteAll() throws TemplateStoreException {
        try {
            this.doSql("delete docmosis_templates");
            this.doSql("delete docmosis_blobs");
        }
        catch (SQLException sQLException) {
            throw new TemplateStoreException("An unexpected occurred while trying to delete all templates", sQLException);
        }
    }

    @Override
    public void deleteTemplate(TemplateIdentifier templateIdentifier) throws TemplateStoreException {
        this.checkTemplateId(templateIdentifier);
        try {
            _A _A2 = this.getTemplateIDSet(templateIdentifier.getName(), this.getContextPath(templateIdentifier));
            if (_A2 != null && _A2.E() > 0L) {
                this.deleteTemplateRecord(_A2.E());
                this.deleteBlobs(_A2.F());
            } else {
                P.warn("Nothing to delete.  Name: " + templateIdentifier.getName() + ", Context: " + this.getContextPath(templateIdentifier));
            }
        }
        catch (SQLException sQLException) {
            throw new TemplateStoreException("An unexpected error occurred while trying to delete a template", sQLException);
        }
    }

    @Override
    public void deleteTemplates(TemplateContext templateContext, boolean bl) throws TemplateStoreException {
        if (templateContext == null) {
            throw new IllegalArgumentException("Template context may not be null.");
        }
        try {
            _A[] _AArray = this.getTemplateIDSet(templateContext.getPath(), bl);
            if (_AArray != null && _AArray.length > 0) {
                for (int i = 0; i < _AArray.length; ++i) {
                    this.deleteTemplateRecord(_AArray[i].E());
                    this.deleteBlobs(_AArray[i].F());
                }
            } else {
                P.warn("Nothing to delete.  Context: " + templateContext.getPath());
            }
        }
        catch (SQLException sQLException) {
            throw new TemplateStoreException("An unexpected error occurred while trying to delete templates", sQLException);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public TemplateDetails[] findByContext(TemplateContext templateContext, boolean bl) throws IOException, TemplateStoreException {
        TemplateDetails[] templateDetailsArray;
        if (templateContext == null) {
            throw new IllegalArgumentException("Template context may not be null.");
        }
        ArrayList<TemplateDetails> arrayList = new ArrayList<TemplateDetails>();
        String string = templateContext.getPath();
        try {
            templateDetailsArray = "select t.name, t.context, orig.data orig_data, wrk.data wrk_data, analysis.data analysis_data, thumb.data thumb_data, orig.byte_count orig_size, wrk.byte_count wrk_size, t.last_modified_millis from docmosis_templates t, docmosis_blobs orig, docmosis_blobs wrk, docmosis_blobs analysis, docmosis_blobs thumb where orig.id = t.orig_template_id and wrk.id = t.working_template_id and analysis.id (+) = t.template_analysis_id and thumb.id (+) = t.thumbnail_id";
            if (string != null) {
                templateDetailsArray = (String)templateDetailsArray + " and t.context like ?";
            } else if (!bl) {
                templateDetailsArray = (String)templateDetailsArray + " and t.context is null";
            }
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            Connection connection = null;
            try {
                connection = this.Q.getConnection();
                preparedStatement = connection.prepareStatement((String)templateDetailsArray);
                if (string != null) {
                    if (bl) {
                        preparedStatement.setString(1, string + "%");
                    } else {
                        preparedStatement.setString(1, string);
                    }
                }
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    Object object;
                    TemplateIdentifier templateIdentifier = new TemplateIdentifier(resultSet.getString("name"), new TemplateContext(resultSet.getString("context")));
                    Blob blob = resultSet.getBlob("analysis_data");
                    TemplateAnalysis templateAnalysis = null;
                    if (blob != null) {
                        object = new ObjectInputStream(blob.getBinaryStream());
                        templateAnalysis = (TemplateAnalysis)((ObjectInputStream)object).readObject();
                    }
                    object = resultSet.getBlob("thumb_data");
                    File file = null;
                    if (object != null) {
                        InputStream inputStream = object.getBinaryStream();
                        file = FileUtilities.createTempFile("dm_", ".thumbnail");
                        FileUtilities.storeToFile(inputStream, file);
                    }
                    long l = resultSet.getLong("orig_size");
                    long l2 = resultSet.getLong("wrk_size");
                    long l3 = resultSet.getLong("last_modified_millis");
                    TemplateDetails templateDetails = new TemplateDetails(templateIdentifier, l, l3, l2, l3, templateAnalysis, file);
                    arrayList.add(templateDetails);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                try {
                    throw new TemplateStoreException("An unexpected class error occurred while retrieving the analysis.", classNotFoundException);
                    catch (SQLException sQLException) {
                        throw new TemplateStoreException("An unexpected SQL error occurred while retrieving the template.", sQLException);
                    }
                }
                catch (Throwable throwable) {
                    SqlUtilities.closeAll(connection, preparedStatement, resultSet);
                    throw throwable;
                }
            }
            SqlUtilities.closeAll(connection, preparedStatement, resultSet);
        }
        catch (SQLException sQLException) {
            throw new TemplateStoreException("An unexpected SQL error occurred while retrieving the template.", sQLException);
        }
        templateDetailsArray = new TemplateDetails[arrayList.size()];
        arrayList.toArray(templateDetailsArray);
        return templateDetailsArray;
    }

    @Override
    public InputStream getOriginalTemplate(TemplateIdentifier templateIdentifier) throws IOException, TemplateNotFoundException {
        this.checkTemplateId(templateIdentifier);
        try {
            Blob blob = this.retrieveBlob(templateIdentifier.getName(), this.getContextPath(templateIdentifier), "orig_template_id");
            return blob.getBinaryStream();
        }
        catch (SQLException sQLException) {
            throw new TemplateNotFoundException("An unexpected SQL error occurred while retrieving the original template.", sQLException);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Template getTemplate(TemplateIdentifier templateIdentifier) throws IOException, TemplateNotFoundException, TemplateStoreException {
        this.checkTemplateId(templateIdentifier);
        SimpleTemplate simpleTemplate = new SimpleTemplate();
        String string = this.getContextPath(templateIdentifier);
        try {
            String string2 = "select orig.data orig_data, wrk.data wrk_data, analysis.data analysis_data, thumb.data thumb_data, orig.byte_count orig_size, wrk.byte_count wrk_size, t.last_modified_millis from docmosis_templates t, docmosis_blobs orig, docmosis_blobs wrk, docmosis_blobs analysis, docmosis_blobs thumb where orig.id = t.orig_template_id and wrk.id = t.working_template_id and analysis.id (+) = t.template_analysis_id and thumb.id (+) = t.thumbnail_id and t.name like ?";
            string2 = string != null ? string2 + " and t.context like ?" : string2 + " and t.context is null";
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            Connection connection = null;
            try {
                Object object;
                int n = 0;
                connection = this.Q.getConnection();
                preparedStatement = connection.prepareStatement(string2);
                preparedStatement.setString(++n, templateIdentifier.getName());
                if (string != null) {
                    preparedStatement.setString(++n, string);
                }
                if (!(resultSet = preparedStatement.executeQuery()).next()) throw new TemplateNotFoundException("Could not find store data for template: Name = " + templateIdentifier.getName() + ", Context = " + this.getContextPath(templateIdentifier));
                Blob blob = resultSet.getBlob("wrk_data");
                simpleTemplate.setInputStream(blob.getBinaryStream());
                simpleTemplate.setId(templateIdentifier);
                Blob blob2 = resultSet.getBlob("analysis_data");
                TemplateAnalysis templateAnalysis = null;
                if (blob2 != null) {
                    object = new ObjectInputStream(blob2.getBinaryStream());
                    templateAnalysis = (TemplateAnalysis)((ObjectInputStream)object).readObject();
                    simpleTemplate.setAnalysis(templateAnalysis);
                }
                object = resultSet.getBlob("thumb_data");
                File file = null;
                if (object != null) {
                    InputStream inputStream = object.getBinaryStream();
                    file = FileUtilities.createTempFile("dm_", ".thumbnail");
                    FileUtilities.storeToFile(inputStream, file);
                }
                long l = resultSet.getLong("orig_size");
                long l2 = resultSet.getLong("wrk_size");
                long l3 = resultSet.getLong("last_modified_millis");
                TemplateDetails templateDetails = new TemplateDetails(templateIdentifier, l, l3, l2, l3, templateAnalysis, file);
                simpleTemplate.setDetails(templateDetails);
            }
            catch (ClassNotFoundException classNotFoundException) {
                try {
                    throw new TemplateStoreException("An unexpected class error occurred while retrieving the analysis.", classNotFoundException);
                    catch (SQLException sQLException) {
                        throw new TemplateStoreException("An unexpected SQL error occurred while retrieving the template.", sQLException);
                    }
                }
                catch (Throwable throwable) {
                    SqlUtilities.closeAll(connection, preparedStatement, resultSet);
                    throw throwable;
                }
            }
            SqlUtilities.closeAll(connection, preparedStatement, resultSet);
            return simpleTemplate;
        }
        catch (SQLException sQLException) {
            throw new TemplateStoreException("An unexpected SQL error occurred while retrieving the template.", sQLException);
        }
    }

    @Override
    public TemplateAnalysis getTemplateAnalysis(TemplateIdentifier templateIdentifier) throws IOException, TemplateNotFoundException, TemplateStoreException {
        this.checkTemplateId(templateIdentifier);
        TemplateAnalysis templateAnalysis = null;
        try {
            Blob blob = this.retrieveBlob(templateIdentifier.getName(), this.getContextPath(templateIdentifier), "template_analysis_id");
            if (blob != null) {
                ObjectInputStream objectInputStream = new ObjectInputStream(blob.getBinaryStream());
                templateAnalysis = (TemplateAnalysis)objectInputStream.readObject();
            }
        }
        catch (SQLException sQLException) {
            throw new TemplateStoreException("An unexpected SQL error occurred while retrieving the analysis.", sQLException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new TemplateStoreException("An unexpected class error occurred while retrieving the analysis.", classNotFoundException);
        }
        return templateAnalysis;
    }

    @Override
    public TemplateDetails storeTemplate(TemplateIdentifier templateIdentifier, InputStream inputStream, Long l, InputStream inputStream2, TemplateAnalysis templateAnalysis, InputStream inputStream3, boolean bl, boolean bl2, String string, String string2, boolean bl3, PropertiesProvider propertiesProvider) throws IOException, TemplateAlreadyExistsException, TemplateStoreException {
        this.checkTemplateId(templateIdentifier);
        if (inputStream == null) {
            throw new IllegalArgumentException("Original template source may not be null.");
        }
        TemplateDetails templateDetails = null;
        try {
            boolean bl4 = false;
            try {
                this.getTemplate(templateIdentifier);
                bl4 = true;
            }
            catch (TemplateNotFoundException templateNotFoundException) {
                // empty catch block
            }
            if (bl4) {
                if (bl) {
                    templateDetails = this.updateTemplate(templateIdentifier, inputStream, inputStream2, templateAnalysis, inputStream3);
                } else {
                    P.warn("Template already exists.  Did not overwrite due to overwrite parameter not being set to true.");
                }
            } else {
                templateDetails = this.insertTemplate(templateIdentifier, inputStream, inputStream2, templateAnalysis, inputStream3);
            }
        }
        catch (SQLException sQLException) {
            throw new TemplateStoreException("An SQL error occurred while storing the template.", sQLException);
        }
        return templateDetails;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long getTemplateStoredTime(TemplateIdentifier templateIdentifier) throws TemplateStoreException {
        long l = -1L;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        Connection connection = null;
        String string = null;
        if (templateIdentifier.getContext() != null) {
            string = templateIdentifier.getContext().getPath();
        }
        try {
            String string2 = "select last_modified_millis from docmosis_templates where name like ?";
            string2 = string != null ? string2 + " and context like ?" : string2 + " and context is null";
            connection = this.Q.getConnection();
            preparedStatement = connection.prepareStatement(string2);
            preparedStatement.setString(1, templateIdentifier.getName());
            if (string != null) {
                preparedStatement.setString(2, string);
            }
            resultSet = preparedStatement.executeQuery();
            resultSet.next();
            l = resultSet.getLong("last_modified_millis");
        }
        catch (SQLException sQLException) {
            try {
                P.error("An error occurred while checking table existence.", sQLException);
                throw new TemplateStoreException("An SQL error occurred while getting the stored time", sQLException);
            }
            catch (Throwable throwable) {
                try {
                    SqlUtilities.closeAll(connection, preparedStatement, resultSet);
                    throw throwable;
                }
                catch (SQLException sQLException2) {
                    P.error("A further error occurred while release SQL resources.", sQLException2);
                }
                throw throwable;
            }
        }
        try {
            SqlUtilities.closeAll(connection, preparedStatement, resultSet);
            return l;
        }
        catch (SQLException sQLException) {
            P.error("A further error occurred while release SQL resources.", sQLException);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean specificTableExists(String string) throws SQLException {
        boolean bl = false;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        Connection connection = null;
        try {
            connection = this.Q.getConnection();
            preparedStatement = connection.prepareStatement("select count('x') as table_count from user_tables where upper(table_name) like '" + string.toUpperCase() + "'");
            resultSet = preparedStatement.executeQuery();
            resultSet.next();
            bl = resultSet.getLong("table_count") == 1L;
            SqlUtilities.closeAll(connection, preparedStatement, resultSet);
        }
        catch (SQLException sQLException) {
            P.error("An error occurred while checking table existence.", sQLException);
        }
        finally {
            SqlUtilities.closeAll(connection, preparedStatement, resultSet);
        }
        return bl;
    }

    private void deleteTemplateRecord(long l) throws SQLException {
        String string = "delete docmosis_templates where id = ?";
        PreparedStatement preparedStatement = null;
        Connection connection = null;
        try {
            connection = this.Q.getConnection();
            preparedStatement = connection.prepareStatement(string);
            preparedStatement.setLong(1, l);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            try {
                P.error("An error occurred deleting a template record.", sQLException);
                throw sQLException;
            }
            catch (Throwable throwable) {
                SqlUtilities.closeAll(connection, preparedStatement, null);
                throw throwable;
            }
        }
        SqlUtilities.closeAll(connection, preparedStatement, null);
    }

    private void deleteBlobs(long[] lArray) throws SQLException {
        if (lArray == null || lArray.length != 4) {
            throw new IllegalArgumentException("There should be exactly 4 blob IDs to delete.");
        }
        String string = "delete docmosis_blobs where id in (?, ?, ?, ?)";
        PreparedStatement preparedStatement = null;
        Connection connection = null;
        try {
            connection = this.Q.getConnection();
            preparedStatement = connection.prepareStatement(string);
            int n = 0;
            preparedStatement.setLong(++n, lArray[0]);
            preparedStatement.setLong(++n, lArray[1]);
            preparedStatement.setLong(++n, lArray[2]);
            preparedStatement.setLong(++n, lArray[3]);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            try {
                P.error("An error occurred deleting a template blob.", sQLException);
                throw sQLException;
            }
            catch (Throwable throwable) {
                SqlUtilities.closeAll(connection, preparedStatement, null);
                throw throwable;
            }
        }
        SqlUtilities.closeAll(connection, preparedStatement, null);
    }

    private _A[] getTemplateIDSet(String string, boolean bl) throws SQLException {
        String string2 = "select id, orig_template_id, working_template_id, template_analysis_id, thumbnail_id from docmosis_templates";
        if (string != null) {
            string2 = string2 + " where context like ?";
        } else if (!bl) {
            string2 = string2 + " where context is null";
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        Connection connection = null;
        ArrayList<_A> arrayList = new ArrayList<_A>();
        try {
            connection = this.Q.getConnection();
            preparedStatement = connection.prepareStatement(string2);
            if (string != null) {
                if (bl) {
                    preparedStatement.setString(1, string + "%");
                } else {
                    preparedStatement.setString(1, string);
                }
            }
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                arrayList.add(new _A(resultSet.getLong("id"), resultSet.getLong("orig_template_id"), resultSet.getLong("working_template_id"), resultSet.getLong("template_analysis_id"), resultSet.getLong("thumbnail_id")));
            }
        }
        catch (SQLException sQLException) {
            try {
                P.error("An error occurred while determining IDs to update/delete.", sQLException);
                throw sQLException;
            }
            catch (Throwable throwable) {
                SqlUtilities.closeAll(connection, preparedStatement, resultSet);
                throw throwable;
            }
        }
        SqlUtilities.closeAll(connection, preparedStatement, resultSet);
        _A[] _AArray = new _A[arrayList.size()];
        arrayList.toArray(_AArray);
        return _AArray;
    }

    private _A getTemplateIDSet(String string, String string2) throws SQLException {
        Connection connection;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        _A _A2;
        block6: {
            _A2 = null;
            String string3 = "select id, orig_template_id, working_template_id, template_analysis_id, thumbnail_id from docmosis_templates where name = ?";
            string3 = string2 != null ? string3 + " and context = ?" : string3 + " and context is null";
            preparedStatement = null;
            resultSet = null;
            connection = null;
            try {
                int n = 0;
                connection = this.Q.getConnection();
                preparedStatement = connection.prepareStatement(string3);
                preparedStatement.setString(++n, string);
                if (string2 != null) {
                    preparedStatement.setString(++n, string2);
                }
                if ((resultSet = preparedStatement.executeQuery()).next()) {
                    _A2 = new _A(resultSet.getLong("id"), resultSet.getLong("orig_template_id"), resultSet.getLong("working_template_id"), resultSet.getLong("template_analysis_id"), resultSet.getLong("thumbnail_id"));
                    break block6;
                }
                P.warn("Could not find anything appropriate to update/delete.  Name: " + string + ", Context: " + string2);
            }
            catch (SQLException sQLException) {
                try {
                    P.error("An error occurred while determining IDs to update/delete.", sQLException);
                    throw sQLException;
                }
                catch (Throwable throwable) {
                    SqlUtilities.closeAll(connection, preparedStatement, resultSet);
                    throw throwable;
                }
            }
        }
        SqlUtilities.closeAll(connection, preparedStatement, resultSet);
        return _A2;
    }

    private boolean specificSequenceExists(String string) throws SQLException {
        boolean bl = false;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        Connection connection = null;
        try {
            connection = this.Q.getConnection();
            preparedStatement = connection.prepareStatement("select count('x') as seq_count from user_sequences where upper(sequence_name) like '" + string.toUpperCase() + "'");
            resultSet = preparedStatement.executeQuery();
            resultSet.next();
            bl = resultSet.getLong("seq_count") == 1L;
        }
        catch (SQLException sQLException) {
            try {
                P.error("An error occurred while checking the existence of a sequence.", sQLException);
                throw sQLException;
            }
            catch (Throwable throwable) {
                SqlUtilities.closeAll(connection, preparedStatement, resultSet);
                throw throwable;
            }
        }
        SqlUtilities.closeAll(connection, preparedStatement, resultSet);
        return bl;
    }

    private boolean storeTablesExist() throws SQLException, DatabaseTemplateStoreTableStructureException {
        boolean bl = this.specificTableExists("docmosis_blobs");
        boolean bl2 = this.specificTableExists("docmosis_templates");
        boolean bl3 = this.specificSequenceExists("blob_id_seq");
        boolean bl4 = this.specificSequenceExists("template_id_seq");
        boolean bl5 = false;
        if (bl && bl2 && bl3 && bl4) {
            bl5 = true;
        } else if (!(bl || bl2 || bl3 || bl4)) {
            bl5 = false;
        } else {
            throw new DatabaseTemplateStoreTableStructureException("Store database is corrupt.  The tables DOCMOSIS_BLOBS and DOCMOSIS_TEMPLATES, and the sequences BLOB_ID_SEQ and TEMPLATE_ID_SEQ must either all exist, or none of them should exist at all.");
        }
        return bl5;
    }

    private void createStoreTables() throws SQLException {
        this.doSql("create table docmosis_blobs (id number(20) not null primary key, data blob, byte_count number(20))");
        this.doSql("create table docmosis_templates(id number(20) not null primary key, name varchar2(100) not null, context varchar2(2000), last_modified_millis number(20), working_template_id number(20), orig_template_id number(20), template_analysis_id number(20), thumbnail_id number(20), constraint fk_orig      foreign key (orig_template_id)     references docmosis_blobs(id), constraint fk_working   foreign key (working_template_id)  references docmosis_blobs(id), constraint fk_analysis  foreign key (template_analysis_id) references docmosis_blobs(id), constraint fk_thumbnail foreign key (thumbnail_id)         references docmosis_blobs(id))");
        this.doSql("create index idx_name on docmosis_templates(name)");
        this.doSql("create index idx_context on docmosis_templates(context)");
        this.doSql("create index idx_orig on docmosis_templates(orig_template_id)");
        this.doSql("create index idx_working on docmosis_templates(working_template_id)");
        this.doSql("create index idx_analysis on docmosis_templates(template_analysis_id)");
        this.doSql("create index idx_thumbnail on docmosis_templates(thumbnail_id)");
        this.doSql("create sequence template_id_seq");
        this.doSql("create sequence blob_id_seq");
    }

    private void doSql(String string) throws SQLException {
        PreparedStatement preparedStatement = null;
        Connection connection = null;
        try {
            connection = this.Q.getConnection();
            preparedStatement = connection.prepareStatement(string);
            preparedStatement.execute();
        }
        catch (SQLException sQLException) {
            try {
                P.error("An error occurred performing SQL.", sQLException);
                throw sQLException;
            }
            catch (Throwable throwable) {
                SqlUtilities.closeAll(connection, preparedStatement, null);
                throw throwable;
            }
        }
        SqlUtilities.closeAll(connection, preparedStatement, null);
    }

    private long getNextSequenceValue(String string) throws SQLException {
        long l;
        String string2 = "select " + string + ".nextval from dual";
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        Connection connection = null;
        try {
            connection = this.Q.getConnection();
            preparedStatement = connection.prepareStatement(string2);
            resultSet = preparedStatement.executeQuery();
            resultSet.next();
            l = resultSet.getLong(1);
        }
        catch (SQLException sQLException) {
            try {
                P.error("An error occurred retrieving from a sequence.", sQLException);
                throw sQLException;
            }
            catch (Throwable throwable) {
                SqlUtilities.closeAll(connection, preparedStatement, resultSet);
                throw throwable;
            }
        }
        SqlUtilities.closeAll(connection, preparedStatement, resultSet);
        return l;
    }

    private Blob retrieveBlob(String string, String string2, String string3) throws SQLException, TemplateNotFoundException {
        String string4 = "select b.data from docmosis_blobs b, docmosis_templates t where b.id = t." + string3 + " and t.name = ?";
        string4 = string2 != null ? string4 + " and t.context = ?" : string4 + " and t.context is null";
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        Connection connection = null;
        Blob blob = null;
        try {
            int n = 0;
            connection = this.Q.getConnection();
            preparedStatement = connection.prepareStatement(string4);
            preparedStatement.setString(++n, string);
            if (string2 != null) {
                preparedStatement.setString(++n, string2);
            }
            if ((resultSet = preparedStatement.executeQuery()).next()) {
                blob = resultSet.getBlob("data");
            }
        }
        catch (SQLException sQLException) {
            try {
                P.error("An error occurred retrieving a blob.", sQLException);
                throw sQLException;
            }
            catch (Throwable throwable) {
                SqlUtilities.closeAll(connection, preparedStatement, resultSet);
                throw throwable;
            }
        }
        SqlUtilities.closeAll(connection, preparedStatement, resultSet);
        return blob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private _B updateBlobFromInputStream(long l, InputStream inputStream) throws SQLException, IOException {
        Connection connection;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        long l2;
        block8: {
            l2 = -1L;
            String string = "select data from docmosis_blobs where id = ? for update";
            preparedStatement = null;
            resultSet = null;
            connection = null;
            try {
                connection = this.Q.getConnection();
                preparedStatement = connection.prepareStatement(string);
                preparedStatement.setLong(1, l);
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    Blob blob = resultSet.getBlob("data");
                    blob.truncate(0L);
                    OutputStream outputStream = blob.setBinaryStream(0L);
                    try {
                        l2 = FileUtilities.streamOut(inputStream, outputStream, new byte[4096]);
                        break block8;
                    }
                    finally {
                        FileUtilities.close(outputStream);
                    }
                }
                P.warn("Was unable not save a Blob for the input stream.  Store object will be empty when retrieved.");
            }
            catch (SQLException sQLException) {
                try {
                    P.error("An error occurred creating a blob.", sQLException);
                    throw sQLException;
                }
                catch (Throwable throwable) {
                    SqlUtilities.closeAll(connection, preparedStatement, resultSet);
                    throw throwable;
                }
            }
        }
        SqlUtilities.closeAll(connection, preparedStatement, resultSet);
        this.updateBlobSizeRecord(l, l2);
        return new _B(l, l2, System.currentTimeMillis());
    }

    private _B createBlobFromInputStream(InputStream inputStream) throws SQLException, IOException {
        return this.updateBlobFromInputStream(this.createEmptyBlob(), inputStream);
    }

    private void updateBlobSizeRecord(long l, long l2) throws SQLException {
        String string = "update docmosis_blobs set byte_count = ? where id = ?";
        PreparedStatement preparedStatement = null;
        Connection connection = null;
        try {
            connection = this.Q.getConnection();
            preparedStatement = connection.prepareStatement(string);
            preparedStatement.setLong(1, l2);
            preparedStatement.setLong(2, l);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            try {
                P.error("An error occurred updating the blob size.", sQLException);
                throw sQLException;
            }
            catch (Throwable throwable) {
                SqlUtilities.closeAll(connection, preparedStatement, null);
                throw throwable;
            }
        }
        SqlUtilities.closeAll(connection, preparedStatement, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateBlobFromAnalysis(long l, TemplateAnalysis templateAnalysis) throws SQLException, IOException {
        Connection connection;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        long l2;
        block15: {
            l2 = -1L;
            String string = "select data from docmosis_blobs where id = ? for update";
            preparedStatement = null;
            resultSet = null;
            connection = null;
            try {
                connection = this.Q.getConnection();
                preparedStatement = connection.prepareStatement(string);
                preparedStatement.setLong(1, l);
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    Blob blob = resultSet.getBlob("data");
                    blob.truncate(0L);
                    ObjectOutputStream objectOutputStream = null;
                    try {
                        objectOutputStream = new ObjectOutputStream(blob.setBinaryStream(0L));
                        objectOutputStream.writeObject(templateAnalysis);
                        l2 = blob.length();
                        break block15;
                    }
                    catch (SQLException sQLException) {
                        P.error("An error occurred creating an analysis blob.", sQLException);
                        throw sQLException;
                    }
                    finally {
                        try {
                            objectOutputStream.flush();
                        }
                        finally {
                            objectOutputStream.close();
                            objectOutputStream = null;
                        }
                    }
                }
                P.warn("Was unable not save a Blob for the analysis.  Analysis will be empty when retrieved.");
            }
            catch (SQLException sQLException) {
                try {
                    P.error("An error occurred creating an analysis blob.", sQLException);
                    throw sQLException;
                }
                catch (Throwable throwable) {
                    SqlUtilities.closeAll(connection, preparedStatement, resultSet);
                    throw throwable;
                }
            }
        }
        SqlUtilities.closeAll(connection, preparedStatement, resultSet);
        this.updateBlobSizeRecord(l, l2);
    }

    private long createBlobFromAnalysis(TemplateAnalysis templateAnalysis) throws SQLException, IOException {
        long l = this.createEmptyBlob();
        this.updateBlobFromAnalysis(l, templateAnalysis);
        return l;
    }

    private TemplateDetails insertTemplate(TemplateIdentifier templateIdentifier, InputStream inputStream, InputStream inputStream2, TemplateAnalysis templateAnalysis, InputStream inputStream3) throws SQLException, IOException {
        _B _B2;
        _B _B3;
        TemplateDetails templateDetails = null;
        if (inputStream2 != null) {
            _B3 = this.createBlobFromInputStream(inputStream2);
            _B2 = this.createBlobFromInputStream(inputStream);
            templateDetails = new TemplateDetails(templateIdentifier, _B2.C(), _B2.B(), _B3.C(), _B3.B(), null, null);
        } else {
            _B3 = this.createBlobFromInputStream(inputStream);
            _B2 = this.createBlobFromInputStream(inputStream);
            templateDetails = new TemplateDetails(templateIdentifier, _B2.C(), _B2.B(), 0L, 0L, null, null);
        }
        long l = 0L;
        if (templateAnalysis != null) {
            l = this.createBlobFromAnalysis(templateAnalysis);
        }
        _B _B4 = null;
        if (inputStream3 != null) {
            _B4 = this.createBlobFromInputStream(inputStream3);
        }
        long l2 = this.getNextSequenceValue("template_id_seq");
        String string = "insert into docmosis_templates (id, name, context, last_modified_millis, working_template_id, orig_template_id, template_analysis_id, thumbnail_id) values (?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement preparedStatement = null;
        Connection connection = null;
        try {
            connection = this.Q.getConnection();
            preparedStatement = connection.prepareStatement(string);
            int n = 0;
            preparedStatement.setLong(++n, l2);
            preparedStatement.setString(++n, templateIdentifier.getName());
            preparedStatement.setString(++n, this.getContextPath(templateIdentifier));
            preparedStatement.setLong(++n, _B2.B());
            preparedStatement.setLong(++n, _B3.A());
            preparedStatement.setLong(++n, _B2.A());
            if (l > 0L) {
                preparedStatement.setLong(++n, l);
            } else {
                preparedStatement.setNull(++n, 2);
            }
            if (_B4 != null) {
                preparedStatement.setLong(++n, _B4 != null ? _B4.A() : 0L);
            } else {
                preparedStatement.setNull(++n, 2);
            }
            preparedStatement.execute();
        }
        catch (SQLException sQLException) {
            try {
                P.error("An error occurred storing a template", sQLException);
                throw sQLException;
            }
            catch (Throwable throwable) {
                SqlUtilities.closeAll(connection, preparedStatement, null);
                throw throwable;
            }
        }
        SqlUtilities.closeAll(connection, preparedStatement, null);
        return templateDetails;
    }

    private TemplateDetails updateTemplate(TemplateIdentifier templateIdentifier, InputStream inputStream, InputStream inputStream2, TemplateAnalysis templateAnalysis, InputStream inputStream3) throws SQLException, IOException {
        _B _B2;
        TemplateDetails templateDetails = null;
        _A _A2 = this.getTemplateIDSet(templateIdentifier.getName(), this.getContextPath(templateIdentifier));
        if (inputStream2 != null) {
            _B _B3 = this.updateBlobFromInputStream(_A2.D(), inputStream2);
            _B2 = this.updateBlobFromInputStream(_A2.A(), inputStream);
            templateDetails = new TemplateDetails(templateIdentifier, _B2.C(), _B2.B(), _B3.C(), _B3.B(), null, null);
        } else {
            _B _B4 = this.updateBlobFromInputStream(_A2.A(), inputStream);
            _B2 = this.updateBlobFromInputStream(_A2.A(), inputStream);
            templateDetails = new TemplateDetails(templateIdentifier, _B2.C(), _B2.B(), 0L, 0L, null, null);
        }
        if (templateAnalysis != null) {
            this.updateBlobFromAnalysis(_A2.C(), templateAnalysis);
        }
        if (inputStream3 != null) {
            this.updateBlobFromInputStream(_A2.B(), inputStream3);
        }
        String string = this.getContextPath(templateIdentifier);
        String string2 = "update docmosis_templates set last_modified_millis = ? where name = ?";
        string2 = string != null ? string2 + " and context = ?" : string2 + " and context is null";
        PreparedStatement preparedStatement = null;
        Connection connection = null;
        try {
            connection = this.Q.getConnection();
            preparedStatement = connection.prepareStatement(string2);
            int n = 0;
            preparedStatement.setLong(++n, _B2.B());
            preparedStatement.setString(++n, templateIdentifier.getName());
            if (string != null) {
                preparedStatement.setString(++n, string);
            }
            preparedStatement.execute();
        }
        catch (SQLException sQLException) {
            try {
                P.error("An error occurred storing a template", sQLException);
                throw sQLException;
            }
            catch (Throwable throwable) {
                SqlUtilities.closeAll(connection, preparedStatement, null);
                throw throwable;
            }
        }
        SqlUtilities.closeAll(connection, preparedStatement, null);
        return templateDetails;
    }

    private long createEmptyBlob() throws SQLException {
        long l = this.getNextSequenceValue("blob_id_seq");
        String string = "insert into docmosis_blobs (id, data) values (?, empty_blob())";
        PreparedStatement preparedStatement = null;
        Connection connection = null;
        try {
            connection = this.Q.getConnection();
            preparedStatement = connection.prepareStatement(string);
            preparedStatement.setLong(1, l);
            preparedStatement.execute();
        }
        catch (SQLException sQLException) {
            try {
                P.error("An error occurred creating an empty blob.", sQLException);
                throw sQLException;
            }
            catch (Throwable throwable) {
                SqlUtilities.closeAll(connection, preparedStatement, null);
                throw throwable;
            }
        }
        SqlUtilities.closeAll(connection, preparedStatement, null);
        return l;
    }

    private void checkTemplateId(TemplateIdentifier templateIdentifier) throws IllegalArgumentException {
        if (templateIdentifier == null) {
            throw new IllegalArgumentException("Template ID may not be null.");
        }
        if (templateIdentifier.getName() == null) {
            throw new IllegalArgumentException("Template name may not be null.");
        }
    }

    private String getContextPath(TemplateIdentifier templateIdentifier) {
        String string = null;
        TemplateContext templateContext = templateIdentifier.getContext();
        if (templateContext != null) {
            string = templateContext.getPath();
        }
        if ("".equals(string)) {
            string = null;
        }
        return string;
    }

    private class _A {
        private final long F;
        private final long E;
        private final long D;
        private final long C;
        private final long B;

        public _A(long l, long l2, long l3, long l4, long l5) {
            this.F = l;
            this.E = l2;
            this.D = l3;
            this.C = l4;
            this.B = l5;
        }

        public long E() {
            return this.F;
        }

        public long C() {
            return this.C;
        }

        public long A() {
            return this.E;
        }

        public long B() {
            return this.B;
        }

        public long D() {
            return this.D;
        }

        public long[] F() {
            long[] lArray = new long[]{this.E, this.D, this.C, this.B};
            return lArray;
        }
    }

    private class _B {
        private final long B;
        private final long C;
        private final long D;

        public _B(long l, long l2, long l3) {
            this.B = l;
            this.C = l2;
            this.D = l3;
        }

        public long A() {
            return this.B;
        }

        public long C() {
            return this.C;
        }

        public long B() {
            return this.D;
        }
    }
}

