/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.template.store.database;

import com.docmosis.template.Template;
import com.docmosis.template.TemplateAlreadyExistsException;
import com.docmosis.template.TemplateDetails;
import com.docmosis.template.TemplateNotFoundException;
import com.docmosis.template.TemplateStoreException;
import com.docmosis.template.analysis.TemplateAnalysis;
import com.docmosis.template.store.TemplateContext;
import com.docmosis.template.store.TemplateIdentifier;
import com.docmosis.template.store.database.DatabaseTemplateStore;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class HypersonicTemplateStore
extends DatabaseTemplateStore {
    private final Connection O;

    public HypersonicTemplateStore(Connection connection) {
        this.O = connection;
    }

    @Override
    public void deleteAll() throws TemplateStoreException {
        super.deleteAll();
    }

    @Override
    public void deleteTemplate(TemplateIdentifier templateIdentifier) throws TemplateStoreException {
        super.deleteTemplate(templateIdentifier);
    }

    @Override
    public void deleteTemplates(TemplateContext templateContext, boolean bl) throws TemplateStoreException {
        super.deleteTemplates(templateContext, bl);
    }

    @Override
    public TemplateDetails[] findByContext(TemplateContext templateContext, boolean bl) throws IOException, TemplateStoreException {
        return super.findByContext(templateContext, bl);
    }

    @Override
    public InputStream getOriginalTemplate(TemplateIdentifier templateIdentifier) throws IOException, TemplateNotFoundException {
        return super.getOriginalTemplate(templateIdentifier);
    }

    @Override
    public Template getTemplate(TemplateIdentifier templateIdentifier) throws IOException, TemplateNotFoundException, TemplateStoreException {
        return super.getTemplate(templateIdentifier);
    }

    @Override
    public TemplateAnalysis getTemplateAnalysis(TemplateIdentifier templateIdentifier) throws IOException, TemplateNotFoundException, TemplateStoreException {
        return super.getTemplateAnalysis(templateIdentifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TemplateDetails storeTemplate(TemplateIdentifier templateIdentifier, InputStream inputStream, InputStream inputStream2, TemplateAnalysis templateAnalysis, InputStream inputStream3, boolean bl, boolean bl2) throws IOException, TemplateAlreadyExistsException, TemplateStoreException {
        TemplateContext templateContext = templateIdentifier.getContext();
        if (templateContext == null) {
            throw new TemplateStoreException("Context may not be null.");
        }
        try {
            if (!this.storeTablesExist(this.O)) {
                this.createStoreTables(this.O);
            }
            long l = this.createBlob(this.O);
            long l2 = this.createBlob(this.O);
            long l3 = this.createBlob(this.O);
            long l4 = this.createBlob(this.O);
            long l5 = this.getNextSequenceValue("template_id_seq", this.O);
            String string = "insert into docmosis_templates (id, name, context, working_template_id, orig_template_id, template_analysis_id, thumbnail_id) values (?, ?, ?, ?, ?, ?, ?)";
            PreparedStatement preparedStatement = this.O.prepareStatement(string);
            try {
                int n = 0;
                preparedStatement.setLong(++n, l5);
                preparedStatement.setString(++n, templateIdentifier.getName());
                preparedStatement.setString(++n, templateContext.getPath());
                preparedStatement.setLong(++n, l);
                preparedStatement.setLong(++n, l2);
                preparedStatement.setLong(++n, l3);
                preparedStatement.setLong(++n, l4);
                preparedStatement.execute();
            }
            finally {
                preparedStatement.close();
                preparedStatement = null;
            }
        }
        catch (SQLException sQLException) {
            throw new TemplateStoreException("An SQL error occurred while storing the template.", sQLException);
        }
        return null;
    }

    private boolean storeTablesExist(Connection connection) throws SQLException {
        return false;
    }

    private void createStoreTables(Connection connection) throws SQLException {
        this.doSql("create table dual(id bigint, name varchar)", connection);
        this.doSql("insert into dual(id, name) values (1, 'X')", connection);
        this.doSql("create table docmosis_blobs (id bigint not null primary key, data longvarbinary)", connection);
        this.doSql("create table docmosis_templates(id bigint not null primary key, name varchar not null, context varchar, working_template_id bigint, orig_template_id bigint, template_analysis_id bigint, thumbnail_id bigint)", connection);
        this.doSql("create sequence template_id_seq", connection);
        this.doSql("create sequence blob_id_seq", connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSql(String string, Connection connection) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        try {
            preparedStatement.execute();
        }
        finally {
            preparedStatement.close();
            preparedStatement = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getNextSequenceValue(String string, Connection connection) throws SQLException {
        String string2 = "select next value for " + string + " from dual";
        PreparedStatement preparedStatement = connection.prepareStatement(string2);
        ResultSet resultSet = null;
        try {
            resultSet = preparedStatement.executeQuery();
            resultSet.next();
            long l = resultSet.getLong(1);
            return l;
        }
        finally {
            preparedStatement.close();
            preparedStatement = null;
            if (resultSet != null) {
                resultSet.close();
                resultSet = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long createBlob(Connection connection) throws SQLException {
        long l = this.getNextSequenceValue("blob_id_seq", connection);
        String string = "insert into docmosis_blobs (id, data) values (?, ?)";
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        try {
            preparedStatement.setLong(1, l);
            preparedStatement.execute();
        }
        finally {
            preparedStatement.close();
            preparedStatement = null;
        }
        return l;
    }
}

