/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.template.store;

import com.docmosis.document.ExternalResourcePermissions;
import com.docmosis.template.Template;
import com.docmosis.template.TemplateAlreadyExistsException;
import com.docmosis.template.TemplateDetails;
import com.docmosis.template.TemplateNotFoundException;
import com.docmosis.template.TemplateStoreException;
import com.docmosis.template.analysis.TemplateAnalysis;
import com.docmosis.template.store.CachingTemplateStore;
import com.docmosis.template.store.CompressingTemplateStore;
import com.docmosis.template.store.TemplateContext;
import com.docmosis.template.store.TemplateIdentifier;
import com.docmosis.template.store.TemplateSourceMonitor;
import com.docmosis.template.store.TemplateStore;
import com.docmosis.template.store.database.DatabaseTemplateStoreTableStructureException;
import com.docmosis.template.store.database.OracleTemplateStore;
import com.docmosis.template.store.database.PooledDataSource;
import com.docmosis.template.store.file.FileTemplateStore;
import com.docmosis.util.DMProperties;
import com.docmosis.util.FileUtilities;
import com.docmosis.util.logging.LogManager;
import com.docmosis.util.logging.Logger;
import com.docmosis.util.properties.PropertiesProvider;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.HashSet;

public class TemplateStoreFactory {
    static final Logger log = LogManager.getLogger(TemplateStoreFactory.class);
    public static final String PROPERTY_PLAINTEXT_FIELD_PREFIX = "docmosis.analyzer.field.plainText.prefix";
    public static final String PROPERTY_PLAINTEXT_FIELD_SUFFIX = "docmosis.analyzer.field.plainText.suffix";
    public static final String PROPERTY_FIELD_ALLOW_PADDED = "docmosis.analyzer.field.allowPadded";
    public static final String PROPERTY_STORE_LOCATION = "docmosis.template.store.location";
    static final String PROPERTY_TEMPLATE_MONITOR_SOURCE_PATH = "docmosis.template.monitor.sourcepath";
    static final String PROPERTY_TEMPLATE_MONITOR_CONTEXT = "docmosis.template.monitor.context";
    static final String PROPERTY_TEMPLATE_MONITOR_PERIOD = "docmosis.template.monitor.period";
    private static final String B = "custom:";
    private static TemplateStore C = null;
    private static final HashSet A = new HashSet();

    public static TemplateStore getStore() {
        if (C == null) {
            throw new IllegalStateException("Store not available.  Initialize the factory first");
        }
        return TemplateStoreFactory.getStore(TemplateStoreFactory.isTemplateErrorsFatal(), TemplateStoreFactory.getPlainTextFieldPrefix(), TemplateStoreFactory.getPlainTextFieldSuffix(), TemplateStoreFactory.getAllowPaddedFields());
    }

    public static TemplateStore getStore(boolean bl, String string, String string2, boolean bl2) {
        if (C == null) {
            throw new IllegalStateException("Store not available.  Initialize the factory first");
        }
        return new PresetTemplateStore(C, bl, string, string2, bl2, null);
    }

    public static TemplateStore getStore(boolean bl, String string, String string2, boolean bl2, PropertiesProvider propertiesProvider) {
        if (C == null) {
            throw new IllegalStateException("Store not available.  Initialize the factory first");
        }
        return new PresetTemplateStore(C, bl, string, string2, bl2, propertiesProvider);
    }

    public static TemplateStore getStore(boolean bl) {
        if (C == null) {
            throw new IllegalStateException("Store not available.  Initialize the factory first");
        }
        return new PresetTemplateStore(C, bl, TemplateStoreFactory.getPlainTextFieldPrefix(), TemplateStoreFactory.getPlainTextFieldSuffix(), TemplateStoreFactory.getAllowPaddedFields(), null);
    }

    private static synchronized TemplateStore getStore(String string) {
        if (C == null) {
            int n;
            TemplateStore templateStore = null;
            if (string.toLowerCase().startsWith(B)) {
                String string2;
                String string3;
                String string4 = string.substring(B.length());
                n = string4.indexOf(58);
                if (n == -1) {
                    string3 = string4;
                    string2 = null;
                } else {
                    string3 = string4.substring(0, n);
                    string2 = string4.substring(n + 1);
                    if (string2 != null && string2.length() == 1) {
                        string2 = null;
                    }
                }
                log.info("Custom Template Store activating: class=[" + string3 + "] param=[" + string2 + "]");
                ClassLoader classLoader = TemplateStoreFactory.class.getClassLoader();
                try {
                    Class<?> clazz = Class.forName(string3, true, classLoader);
                    if (string2 == null) {
                        log.info("Invoking no-argument constructor for custom TemplateStore");
                        templateStore = (TemplateStore)clazz.newInstance();
                    } else {
                        log.info("Invoking constructor with single String param for custom TemplateStore");
                        templateStore = (TemplateStore)clazz.getConstructor(String.class).newInstance(string2);
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    log.fatal("Unable to instantiate custom Template Store", classNotFoundException);
                }
                catch (InstantiationException instantiationException) {
                    log.fatal("Unable to instantiate custom Template Store", instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    log.fatal("Unable to instantiate custom Template Store", illegalAccessException);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    log.fatal("Unable to instantiate custom Template Store", illegalArgumentException);
                }
                catch (SecurityException securityException) {
                    log.fatal("Unable to instantiate custom Template Store", securityException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    log.fatal("Unable to instantiate custom Template Store", invocationTargetException);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    log.fatal("Unable to instantiate custom Template Store", noSuchMethodException);
                }
                if (templateStore == null) {
                    return null;
                }
                log.info("Custom template store activated.");
            } else if ("DATABASE".equals(string)) {
                log.info("Database Template Store activating");
                templateStore = TemplateStoreFactory.getDatabaseStore();
            } else {
                log.debug("File Template Store activating");
                templateStore = new FileTemplateStore(new File(string));
            }
            boolean bl = DMProperties.getBoolean("docmosis.store.workingstream.compress");
            n = DMProperties.getBoolean("docmosis.store.cache.enabled") ? 1 : 0;
            boolean bl2 = DMProperties.getBoolean("docmosis.store.cache.workingstream.inflateBeforeCaching");
            log.debug("compressing working stream:" + bl);
            log.debug("template ram cache:" + (n != 0));
            log.debug("inflate before cache:" + bl2);
            if (bl && bl2) {
                templateStore = new CompressingTemplateStore(templateStore);
            }
            if (n != 0) {
                int n2 = DMProperties.getInt("docmosis.store.cache.maxTemplateSize", -1);
                int n3 = DMProperties.getInt("docmosis.store.cache.maxSize", 5000000);
                templateStore = new CachingTemplateStore(templateStore, n2, n3);
            }
            if (bl && !bl2) {
                templateStore = new CompressingTemplateStore(templateStore);
            }
            try {
                TemplateStore templateStore2;
                C = templateStore2 = (TemplateStore)Class.forName("com.docmosis.template.store.openoffice.ODFAnalyzingStore").getConstructor(TemplateStore.class).newInstance(templateStore);
            }
            catch (InstantiationException instantiationException) {
                log.error("Unable to initialize the store", instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                log.error("Unable to initialize the store", illegalAccessException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                log.error("Unable to initialize the store", classNotFoundException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                log.error("Unable to initialize the store", illegalArgumentException);
            }
            catch (SecurityException securityException) {
                log.error("Unable to initialize the store", securityException);
            }
            catch (InvocationTargetException invocationTargetException) {
                log.error("Unable to initialize the store", invocationTargetException);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                log.error("Unable to initialize the store", noSuchMethodException);
            }
        }
        return C;
    }

    private static synchronized TemplateStore getDatabaseStore() throws IllegalArgumentException {
        String string = DMProperties.getString("docmosis.database.template.store.datasource");
        if (string == null || string.equals("")) {
            throw new IllegalArgumentException("Property docmosis.database.template.store.datasource not specified.");
        }
        TemplateStore templateStore = null;
        templateStore = TemplateStoreFactory.getDatabaseStoreWithLocallyPooledConnections();
        return templateStore;
    }

    private static synchronized TemplateStore getDatabaseStoreWithLocallyPooledConnections() throws IllegalArgumentException {
        int n;
        int n2;
        int n3;
        String string = DMProperties.getString("docmosis.localpool.database.template.store.vendor");
        String string2 = DMProperties.getString("docmosis.localpool.database.template.store.type");
        String string3 = DMProperties.getString("docmosis.localpool.database.template.store.host");
        String string4 = DMProperties.getString("docmosis.localpool.database.template.store.port");
        String string5 = DMProperties.getString("docmosis.localpool.database.template.store.dbname");
        String string6 = DMProperties.getString("docmosis.localpool.database.template.store.username");
        String string7 = DMProperties.getString("docmosis.localpool.database.template.store.password");
        String string8 = DMProperties.getString("docmosis.localpool.database.template.store.max.connections");
        String string9 = DMProperties.getString("docmosis.localpool.database.template.store.login.timeout");
        String string10 = DMProperties.getString("docmosis.localpool.database.template.store.pool.timeout");
        if (string == null || string.equals("")) {
            throw new IllegalArgumentException("Property docmosis.localpool.database.template.store.vendor not specified.");
        }
        if (string2 == null || string2.equals("")) {
            throw new IllegalArgumentException("Property docmosis.localpool.database.template.store.type not specified.");
        }
        if (string3 == null || string3.equals("")) {
            throw new IllegalArgumentException("Property docmosis.localpool.database.template.store.host not specified.");
        }
        if (string4 == null || string4.equals("")) {
            throw new IllegalArgumentException("Property docmosis.localpool.database.template.store.port not specified.");
        }
        if (string5 == null || string5.equals("")) {
            throw new IllegalArgumentException("Property docmosis.localpool.database.template.store.dbname not specified.");
        }
        if (string6 == null || string6.equals("")) {
            throw new IllegalArgumentException("Property docmosis.localpool.database.template.store.username not specified.");
        }
        if (string7 == null || string7.equals("")) {
            throw new IllegalArgumentException("Property docmosis.localpool.database.template.store.password not specified.");
        }
        if (string8 == null || string8.equals("")) {
            throw new IllegalArgumentException("Property docmosis.localpool.database.template.store.max.connections not specified.");
        }
        if (string9 == null || string9.equals("")) {
            throw new IllegalArgumentException("Property docmosis.localpool.database.template.store.login.timeout not specified.");
        }
        if (string10 == null || string10.equals("")) {
            throw new IllegalArgumentException("Property docmosis.localpool.database.template.store.pool.timeout not specified.");
        }
        try {
            n3 = new Integer(string8);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Property docmosis.localpool.database.template.store.max.connections must be numeric.");
        }
        if (n3 < 1) {
            throw new IllegalArgumentException("Property docmosis.localpool.database.template.store.max.connections must be zero of greater.");
        }
        try {
            n2 = new Integer(string9);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Property docmosis.localpool.database.template.store.login.timeout must be numeric.");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Property docmosis.localpool.database.template.store.login.timeout must be greater than zero.");
        }
        try {
            n = new Integer(string10);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Property docmosis.localpool.database.template.store.pool.timeout must be numeric.");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Property docmosis.localpool.database.template.store.pool.timeout must be zero or greater.");
        }
        StringBuffer stringBuffer = new StringBuffer("jdbc:oracle:");
        try {
            if ("oracle".equals(string)) {
                Class.forName("oracle.jdbc.driver.OracleDriver");
                stringBuffer.append(string2);
                stringBuffer.append(":@");
                stringBuffer.append(string3);
                stringBuffer.append(":");
                stringBuffer.append(string4);
                stringBuffer.append(":");
                stringBuffer.append(string5);
                return new OracleTemplateStore(new PooledDataSource(stringBuffer.toString(), n3, n2, n, string6, string7));
            }
            log.error("Unknown database vendor: " + string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            log.error("An error occurred creating the Oracle template store.", classNotFoundException);
        }
        catch (SQLException sQLException) {
            log.error("An error occurred creating the Oracle template store.  JDBC connection is: " + stringBuffer.toString(), sQLException);
        }
        catch (DatabaseTemplateStoreTableStructureException databaseTemplateStoreTableStructureException) {
            log.error("An error occurred creating the Oracle template store.", databaseTemplateStoreTableStructureException);
        }
        log.warn("Database store vendor unknown: " + string);
        return null;
    }

    public static synchronized void initialise() throws TemplateStoreException {
        Object object;
        String string = DMProperties.getString(PROPERTY_STORE_LOCATION);
        if (string == null) {
            if (log.isDebugEnabled()) {
                log.debug("\"docmosis.template.store.location\" not set - using a temp area");
            }
            try {
                object = FileUtilities.createTempDir("docmosis", "templatestore");
                string = ((File)object).getPath();
                Runtime.getRuntime().addShutdownHook(new Thread(new Runnable((File)object){
                    final /* synthetic */ File A;
                    {
                        this.A = file;
                    }

                    @Override
                    public void run() {
                        FileUtilities.delete(this.A);
                    }
                }, "DMTempStoreCleaner"));
            }
            catch (IOException iOException) {
                throw new TemplateStoreException(iOException.getMessage(), iOException);
            }
        }
        log.debug("Template store location:" + string);
        TemplateStoreFactory.getStore(string);
        object = DMProperties.getString(PROPERTY_TEMPLATE_MONITOR_SOURCE_PATH);
        if (object != null) {
            int n = DMProperties.getInt(PROPERTY_TEMPLATE_MONITOR_PERIOD, 5);
            String string2 = DMProperties.getString(PROPERTY_TEMPLATE_MONITOR_CONTEXT);
            ExternalResourcePermissions externalResourcePermissions = null;
            TemplateSourceMonitor.start(C, (String)object, n, string2 != null ? new TemplateContext(string2) : null, externalResourcePermissions);
        }
    }

    public static synchronized void release() {
        C = null;
        A.clear();
        TemplateSourceMonitor.shutdown();
    }

    static boolean isTemplateErrorsFatal() {
        return DMProperties.getBoolean("docmosis.analyzer.error.fatal", false);
    }

    static String getPlainTextFieldPrefix() {
        return DMProperties.getString(PROPERTY_PLAINTEXT_FIELD_PREFIX);
    }

    static String getPlainTextFieldSuffix() {
        return DMProperties.getString(PROPERTY_PLAINTEXT_FIELD_SUFFIX);
    }

    static boolean getAllowPaddedFields() {
        return DMProperties.getBoolean(PROPERTY_FIELD_ALLOW_PADDED, true);
    }

    public static class PresetTemplateStore
    implements TemplateStore {
        final TemplateStore delegate;
        final boolean templateErrorsFatal;
        final String plainTextFieldPrefix;
        final String plainTextFieldSuffix;
        final boolean allowPaddedFields;
        final PropertiesProvider propertiesProvider;

        private PresetTemplateStore(TemplateStore templateStore, boolean bl, String string, String string2, boolean bl2, PropertiesProvider propertiesProvider) {
            this.delegate = templateStore;
            this.templateErrorsFatal = bl;
            this.plainTextFieldPrefix = string;
            this.plainTextFieldSuffix = string2;
            this.allowPaddedFields = bl2;
            this.propertiesProvider = propertiesProvider;
        }

        public int hashCode() {
            int n = 31;
            int n2 = 1;
            n2 = 31 * n2 + (this.allowPaddedFields ? 1231 : 1237);
            n2 = 31 * n2 + (this.delegate == null ? 0 : this.delegate.hashCode());
            n2 = 31 * n2 + (this.plainTextFieldPrefix == null ? 0 : this.plainTextFieldPrefix.hashCode());
            n2 = 31 * n2 + (this.plainTextFieldSuffix == null ? 0 : this.plainTextFieldSuffix.hashCode());
            n2 = 31 * n2 + (this.templateErrorsFatal ? 1231 : 1237);
            return n2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            PresetTemplateStore presetTemplateStore = (PresetTemplateStore)object;
            if (this.allowPaddedFields != presetTemplateStore.allowPaddedFields) {
                return false;
            }
            if (this.delegate == null ? presetTemplateStore.delegate != null : !this.delegate.equals(presetTemplateStore.delegate)) {
                return false;
            }
            if (this.plainTextFieldPrefix == null ? presetTemplateStore.plainTextFieldPrefix != null : !this.plainTextFieldPrefix.equals(presetTemplateStore.plainTextFieldPrefix)) {
                return false;
            }
            if (this.plainTextFieldSuffix == null ? presetTemplateStore.plainTextFieldSuffix != null : !this.plainTextFieldSuffix.equals(presetTemplateStore.plainTextFieldSuffix)) {
                return false;
            }
            return this.templateErrorsFatal == presetTemplateStore.templateErrorsFatal;
        }

        @Override
        public void deleteAll() throws TemplateStoreException {
            this.delegate.deleteAll();
        }

        @Override
        public void deleteTemplate(TemplateIdentifier templateIdentifier) throws TemplateStoreException {
            this.delegate.deleteTemplate(templateIdentifier);
        }

        @Override
        public void deleteTemplates(TemplateContext templateContext, boolean bl) throws TemplateStoreException {
            this.delegate.deleteTemplates(templateContext, bl);
        }

        @Override
        public TemplateDetails[] findByContext(TemplateContext templateContext, boolean bl) throws IOException, TemplateStoreException {
            return this.delegate.findByContext(templateContext, bl);
        }

        @Override
        public InputStream getOriginalTemplate(TemplateIdentifier templateIdentifier) throws IOException, TemplateNotFoundException {
            return this.delegate.getOriginalTemplate(templateIdentifier);
        }

        @Override
        public Template getTemplate(TemplateIdentifier templateIdentifier) throws IOException, TemplateNotFoundException, TemplateStoreException {
            return this.delegate.getTemplate(templateIdentifier);
        }

        @Override
        public TemplateAnalysis getTemplateAnalysis(TemplateIdentifier templateIdentifier) throws IOException, TemplateNotFoundException, TemplateStoreException {
            return this.delegate.getTemplateAnalysis(templateIdentifier);
        }

        @Override
        public long getTemplateStoredTime(TemplateIdentifier templateIdentifier) throws TemplateStoreException {
            return this.delegate.getTemplateStoredTime(templateIdentifier);
        }

        @Override
        public TemplateDetails storeTemplate(TemplateIdentifier templateIdentifier, InputStream inputStream, Long l, InputStream inputStream2, TemplateAnalysis templateAnalysis, InputStream inputStream3, boolean bl, boolean bl2, String string, String string2, boolean bl3, PropertiesProvider propertiesProvider) throws IOException, TemplateAlreadyExistsException, TemplateStoreException {
            return this.delegate.storeTemplate(templateIdentifier, inputStream, l, inputStream2, templateAnalysis, inputStream3, bl, this.templateErrorsFatal, this.plainTextFieldPrefix, this.plainTextFieldSuffix, this.allowPaddedFields, this.propertiesProvider);
        }
    }
}

