/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.template.store;

import com.docmosis.document.DocumentProcessor;
import com.docmosis.document.ExternalResourcePermissions;
import com.docmosis.document.converter.NoConvertersRunningException;
import com.docmosis.document.converter.pool.ConverterPoolException;
import com.docmosis.template.TemplateStoreException;
import com.docmosis.template.store.DropStoreHelper;
import com.docmosis.template.store.TemplateContext;
import com.docmosis.template.store.TemplateStore;
import com.docmosis.template.store.TemplateStoreFactory;
import com.docmosis.util.logging.LogManager;
import com.docmosis.util.logging.Logger;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class TemplateSourceMonitor
implements Runnable {
    private static final Logger B = LogManager.getLogger(TemplateSourceMonitor.class);
    private static TemplateSourceMonitor H = null;
    private final TemplateStore F;
    private final TemplateContext G;
    private final int A;
    private final File[] I;
    private final Thread E;
    private boolean C;
    private final ExternalResourcePermissions D;

    private TemplateSourceMonitor(TemplateStore templateStore, File[] fileArray, int n, TemplateContext templateContext, ExternalResourcePermissions externalResourcePermissions) {
        this.F = templateStore;
        this.A = n;
        this.I = fileArray;
        this.G = templateContext;
        this.D = externalResourcePermissions;
        this.E = new Thread((Runnable)this, "DMTemplatesWatcher");
        this.E.setDaemon(true);
        this.E.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = this;
        synchronized (object) {
            this.C = true;
        }
        object = new DropStoreHelper(this.F, this.D);
        try {
            while (!DocumentProcessor.hasOnlineConverters()) {
                Thread.sleep(200L);
            }
            this.searchForUpdates((DropStoreHelper)object);
            if (this.A < 1) {
                return;
            }
            while (this.C) {
                Thread.sleep(this.A * 1000);
                this.searchForUpdates((DropStoreHelper)object);
            }
        }
        catch (InterruptedException interruptedException) {
            TemplateStoreFactory.log.debug("shutdown");
        }
        catch (ConverterPoolException converterPoolException) {
            TemplateStoreFactory.log.error("Unable to process template directories", converterPoolException);
        }
    }

    private synchronized void searchForUpdates(DropStoreHelper dropStoreHelper) throws ConverterPoolException {
        if (!DocumentProcessor.hasOnlineConverters()) {
            return;
        }
        for (int i = 0; i < this.I.length; ++i) {
            File file = this.I[i];
            if (!file.isDirectory() || !file.canRead()) continue;
            try {
                dropStoreHelper.process(file, this.G, true);
                continue;
            }
            catch (TemplateStoreException templateStoreException) {
                TemplateStoreFactory.log.error("Error processing templates in path: " + file, templateStoreException);
                continue;
            }
            catch (IOException iOException) {
                TemplateStoreFactory.log.error("Error processing templates in path: " + file, iOException);
                continue;
            }
            catch (NoConvertersRunningException noConvertersRunningException) {
                TemplateStoreFactory.log.error("Error processing templates in path: " + file, noConvertersRunningException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownInstance() {
        if (this.E != null) {
            TemplateSourceMonitor templateSourceMonitor = this;
            synchronized (templateSourceMonitor) {
                this.C = false;
                this.E.interrupt();
            }
        }
    }

    public static synchronized void start(TemplateStore templateStore, String string, int n, TemplateContext templateContext, ExternalResourcePermissions externalResourcePermissions) {
        File[] fileArray;
        if (H != null) {
            H.shutdownInstance();
        }
        if (n < 0 || string == null || "".equals(string.trim())) {
            B.debug("TemplateSourceMonitor - return since no work to do");
            return;
        }
        if (templateStore == null) {
            throw new IllegalArgumentException("Cannot monitor template paths, no store found");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            fileArray = stringTokenizer.nextToken();
            if (fileArray == null) continue;
            arrayList.add(fileArray.trim());
        }
        if (arrayList.size() == 0) {
            TemplateStoreFactory.log.warn("Bad template search path ignored: \"" + string + "\".  You need to correct " + "property \"" + "docmosis.template.monitor.sourcepath" + "\"");
        } else {
            fileArray = new File[arrayList.size()];
            for (int i = 0; i < fileArray.length; ++i) {
                fileArray[i] = new File(((String)arrayList.get(i)).trim());
            }
            H = new TemplateSourceMonitor(templateStore, fileArray, n, templateContext, externalResourcePermissions);
        }
    }

    public static synchronized void shutdown() {
        if (H != null) {
            H.shutdownInstance();
            H = null;
        }
    }
}

