/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.template.store;

import com.docmosis.template.store.TemplateContext;
import com.docmosis.util.Equivalence;
import com.docmosis.util.StringUtilities;

public class TemplateIdentifier {
    private static volatile short A = 1;
    private String B;
    private TemplateContext C;

    public TemplateIdentifier(String string) {
        this(string, (TemplateContext)null);
    }

    public TemplateIdentifier(String string, String string2) {
        this(string, StringUtilities.isEmpty(string2) ? null : new TemplateContext(string2));
    }

    public TemplateIdentifier(String string, TemplateContext templateContext) {
        this.B = string;
        this.C = templateContext;
        if (this.C != null && (this.C.getPath().equals("/") || this.C.getPath().equals("\\"))) {
            this.C = null;
        }
    }

    public String getName() {
        return this.B;
    }

    public static TemplateIdentifier fromPath(String string) {
        if (StringUtilities.isEmpty(string)) {
            throw new IllegalArgumentException("fullPath cannot be null or empty");
        }
        if ((string = string.trim().replace('\\', '/')).endsWith("/")) {
            throw new IllegalArgumentException("fullPath must end in a template name");
        }
        int n = string.lastIndexOf(47);
        if (n != -1) {
            return new TemplateIdentifier(string.substring(n + 1), string.substring(0, n));
        }
        return new TemplateIdentifier(string);
    }

    public TemplateContext getContext() {
        return this.C;
    }

    public String getFullPath() {
        if (this.C == null) {
            return this.B;
        }
        return this.C.getPath() + "/" + this.B;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof TemplateIdentifier)) {
            return false;
        }
        TemplateIdentifier templateIdentifier = (TemplateIdentifier)object;
        return Equivalence.equivalentObjects(this.B, templateIdentifier.B) && Equivalence.equivalentObjects(this.C, templateIdentifier.C);
    }

    public int hashCode() {
        if (this.B == null && this.C == null) {
            return 0;
        }
        if (this.B == null) {
            return this.C.hashCode();
        }
        if (this.C == null) {
            return this.B.hashCode();
        }
        return this.B.hashCode() + this.C.hashCode();
    }

    public String toString() {
        return this.getFullPath();
    }

    public static TemplateIdentifier createUniqueTempTemplateIdentifier() {
        StringBuffer stringBuffer = new StringBuffer();
        if ((A = (short)(A + 1)) < 1) {
            A = 1;
        }
        stringBuffer.append("tmp/tmplt").append((int)(Math.random() * 1000.0)).append('.').append(A).append('.').append(String.valueOf(System.currentTimeMillis()));
        return TemplateIdentifier.fromPath(stringBuffer.toString());
    }
}

