/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.template.store;

import com.docmosis.document.ExternalResourceCollection;
import com.docmosis.document.ExternalResourceExtractor;
import com.docmosis.document.ExternalResourcePermissions;
import com.docmosis.document.ExternalResourcePermissionsCheckResult;
import com.docmosis.document.converter.ConversionException;
import com.docmosis.document.converter.ConversionFormat;
import com.docmosis.document.converter.ConversionInstruction;
import com.docmosis.document.converter.ConversionSettings;
import com.docmosis.document.converter.ConversionSettingsHelper;
import com.docmosis.document.converter.DocumentFormatConverter;
import com.docmosis.document.converter.ExtendedConversionInstructionProvider;
import com.docmosis.document.converter.NoConvertersRunningException;
import com.docmosis.document.converter.pool.ConverterPool;
import com.docmosis.document.converter.pool.ConverterPoolException;
import com.docmosis.template.BasicDocument;
import com.docmosis.template.TemplateDetails;
import com.docmosis.template.TemplateParseException;
import com.docmosis.template.TemplateStoreException;
import com.docmosis.template.TemplateValidationResult;
import com.docmosis.template.analysis.MessageAndSuggestions;
import com.docmosis.template.analysis.PreAnalysisInfo;
import com.docmosis.template.analysis.TemplateAnalysis;
import com.docmosis.template.population.PopulatedFilesCollection;
import com.docmosis.template.security.crash.TemplateDefence;
import com.docmosis.template.store.TemplateIdentifier;
import com.docmosis.template.store.TemplateStore;
import com.docmosis.template.store.TemplateStoreFactory;
import com.docmosis.util.DMProperties;
import com.docmosis.util.FileUtilities;
import com.docmosis.util.logging.LogManager;
import com.docmosis.util.logging.Logger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class StoreHelper {
    private static final Logger B = LogManager.getLogger(StoreHelper.class);
    private static final int A = DMProperties.getInt("docmosis.render.maxRetries");
    private static final String C = "blank.odt";
    public static final String PROP_EXTERNAL_RESOURCES_EXTRACT_ENABLED = "docmosis.analyzer.preprocessor.externalResource.extract.enabled";
    public static final String PROP_EXTERNAL_RESOURCES_DEFAULT_PERMISSION = "docmosis.analyzer.preprocessor.externalResource.permission.default";
    public static final String PROP_EXTERNAL_RESOURCES_COMPARE_CASE_INSENSITIVE = "docmosis.analyzer.preprocessor.externalResource.compare.caseInsensitive";
    public static final String PROP_EXTERNAL_RESOURCES_COMPARE_DECODE_URLS = "docmosis.analyzer.preprocessor.externalResource.compare.decodeUrls";

    public static TemplateDetails storeTemplate(String string, File file, TemplateStore templateStore) throws IOException, ConversionException, TemplateStoreException, NoConvertersRunningException {
        return StoreHelper.storeTemplate(string, file, true, templateStore, null);
    }

    public static TemplateDetails storeTemplate(String string, File file, TemplateStore templateStore, ExternalResourcePermissions externalResourcePermissions) throws IOException, ConversionException, TemplateStoreException, NoConvertersRunningException {
        return StoreHelper.storeTemplate(string, file, true, templateStore, externalResourcePermissions);
    }

    public static TemplateDetails storeTemplate(String string, File file, boolean bl, TemplateStore templateStore, ExternalResourcePermissions externalResourcePermissions) throws IOException, ConversionException, TemplateStoreException, NoConvertersRunningException {
        TemplateIdentifier templateIdentifier = new TemplateIdentifier(string);
        return StoreHelper.storeTemplate(templateIdentifier, file, bl, true, templateStore, externalResourcePermissions, null);
    }

    public static TemplateDetails storeTemplate(TemplateIdentifier templateIdentifier, File file, TemplateStore templateStore) throws IOException, ConversionException, TemplateStoreException, NoConvertersRunningException {
        return StoreHelper.storeTemplate(templateIdentifier, file, true, true, templateStore, null, null);
    }

    public static TemplateDetails storeTemplate(TemplateIdentifier templateIdentifier, File file, TemplateStore templateStore, ExternalResourcePermissions externalResourcePermissions) throws IOException, ConversionException, TemplateStoreException, NoConvertersRunningException {
        return StoreHelper.storeTemplate(templateIdentifier, file, true, true, templateStore, externalResourcePermissions, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TemplateDetails storeTemplate(TemplateIdentifier templateIdentifier, InputStream inputStream, Long l, boolean bl, boolean bl2, TemplateStore templateStore, ExternalResourcePermissions externalResourcePermissions) throws IOException, ConversionException, TemplateStoreException, NoConvertersRunningException {
        File file = FileUtilities.createTempFile("dm_sth", ".tmp");
        try {
            FileUtilities.storeToFile(inputStream, file);
            if (l != null) {
                file.setLastModified(l);
            }
            TemplateDetails templateDetails = StoreHelper.storeTemplate(templateIdentifier, file, bl, bl2, templateStore, externalResourcePermissions, null);
            return templateDetails;
        }
        finally {
            FileUtilities.delete(file);
        }
    }

    public static TemplateDetails storeTemplate(TemplateIdentifier templateIdentifier, File file, boolean bl, boolean bl2, TemplateStore templateStore) throws IOException, ConversionException, TemplateStoreException, NoConvertersRunningException {
        return StoreHelper.storeTemplate(templateIdentifier, file, bl, bl2, templateStore, null, null);
    }

    public static TemplateDetails storeTemplate(TemplateIdentifier templateIdentifier, File file, boolean bl, boolean bl2, TemplateStore templateStore, ExternalResourcePermissions externalResourcePermissions) throws IOException, ConversionException, TemplateStoreException, NoConvertersRunningException {
        return StoreHelper.storeTemplate(templateIdentifier, file, bl, bl2, templateStore, externalResourcePermissions, null);
    }

    public static TemplateDetails storeTemplate(TemplateIdentifier templateIdentifier, File file, boolean bl, boolean bl2, TemplateStore templateStore, ExternalResourcePermissions externalResourcePermissions, ConversionSettings conversionSettings) throws IOException, ConversionException, TemplateStoreException, NoConvertersRunningException {
        Object object;
        Object object2;
        if (file == null || !file.canRead()) {
            throw new TemplateStoreException("Unable to read template file:" + (file == null ? "<null>" : file.getPath()));
        }
        TemplateDefence.runEarlyFileChecks(file);
        ExternalResourceCollection externalResourceCollection = null;
        if (DMProperties.getBoolean(PROP_EXTERNAL_RESOURCES_EXTRACT_ENABLED, true)) {
            externalResourceCollection = ExternalResourceExtractor.extract(file);
        }
        boolean bl3 = DMProperties.getBoolean(PROP_EXTERNAL_RESOURCES_COMPARE_CASE_INSENSITIVE, true);
        boolean bl4 = DMProperties.getBoolean(PROP_EXTERNAL_RESOURCES_COMPARE_DECODE_URLS, true);
        ExternalResourcePermissionsCheckResult externalResourcePermissionsCheckResult = ExternalResourcePermissions.permitted(externalResourcePermissions == null ? StoreHelper.getDefaultExternalResourcePermission() : externalResourcePermissions, externalResourceCollection, bl3, bl4);
        BasicDocument basicDocument = null;
        if (!externalResourcePermissionsCheckResult.isPermitted()) {
            basicDocument = new BasicDocument(StoreHelper.class.getResourceAsStream(C));
        } else {
            object2 = null;
            object = null;
            for (int i = 0; i <= A; ++i) {
                boolean bl5 = false;
                try {
                    object2 = ConverterPool.getConverter(bl2);
                    object = new PopulatedFilesCollection();
                    ((PopulatedFilesCollection)object).add(null, file, true, true, null, null, null, null);
                    ConversionInstruction conversionInstruction = templateStore instanceof ExtendedConversionInstructionProvider ? ((ExtendedConversionInstructionProvider)((Object)templateStore)).getConversionInstruction() : new ConversionInstruction();
                    conversionInstruction.setConversionFormats(new ConversionFormat[]{ConversionFormat.FORMAT_ODT});
                    if (conversionSettings == null) {
                        conversionSettings = ConversionSettingsHelper.getDefaultConversionSettings();
                    }
                    if (!FileUtilities.isDocxFormat(file)) {
                        conversionSettings.setRemoveExternalChartReferences(false);
                        conversionSettings.setExtractSensitivityLabels(false);
                    }
                    try {
                        basicDocument = object2.convert((PopulatedFilesCollection)object, conversionInstruction, conversionSettings);
                        break;
                    }
                    catch (ConversionException conversionException) {
                        try {
                            if (conversionException.isDueToServiceFailure()) {
                                bl5 = true;
                                if (i > A - 1) {
                                    throw conversionException;
                                }
                            } else {
                                throw conversionException;
                            }
                            B.info("Retrying convert for store: attempt number " + (i + 1));
                        }
                        catch (ConverterPoolException converterPoolException) {
                            throw new ConversionException("Unable to get a converter", converterPoolException);
                        }
                        ConverterPool.returnConverter((DocumentFormatConverter)object2, bl5);
                        continue;
                    }
                }
                finally {
                    ConverterPool.returnConverter((DocumentFormatConverter)object2, bl5);
                }
            }
        }
        object2 = null;
        object = null;
        Object var14_15 = null;
        try {
            PreAnalysisInfo preAnalysisInfo = new PreAnalysisInfo(basicDocument.getPocessedByExternalConverter(), basicDocument.getFontInfo(), basicDocument.getSensitivityLabelInfo(), externalResourceCollection, !externalResourcePermissionsCheckResult.isPermitted());
            object2 = new BasicDocument(new File(file.getCanonicalPath()));
            object = templateStore.storeTemplate(templateIdentifier, object2.getInputStream(), file.lastModified(), basicDocument.getInputStream(), preAnalysisInfo, null, bl, TemplateStoreFactory.isTemplateErrorsFatal(), TemplateStoreFactory.getPlainTextFieldPrefix(), TemplateStoreFactory.getPlainTextFieldSuffix(), TemplateStoreFactory.getAllowPaddedFields(), null);
            B.debug(templateIdentifier + " stored in the template store");
        }
        catch (TemplateStoreException templateStoreException) {
            if (templateStoreException.getCause() instanceof TemplateParseException) {
                throw new ConversionException(templateStoreException.getMessage(), templateStoreException);
            }
            throw templateStoreException;
        }
        catch (RuntimeException runtimeException) {
            throw new TemplateStoreException("Unable to store template:" + runtimeException.getMessage(), runtimeException);
        }
        finally {
            BasicDocument.cleanup(basicDocument, true);
            if (object2 != null) {
                object2.cleanup();
            }
            if (var14_15 != null) {
                var14_15 = null;
            }
        }
        return object;
    }

    public static boolean templateExists(TemplateIdentifier templateIdentifier, TemplateStore templateStore) throws IOException, TemplateStoreException {
        return templateStore.getTemplateStoredTime(templateIdentifier) != -1L;
    }

    public static TemplateValidationResult validateTemplate(InputStream inputStream) throws TemplateStoreException {
        return StoreHelper.validateTemplate(inputStream, null);
    }

    public static TemplateValidationResult validateTemplate(InputStream inputStream, ExternalResourcePermissions externalResourcePermissions) throws TemplateStoreException {
        TemplateIdentifier templateIdentifier = TemplateIdentifier.createUniqueTempTemplateIdentifier();
        TemplateStore templateStore = TemplateStoreFactory.getStore(false);
        try {
            StoreHelper.storeTemplate(templateIdentifier, inputStream, System.currentTimeMillis(), true, false, templateStore, externalResourcePermissions);
            TemplateAnalysis templateAnalysis = TemplateStoreFactory.getStore().getTemplateAnalysis(templateIdentifier);
            if (templateAnalysis.hasTemplateErrors()) {
                TemplateValidationResult templateValidationResult = new TemplateValidationResult(templateAnalysis.getTemplateErrorMessages());
                return templateValidationResult;
            }
            TemplateValidationResult templateValidationResult = new TemplateValidationResult(null);
            return templateValidationResult;
        }
        catch (ConversionException conversionException) {
            MessageAndSuggestions[] messageAndSuggestionsArray = new MessageAndSuggestions[1];
            String string = "Unable to process the template - bad / corrupt stream";
            if (B.isDebugEnabled()) {
                B.error("Unable to process the template - bad / corrupt stream", conversionException);
            }
            messageAndSuggestionsArray[0] = new MessageAndSuggestions("Unable to process the template - bad / corrupt stream", null);
            TemplateValidationResult templateValidationResult = new TemplateValidationResult(messageAndSuggestionsArray);
            return templateValidationResult;
        }
        catch (NoConvertersRunningException noConvertersRunningException) {
            throw new TemplateStoreException(noConvertersRunningException);
        }
        catch (IOException iOException) {
            throw new TemplateStoreException(iOException);
        }
        finally {
            templateStore.deleteTemplate(templateIdentifier);
        }
    }

    public static ExternalResourcePermissions getDefaultExternalResourcePermission() {
        ExternalResourcePermissions externalResourcePermissions = "NONE".equalsIgnoreCase(DMProperties.getString(PROP_EXTERNAL_RESOURCES_DEFAULT_PERMISSION)) ? ExternalResourcePermissions.NONE : ExternalResourcePermissions.ALL;
        return externalResourcePermissions;
    }
}

