/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.template.store;

import com.docmosis.document.ExternalResourcePermissions;
import com.docmosis.document.converter.ConversionException;
import com.docmosis.document.converter.NoConvertersRunningException;
import com.docmosis.document.converter.pool.ConverterPoolException;
import com.docmosis.template.Template;
import com.docmosis.template.TemplateAlreadyExistsException;
import com.docmosis.template.TemplateStoreException;
import com.docmosis.template.TemplateValidationResult;
import com.docmosis.template.analysis.TemplateAnalysis;
import com.docmosis.template.store.StoreHelper;
import com.docmosis.template.store.TemplateContext;
import com.docmosis.template.store.TemplateIdentifier;
import com.docmosis.template.store.TemplateStore;
import com.docmosis.util.B;
import com.docmosis.util.DMProperties;
import com.docmosis.util.FileUtilities;
import com.docmosis.util.StringUtilities;
import com.docmosis.util.ZipValiationUtilities;
import com.docmosis.util.logging.LogManager;
import com.docmosis.util.logging.Logger;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.MessageDigest;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import sun.net.www.protocol.file.FileURLConnection;

public class DropStoreHelper {
    private static final Logger C = LogManager.getLogger(DropStoreHelper.class);
    private static final boolean D = DMProperties.getBoolean("docmosis.store.dropstore.compareWithTimestamps", true);
    private static final boolean J = DMProperties.getBoolean("docmosis.store.dropstore.error.continue", true);
    private static final String A = "dot,doc,odt,odf,docx,rtf";
    private static final String B = "docmosis.store.dropstore.template.extensions";
    static final String PROP_ZIP_SLIP_CHECK_ENABLED = "docmosis.zipSlipValidation.enabled";
    static final String PROP_ZIP_SLIP_CHECK_ABS_PATH_ALLOWED = "docmosis.zipSlipValidation.absolutePathAllowed";
    private static final Set G = new HashSet();
    private final boolean F = DMProperties.getBoolean("docmosis.zipSlipValidation.enabled", true);
    private final boolean H = DMProperties.getBoolean("docmosis.zipSlipValidation.absolutePathAllowed", false);
    private final TemplateStore I;
    private final ExternalResourcePermissions E;

    public DropStoreHelper(TemplateStore templateStore) {
        this(templateStore, null);
    }

    public DropStoreHelper(TemplateStore templateStore, ExternalResourcePermissions externalResourcePermissions) {
        this.I = templateStore;
        this.E = externalResourcePermissions;
    }

    public void process(File file) throws IOException, ConversionException, ConverterPoolException, TemplateStoreException, NoConvertersRunningException {
        this.process(file, true);
    }

    public void process(File file, TemplateContext templateContext) throws TemplateStoreException, IOException, NoConvertersRunningException {
        this.processDirectory(file, templateContext, true, J);
    }

    public void process(File file, TemplateContext templateContext, boolean bl) throws TemplateStoreException, IOException, NoConvertersRunningException {
        this.processDirectory(file, templateContext, bl, J);
    }

    public void process(File file, boolean bl) throws TemplateStoreException, IOException, NoConvertersRunningException {
        this.processDirectory(file, null, bl, J);
    }

    public void processDirectory(File file, TemplateContext templateContext, final boolean bl, boolean bl2) throws TemplateStoreException, IOException, NoConvertersRunningException {
        File[] fileArray;
        File file2 = null;
        if (file == null || !file.exists()) {
            throw new TemplateStoreException("Template source directory does not exist: " + (file == null ? "<null>" : file.getCanonicalPath()));
        }
        if (!file.isDirectory()) {
            throw new TemplateStoreException("Given source is not a directory:" + file.getCanonicalPath());
        }
        if (!file.canRead()) {
            throw new TemplateStoreException("Cannot read given source directory:" + file.getCanonicalPath());
        }
        boolean bl3 = C.isTraceEnabled();
        if (bl3) {
            C.trace("Drop directory: " + file.getCanonicalPath());
        }
        if ((fileArray = file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory() || DropStoreHelper.isJarOrZipFile(file)) {
                    return bl;
                }
                return DropStoreHelper.this.isTemplateFileName(file.getName());
            }
        })) == null) {
            return;
        }
        if (bl3) {
            C.trace("Number of files: " + fileArray.length);
        }
        for (int i = 0; i < fileArray.length; ++i) {
            try {
                file2 = fileArray[i];
                if (file2.isDirectory()) {
                    if (!bl) continue;
                    TemplateContext templateContext2 = null;
                    templateContext2 = templateContext == null ? new TemplateContext(file2.getName()) : new TemplateContext(templateContext + File.separator + file2.getName());
                    this.processDirectory(file2, templateContext2, bl, bl2);
                    continue;
                }
                if (DropStoreHelper.isJarOrZipFile(file2)) {
                    if (!bl) continue;
                    this.processJarOrZipFile(file2, templateContext, bl2);
                    continue;
                }
                if (this.isTemplate(file2)) {
                    if (this.isNewOrModified(file2, file2.getName(), templateContext)) {
                        C.info("Processing: " + file2);
                        this.store(file2.getName(), file2, templateContext);
                        C.info("Registered: " + file2);
                        continue;
                    }
                    if (!bl3) continue;
                    C.trace("Ignoring: " + file2 + " -->  Not new or modified.");
                    continue;
                }
                if (!bl3) continue;
                C.trace("Ignoring: " + file2 + " -->  Not a template.");
                continue;
            }
            catch (IOException iOException) {
                this.handleException(file2, templateContext, (Exception)iOException);
                if (bl2) continue;
                throw iOException;
            }
            catch (ConversionException conversionException) {
                this.handleException(file2, templateContext, (Exception)conversionException);
                if (bl2) continue;
                throw new TemplateStoreException("Unable to process template", conversionException);
            }
            catch (ConverterPoolException converterPoolException) {
                this.handleException(file2, templateContext, (Exception)converterPoolException);
                if (bl2) continue;
                throw new TemplateStoreException("Unable to process template", converterPoolException);
            }
            catch (TemplateStoreException templateStoreException) {
                this.handleException(file2, templateContext, (Exception)templateStoreException);
                if (bl2) continue;
                throw templateStoreException;
            }
        }
    }

    public void processJarOrZipFile(File file) throws NoConvertersRunningException, IOException, ConversionException, ConverterPoolException, TemplateStoreException {
        this.processJarOrZipFile(file, null, J);
    }

    /*
     * Exception decompiling
     */
    public void processJarOrZipFile(File var1_1, TemplateContext var2_2, boolean var3_3) throws NoConvertersRunningException, IOException, ConversionException, ConverterPoolException, TemplateStoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static int getLastPathSeparatorIndex(String string) {
        int n = string.lastIndexOf(47);
        int n2 = string.lastIndexOf(92);
        if (n == -1) {
            return n2;
        }
        if (n2 == -1) {
            return n;
        }
        return Math.max(n, n2);
    }

    public void processResource(URL uRL) throws IOException, TemplateStoreException, NoConvertersRunningException, ConversionException {
        this.processResource(uRL, null, J);
    }

    public void processResource(URL uRL, TemplateContext templateContext, boolean bl) throws IOException, TemplateStoreException, NoConvertersRunningException, ConversionException {
        if (uRL == null) {
            throw new IOException("Cannot open url: null");
        }
        URLConnection uRLConnection = uRL.openConnection();
        if (uRLConnection instanceof FileURLConnection) {
            File file = new File(uRL.getFile());
            if (file.isDirectory()) {
                this.processDirectory(file, templateContext, true, bl);
            } else if (DropStoreHelper.isJarOrZipFile(file)) {
                try {
                    this.processJarOrZipFile(file, templateContext, bl);
                }
                catch (ConversionException conversionException) {
                    throw new TemplateStoreException("Error processing jar file:" + file.getName(), conversionException);
                }
                catch (ConverterPoolException converterPoolException) {
                    throw new TemplateStoreException("Error processing jar file:" + file.getName(), converterPoolException);
                }
            }
        } else if (uRLConnection instanceof JarURLConnection) {
            JarURLConnection jarURLConnection = (JarURLConnection)uRLConnection;
            Enumeration<JarEntry> enumeration = jarURLConnection.getJarFile().entries();
            String string = jarURLConnection.getEntryName();
            while (enumeration.hasMoreElements()) {
                Object object;
                JarEntry jarEntry = enumeration.nextElement();
                if (this.F && (object = ZipValiationUtilities.validateSafePath(jarEntry, this.H)) != null) {
                    throw new IOException("archive " + (String)object);
                }
                if (!jarEntry.getName().startsWith(jarURLConnection.getEntryName()) || !this.isTemplateFileName(jarEntry.getName())) continue;
                object = DropStoreHelper.getRelativeContext(string, jarEntry.getName(), templateContext);
                if (C.isDebugEnabled()) {
                    C.debug("Processing:" + jarEntry.getName() + " size:" + jarEntry.getSize());
                }
                int n = DropStoreHelper.getLastPathSeparatorIndex(jarEntry.getName());
                String string2 = jarEntry.getName();
                if (n != -1) {
                    string2 = string2.substring(n);
                }
                TemplateIdentifier templateIdentifier = new TemplateIdentifier(string2, (TemplateContext)object);
                InputStream inputStream = jarURLConnection.getJarFile().getInputStream(jarEntry);
                try {
                    StoreHelper.storeTemplate(templateIdentifier, inputStream, jarEntry.getTime(), true, false, this.I, this.E);
                }
                catch (TemplateAlreadyExistsException templateAlreadyExistsException) {
                    this.handleException(string2, (TemplateContext)object, (Exception)templateAlreadyExistsException);
                    if (bl) continue;
                    throw templateAlreadyExistsException;
                }
                catch (IOException iOException) {
                    this.handleException(string2, (TemplateContext)object, (Exception)iOException);
                    if (bl) continue;
                    throw iOException;
                }
                catch (TemplateStoreException templateStoreException) {
                    this.handleException(string2, (TemplateContext)object, (Exception)templateStoreException);
                    if (bl) continue;
                    throw templateStoreException;
                }
                catch (ConversionException conversionException) {
                    this.handleException(string2, (TemplateContext)object, (Exception)conversionException);
                    if (bl) continue;
                    throw conversionException;
                }
            }
        }
    }

    public static TemplateValidationResult validateTemplate(InputStream inputStream, ExternalResourcePermissions externalResourcePermissions) throws TemplateStoreException {
        return StoreHelper.validateTemplate(inputStream, externalResourcePermissions);
    }

    private static TemplateContext getRelativeContext(String string, String string2, TemplateContext templateContext) {
        if (string2.startsWith(string) && string2.length() != string.length()) {
            int n;
            StringBuffer stringBuffer = new StringBuffer();
            if (templateContext != null) {
                stringBuffer.append(templateContext.getPath());
            }
            if ((n = DropStoreHelper.getLastPathSeparatorIndex(string2)) != -1) {
                string2 = string2.substring(0, n);
            }
            if (string2.length() >= string.length()) {
                string2 = string2.substring(string.length());
            }
            stringBuffer.append(string2);
            if (stringBuffer.length() == 0) {
                return null;
            }
            while (stringBuffer.length() > 0 && stringBuffer.charAt(0) == '/') {
                stringBuffer.deleteCharAt(0);
            }
            return new TemplateContext(stringBuffer.toString());
        }
        return templateContext;
    }

    private void handleException(String string, TemplateContext templateContext, Exception exception) {
        TemplateIdentifier templateIdentifier = null;
        if (string != null) {
            templateIdentifier = new TemplateIdentifier(string, templateContext);
        }
        this.handleException(templateIdentifier, exception);
    }

    private void handleException(File file, TemplateContext templateContext, Exception exception) {
        TemplateIdentifier templateIdentifier = null;
        if (file != null) {
            templateIdentifier = new TemplateIdentifier(file.getName(), templateContext);
        }
        this.handleException(templateIdentifier, exception);
    }

    private void handleException(TemplateIdentifier templateIdentifier, Exception exception) {
        C.error("An error encountered during processing", exception);
        if (templateIdentifier != null) {
            try {
                this.I.deleteTemplate(templateIdentifier);
            }
            catch (TemplateStoreException templateStoreException) {
                C.error("Error deleting template", templateStoreException);
            }
        }
    }

    private boolean isTemplate(File file) {
        if (file == null) {
            C.warn("Attempting to process a null file.");
            return false;
        }
        return file.isFile() && this.isTemplateFileName(file.getName());
    }

    private static boolean isJarOrZipFile(File file) {
        if (file == null) {
            C.warn("Attempting to process a null file.");
            return false;
        }
        String string = file.getName().toLowerCase();
        return file.isFile() && (string.endsWith(".jar") || string.endsWith(".zip"));
    }

    private boolean isTemplateFileName(String string) {
        if (string == null || string.startsWith("~")) {
            return false;
        }
        String string2 = FileUtilities.getFilenameExtension(string).toLowerCase();
        return G.contains(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isNewOrModified(File file, String string, TemplateContext templateContext) throws IOException, TemplateStoreException {
        String string2;
        TemplateIdentifier templateIdentifier = new TemplateIdentifier(string, templateContext);
        long l = this.I.getTemplateStoredTime(templateIdentifier);
        if (l == -1L) {
            return true;
        }
        if (D) {
            Template template = this.I.getTemplate(templateIdentifier);
            try {
                long l2 = template.getDetails().getOriginalLastModified();
                boolean bl = file.lastModified() != l2;
                return bl;
            }
            finally {
                template.cleanup();
            }
        }
        TemplateAnalysis templateAnalysis = this.I.getTemplateAnalysis(templateIdentifier);
        if (templateAnalysis == null) {
            return true;
        }
        String string3 = this.getMD5Hash(file);
        return !string3.equals(string2 = templateAnalysis.getOriginalMD5());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getMD5Hash(File file) throws IOException {
        MessageDigest messageDigest = com.docmosis.util.B.B();
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            String string = com.docmosis.util.B.digest(messageDigest, fileInputStream);
            return string;
        }
        finally {
            FileUtilities.close(fileInputStream);
        }
    }

    private void store(String string, File file, TemplateContext templateContext) throws IOException, ConversionException, ConverterPoolException, TemplateStoreException, NoConvertersRunningException {
        TemplateIdentifier templateIdentifier = new TemplateIdentifier(string, templateContext);
        boolean bl = true;
        StoreHelper.storeTemplate(templateIdentifier, file, bl, false, this.I, this.E);
    }

    static {
        String string = DMProperties.getString(B, A);
        if (StringUtilities.isEmpty(string)) {
            C.error("No Template Extensions configured for the Drop Store Helper.  It will not load templates");
        } else {
            String[] stringArray = string.split(",");
            for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
                G.add(stringArray[i].toLowerCase());
            }
        }
    }
}

