/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.template.store;

import com.docmosis.template.Template;
import com.docmosis.template.TemplateAlreadyExistsException;
import com.docmosis.template.TemplateDetails;
import com.docmosis.template.TemplateNotFoundException;
import com.docmosis.template.TemplateStoreException;
import com.docmosis.template.analysis.TemplateAnalysis;
import com.docmosis.template.store.TemplateContext;
import com.docmosis.template.store.TemplateIdentifier;
import com.docmosis.template.store.TemplateStore;
import com.docmosis.util.FileUtilities;
import com.docmosis.util.properties.PropertiesProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class CompressingTemplateStore
implements TemplateStore {
    private TemplateStore R;

    public CompressingTemplateStore(TemplateStore templateStore) {
        this.R = templateStore;
    }

    @Override
    public Template getTemplate(TemplateIdentifier templateIdentifier) throws IOException, TemplateNotFoundException, TemplateStoreException {
        Template template = this.R.getTemplate(templateIdentifier);
        return new _A(template);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TemplateDetails storeTemplate(TemplateIdentifier templateIdentifier, InputStream inputStream, Long l, InputStream inputStream2, TemplateAnalysis templateAnalysis, InputStream inputStream3, boolean bl, boolean bl2, String string, String string2, boolean bl3, PropertiesProvider propertiesProvider) throws IOException, TemplateAlreadyExistsException, TemplateStoreException {
        File file = FileUtilities.createTempFile("dm_cts", "tmp");
        TemplateDetails templateDetails = null;
        GZIPOutputStream gZIPOutputStream = null;
        FileInputStream fileInputStream = null;
        try {
            gZIPOutputStream = new GZIPOutputStream(new FileOutputStream(file));
            FileUtilities.streamOut(inputStream2, (OutputStream)gZIPOutputStream, new byte[8192]);
            gZIPOutputStream.close();
            fileInputStream = new FileInputStream(file);
            templateDetails = this.R.storeTemplate(templateIdentifier, inputStream, l, fileInputStream, templateAnalysis, inputStream3, bl, bl2, string, string2, bl3, propertiesProvider);
        }
        catch (Throwable throwable) {
            FileUtilities.close(gZIPOutputStream);
            FileUtilities.close(fileInputStream);
            file.delete();
            throw throwable;
        }
        FileUtilities.close(gZIPOutputStream);
        FileUtilities.close(fileInputStream);
        file.delete();
        return templateDetails;
    }

    @Override
    public void deleteAll() throws TemplateStoreException {
        this.R.deleteAll();
    }

    @Override
    public void deleteTemplate(TemplateIdentifier templateIdentifier) throws TemplateStoreException {
        this.R.deleteTemplate(templateIdentifier);
    }

    @Override
    public void deleteTemplates(TemplateContext templateContext, boolean bl) throws TemplateStoreException {
        this.R.deleteTemplates(templateContext, bl);
    }

    @Override
    public TemplateDetails[] findByContext(TemplateContext templateContext, boolean bl) throws IOException, TemplateStoreException {
        return this.R.findByContext(templateContext, bl);
    }

    @Override
    public InputStream getOriginalTemplate(TemplateIdentifier templateIdentifier) throws IOException, TemplateNotFoundException {
        return this.R.getOriginalTemplate(templateIdentifier);
    }

    @Override
    public TemplateAnalysis getTemplateAnalysis(TemplateIdentifier templateIdentifier) throws IOException, TemplateNotFoundException, TemplateStoreException {
        return this.R.getTemplateAnalysis(templateIdentifier);
    }

    @Override
    public long getTemplateStoredTime(TemplateIdentifier templateIdentifier) throws TemplateStoreException {
        return this.R.getTemplateStoredTime(templateIdentifier);
    }

    private static class _A
    implements Template {
        private Template V;
        private InputStream U = null;

        public _A(Template template) {
            this.V = template;
        }

        @Override
        public InputStream getInputStream() {
            InputStream inputStream = this.V.getInputStream();
            if (inputStream != null) {
                try {
                    this.U = new GZIPInputStream(inputStream);
                }
                catch (IOException iOException) {
                    throw new RuntimeException("Unable to inflate IO stream", iOException);
                }
            }
            return this.U;
        }

        @Override
        public void cleanup() {
            FileUtilities.close(this.U);
            this.U = null;
            this.V.cleanup();
        }

        @Override
        public TemplateAnalysis getAnalysis() {
            return this.V.getAnalysis();
        }

        @Override
        public TemplateDetails getDetails() {
            return this.V.getDetails();
        }

        @Override
        public TemplateIdentifier getId() {
            return this.V.getId();
        }

        @Override
        public long getLength() {
            return this.V.getLength();
        }

        @Override
        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            this.V.readExternal(objectInput);
        }

        @Override
        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            this.V.writeExternal(objectOutput);
        }
    }
}

