/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.template.store;

import com.docmosis.template.Template;
import com.docmosis.template.TemplateAlreadyExistsException;
import com.docmosis.template.TemplateDetails;
import com.docmosis.template.TemplateNotFoundException;
import com.docmosis.template.TemplateStoreException;
import com.docmosis.template.analysis.TemplateAnalysis;
import com.docmosis.template.store.TemplateContext;
import com.docmosis.template.store.TemplateIdentifier;
import com.docmosis.template.store.TemplateStore;
import com.docmosis.util.DMProperties;
import com.docmosis.util.FileUtilities;
import com.docmosis.util.logging.LogManager;
import com.docmosis.util.logging.Logger;
import com.docmosis.util.properties.PropertiesProvider;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class CachingTemplateStore
implements TemplateStore {
    private static final Logger U = LogManager.getLogger(CachingTemplateStore.class);
    private static final boolean Z = DMProperties.getBoolean("docmosis.store.cache.warnIfTemplateTooLargeForCache", true);
    private static final boolean W = DMProperties.getBoolean("docmosis.store.cache.warnIfTemplatesAreFlushingFromCache", true);
    private final TemplateStoreCache S;
    private final Map a = Collections.synchronizedMap(new HashMap());
    private final Map _ = Collections.synchronizedMap(new HashMap());
    private final HashSet X = new HashSet();
    private TemplateStore Y;
    private final int V;
    private final int T;

    public CachingTemplateStore(TemplateStore templateStore, int n, int n2) {
        if (U.isDebugEnabled()) {
            U.debug("Template store cache enabled");
        }
        this.Y = templateStore;
        this.V = n;
        this.T = n2;
        this.S = new TemplateStoreCache(n);
    }

    public int getResidentSize() {
        return this.S.getResidentSize();
    }

    public int getItemCount() {
        return this.S.getItemCount();
    }

    List getCachedTemplateIds() {
        return this.S.getTemplateIds();
    }

    @Override
    public void deleteAll() throws TemplateStoreException {
        this.S.clear();
        this.a.clear();
        this._.clear();
        this.X.clear();
        this.Y.deleteAll();
    }

    @Override
    public void deleteTemplate(TemplateIdentifier templateIdentifier) throws TemplateStoreException {
        this.S.clear(templateIdentifier);
        this.a.remove(templateIdentifier);
        this._.remove(templateIdentifier);
        this.X.remove(templateIdentifier);
        this.Y.deleteTemplate(templateIdentifier);
    }

    @Override
    public void deleteTemplates(TemplateContext templateContext, boolean bl) throws TemplateStoreException {
        this.S.clear();
        this.a.clear();
        this._.clear();
        this.X.clear();
        this.Y.deleteTemplates(templateContext, bl);
    }

    @Override
    public TemplateDetails[] findByContext(TemplateContext templateContext, boolean bl) throws IOException, TemplateStoreException {
        return this.Y.findByContext(templateContext, bl);
    }

    @Override
    public InputStream getOriginalTemplate(TemplateIdentifier templateIdentifier) throws IOException, TemplateNotFoundException {
        return this.Y.getOriginalTemplate(templateIdentifier);
    }

    @Override
    public long getTemplateStoredTime(TemplateIdentifier templateIdentifier) throws TemplateStoreException {
        Template template = this.S.getTemplate(templateIdentifier);
        if (template != null) {
            return template.getDetails().getLastModified();
        }
        Long l = (Long)this._.get(templateIdentifier);
        if (l == null) {
            l = new Long(this.Y.getTemplateStoredTime(templateIdentifier));
            this._.put(templateIdentifier, l);
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Template getTemplate(TemplateIdentifier templateIdentifier) throws IOException, TemplateNotFoundException, TemplateStoreException {
        Template template;
        CachingTemplateStore cachingTemplateStore = this;
        synchronized (cachingTemplateStore) {
            template = this.S.getTemplate(templateIdentifier);
            if (template == null) {
                Template template2 = this.Y.getTemplate(templateIdentifier);
                if (template2 == null) {
                    return null;
                }
                long l = template2.getDetails().getSize();
                if (this.V > -1 && l > (long)this.V) {
                    if (Z && !this.X.contains(templateIdentifier)) {
                        this.X.add(templateIdentifier);
                        U.warn("template:" + templateIdentifier + " will not be cached since it " + "is larger than the configured max:" + this.V + " bytes");
                    }
                    return template2;
                }
                if (this.T != -1 && l > (long)this.T) {
                    if (Z && !this.X.contains(templateIdentifier)) {
                        this.X.add(templateIdentifier);
                        U.warn("template:" + templateIdentifier + " (" + l + " bytes) " + "will not be cached since it is larger than the cache itself:" + this.T + " bytes");
                    }
                    return template2;
                }
                try {
                    int n = 0;
                    while (this.T > -1 && l + (long)this.S.getResidentSize() > (long)this.T) {
                        if (this.S.isEmpty()) {
                            template2.cleanup();
                            throw new IllegalStateException("Cache is empty but is reporting thatthe current template can't fit in");
                        }
                        this.S.purgeSingle();
                        ++n;
                    }
                    if (n > 0 && W) {
                        U.warn("Template [" + templateIdentifier + "] caused " + n + " template(s) to be purged from the cache");
                    }
                    this.S.put(templateIdentifier, template2);
                    template2.cleanup();
                    this.a.remove(templateIdentifier);
                    this._.remove(templateIdentifier);
                    template = this.S.getTemplate(templateIdentifier);
                }
                finally {
                    if (template2 != null) {
                        template2.cleanup();
                    }
                }
            }
        }
        return template;
    }

    @Override
    public TemplateAnalysis getTemplateAnalysis(TemplateIdentifier templateIdentifier) throws IOException, TemplateNotFoundException, TemplateStoreException {
        TemplateAnalysis templateAnalysis = null;
        Template template = this.S.getTemplate(templateIdentifier);
        if (template != null) {
            return template.getAnalysis();
        }
        templateAnalysis = (TemplateAnalysis)this.a.get(templateIdentifier);
        if (templateAnalysis == null && (templateAnalysis = this.Y.getTemplateAnalysis(templateIdentifier)) != null) {
            this.a.put(templateIdentifier, templateAnalysis);
        }
        return templateAnalysis;
    }

    @Override
    public TemplateDetails storeTemplate(TemplateIdentifier templateIdentifier, InputStream inputStream, Long l, InputStream inputStream2, TemplateAnalysis templateAnalysis, InputStream inputStream3, boolean bl, boolean bl2, String string, String string2, boolean bl3, PropertiesProvider propertiesProvider) throws IOException, TemplateAlreadyExistsException, TemplateStoreException {
        this.S.clear(templateIdentifier);
        this.a.remove(templateIdentifier);
        this._.remove(templateIdentifier);
        this.X.remove(templateIdentifier);
        return this.Y.storeTemplate(templateIdentifier, inputStream, l, inputStream2, templateAnalysis, inputStream3, bl, bl2, string, string2, bl3, propertiesProvider);
    }

    static class TemplateStoreCache {
        private final Map B = Collections.synchronizedMap(new HashMap());
        private final LinkedList A = new LinkedList();
        private final int C;

        public TemplateStoreCache(int n) {
            this.C = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List getTemplateIds() {
            ArrayList<TemplateIdentifier> arrayList = new ArrayList<TemplateIdentifier>();
            Map map = this.B;
            synchronized (map) {
                Iterator iterator = this.B.keySet().iterator();
                while (iterator.hasNext()) {
                    arrayList.add((TemplateIdentifier)iterator.next());
                }
            }
            return arrayList;
        }

        public void clear(TemplateIdentifier templateIdentifier) {
            this.B.remove(templateIdentifier);
        }

        public void clear() {
            this.B.clear();
        }

        public void put(TemplateIdentifier templateIdentifier, Template template) throws IOException {
            CachedTemplate cachedTemplate = new CachedTemplate(template, this.C);
            this.B.put(templateIdentifier, cachedTemplate);
            if (U.isDebugEnabled()) {
                U.debug("Cached Template:" + templateIdentifier.getName() + " bytes:" + cachedTemplate.getTemplateSize() + " Cache size now: " + this.getResidentSize());
            }
        }

        public boolean isEmpty() {
            return this.B.size() == 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getResidentSize() {
            int n = 0;
            Map map = this.B;
            synchronized (map) {
                for (Map.Entry entry : this.B.entrySet()) {
                    CachedTemplate cachedTemplate = (CachedTemplate)entry.getValue();
                    n += cachedTemplate.getTemplateSize();
                }
            }
            return n;
        }

        public int getItemCount() {
            return this.B.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void purgeSingle() {
            Object var1_1 = null;
            LinkedList linkedList = this.A;
            synchronized (linkedList) {
                if (!this.A.isEmpty()) {
                    var1_1 = this.A.removeLast();
                }
            }
            if (var1_1 != null) {
                this.B.remove(var1_1);
            }
        }

        public Template getTemplate(TemplateIdentifier templateIdentifier) {
            CachedTemplate cachedTemplate = (CachedTemplate)this.B.get(templateIdentifier);
            this.setMostRecent(templateIdentifier);
            return cachedTemplate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setMostRecent(TemplateIdentifier templateIdentifier) {
            if (templateIdentifier == null) {
                return;
            }
            LinkedList linkedList = this.A;
            synchronized (linkedList) {
                int n = this.A.size();
                if (n == 0) {
                    this.A.add(templateIdentifier);
                } else if (!this.A.get(0).equals(templateIdentifier)) {
                    this.A.remove(templateIdentifier);
                    this.A.addFirst(templateIdentifier);
                }
            }
        }

        static class CachedTemplate
        implements Template {
            private final Template M;
            private final byte[] L;

            public CachedTemplate(Template template, int n) throws IOException {
                this.M = template;
                this.L = FileUtilities.readIntoMemory(template.getInputStream(), n, 51200);
            }

            public int getTemplateSize() {
                return this.L.length;
            }

            @Override
            public void cleanup() {
                this.M.cleanup();
            }

            @Override
            public TemplateAnalysis getAnalysis() {
                return this.M.getAnalysis();
            }

            @Override
            public TemplateDetails getDetails() {
                return this.M.getDetails();
            }

            @Override
            public TemplateIdentifier getId() {
                return this.M.getId();
            }

            @Override
            public InputStream getInputStream() {
                return new ByteArrayInputStream(this.L);
            }

            @Override
            public long getLength() {
                return this.M.getLength();
            }

            @Override
            public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
                throw new IllegalArgumentException("Cannot serialize " + this.getClass().getName());
            }

            @Override
            public void writeExternal(ObjectOutput objectOutput) throws IOException {
                throw new IllegalArgumentException("Cannot serialize " + this.getClass().getName());
            }
        }
    }
}

