/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.template.security.crash.footnoteimage;

import com.docmosis.template.security.crash.footnoteimage.RTFCommand;
import java.util.ArrayList;
import java.util.List;

public class RTFGroup {
    public final List<RTFCommand> commands = new ArrayList<RTFCommand>();
    public final List<RTFGroup> groups = new ArrayList<RTFGroup>();
    public final RTFGroup parent;

    public RTFGroup() {
        this(null);
    }

    public RTFGroup(RTFGroup rTFGroup) {
        this.parent = rTFGroup;
    }

    public void add(RTFGroup rTFGroup) {
        this.groups.add(rTFGroup);
    }

    public void add(RTFCommand rTFCommand) {
        this.commands.add(rTFCommand);
    }

    public boolean hasCommand(String string) {
        return this.getCommand(string) != null;
    }

    public RTFCommand getCommand(String string) {
        for (RTFCommand rTFCommand : this.commands) {
            if (!rTFCommand.name.equals(string)) continue;
            return rTFCommand;
        }
        return null;
    }

    public RTFGroup getGroup(String string) {
        if (this.hasCommand(string)) {
            return this;
        }
        for (RTFGroup rTFGroup : this.groups) {
            if (rTFGroup.hasCommand(string)) {
                return rTFGroup;
            }
            RTFGroup rTFGroup2 = rTFGroup.getGroup(string);
            if (rTFGroup2 == null) continue;
            return rTFGroup2;
        }
        return null;
    }

    public List<RTFGroup> getGroups(String string) {
        ArrayList<RTFGroup> arrayList = new ArrayList<RTFGroup>();
        for (RTFGroup rTFGroup : this.groups) {
            if (rTFGroup.hasCommand(string)) {
                arrayList.add(rTFGroup);
            }
            arrayList.addAll(rTFGroup.getGroups(string));
        }
        return arrayList;
    }

    public String toString() {
        String string = "";
        String string2 = "";
        for (RTFCommand rTFCommand : this.commands) {
            string2 = string2 + " " + rTFCommand;
        }
        string = string + (string2.length() > 100 ? string2.substring(0, 98) + "..." : string2);
        return string.trim();
    }
}

