/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.template.security.crash.footnoteimage;

import com.docmosis.template.security.crash.footnoteimage.RTFCommand;
import com.docmosis.template.security.crash.footnoteimage.RTFGroup;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayDeque;

public class ParseRTF {
    static final int TOLERANCE = 64;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RTFGroup parse(File file) throws IOException {
        int n = -1;
        RTFGroup rTFGroup = null;
        ArrayDeque<RTFGroup> arrayDeque = new ArrayDeque<RTFGroup>();
        FileReader fileReader = new FileReader(file);
        try {
            int n2 = fileReader.read();
            block9: while (n2 != -1) {
                char c = (char)n2;
                switch (c) {
                    case '{': {
                        RTFGroup rTFGroup2;
                        Object object;
                        if (arrayDeque.size() > 0) {
                            object = (RTFGroup)arrayDeque.peekFirst();
                            rTFGroup2 = new RTFGroup((RTFGroup)object);
                            ((RTFGroup)object).add(rTFGroup2);
                        } else {
                            rTFGroup = rTFGroup2 = new RTFGroup();
                        }
                        arrayDeque.addFirst(rTFGroup2);
                        n2 = fileReader.read();
                        continue block9;
                    }
                    case '}': {
                        arrayDeque.removeFirst();
                        n2 = fileReader.read();
                        continue block9;
                    }
                    case '\\': {
                        n2 = fileReader.read();
                        Object object = "";
                        while (n2 >= 97 && n2 <= 122 || n2 >= 65 && n2 <= 90 || n2 == 42) {
                            if (n2 == 42) {
                                n2 = fileReader.read();
                                if (n2 != 92) continue;
                                n2 = fileReader.read();
                            }
                            object = (String)object + (char)n2;
                            n2 = fileReader.read();
                        }
                        String string = "";
                        while (n2 >= 48 && n2 <= 57) {
                            string = string + (char)n2;
                            n2 = fileReader.read();
                        }
                        if (string.isEmpty() && !((String)object).isEmpty()) {
                            ((RTFGroup)arrayDeque.peekFirst()).add(new RTFCommand((String)object));
                            continue block9;
                        }
                        if (((String)object).isEmpty()) continue block9;
                        ((RTFGroup)arrayDeque.peekFirst()).add(new RTFCommand((String)object, ParseRTF.extractLong(string)));
                        continue block9;
                    }
                    case '\n': 
                    case '\r': {
                        n2 = fileReader.read();
                        continue block9;
                    }
                }
                n2 = fileReader.read();
            }
        }
        finally {
            fileReader.close();
        }
        return rTFGroup;
    }

    private static long extractLong(String string) {
        long l = 0L;
        try {
            string = string.trim().toLowerCase();
            if (string.endsWith("px") || string.endsWith("pt")) {
                string = string.substring(2);
            }
            l = (long)Double.parseDouble(string);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return l;
    }

    public static boolean containsErrorCondition(File file) throws IOException {
        return ParseRTF.containsErrorCondition(file, 64L);
    }

    public static boolean containsErrorCondition(File file, long l) throws IOException {
        RTFGroup rTFGroup = ParseRTF.parse(file);
        RTFCommand rTFCommand = rTFGroup.getCommand("paperw");
        RTFCommand rTFCommand2 = rTFGroup.getCommand("margl");
        RTFCommand rTFCommand3 = rTFGroup.getCommand("margr");
        RTFCommand rTFCommand4 = rTFGroup.getCommand("paperh");
        RTFCommand rTFCommand5 = rTFGroup.getCommand("margt");
        RTFCommand rTFCommand6 = rTFGroup.getCommand("margb");
        if (rTFCommand == null || rTFCommand2 == null || rTFCommand3 == null || rTFCommand4 == null || rTFCommand5 == null || rTFCommand6 == null) {
            return false;
        }
        long l2 = rTFCommand.value - rTFCommand2.value - rTFCommand3.value;
        long l3 = rTFCommand4.value - rTFCommand5.value - rTFCommand6.value;
        for (RTFGroup rTFGroup2 : rTFGroup.getGroups("footnote")) {
            for (RTFGroup rTFGroup3 : rTFGroup2.getGroups("shppict")) {
                for (RTFGroup rTFGroup4 : rTFGroup3.getGroups("pict")) {
                    RTFCommand rTFCommand7 = rTFGroup4.getCommand("picwgoal");
                    RTFCommand rTFCommand8 = rTFGroup4.getCommand("pichgoal");
                    if (rTFCommand7 == null || rTFCommand8 == null || l2 - rTFCommand7.value >= l && l3 - rTFCommand8.value >= l) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static void main(String[] stringArray) throws IOException {
        for (String string : stringArray) {
            System.out.println(ParseRTF.containsErrorCondition(new File(string)) ? string + " has error" : string + " is ok");
        }
    }
}

