/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.template.security.crash.footnoteimage;

import com.docmosis.template.security.crash.footnoteimage.DocumentProperties;
import com.docmosis.util.DMProperties;
import com.docmosis.util.StringUtilities;
import com.docmosis.util.logging.LogManager;
import com.docmosis.util.logging.Logger;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathException;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ParseDOCX {
    private static final Logger A = LogManager.getLogger(ParseDOCX.class);
    static final int emusPerInch = 914400;
    static final int emusPerCm = 360000;
    static final int pointsPerInch = 72;
    static final long pt20thsToEMUs = 635L;
    static final long TOLERANCE = 37090L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DocumentProperties parse(File file) throws IOException, ParserConfigurationException, SAXException, XPathExpressionException {
        DocumentProperties documentProperties = new DocumentProperties();
        ZipFile zipFile = new ZipFile(file);
        try {
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                String string = zipEntry.getName();
                if (string.equals("word/document.xml")) {
                    documentProperties.pageSize = ParseDOCX.parseDocument(zipFile.getInputStream(zipEntry));
                    continue;
                }
                if (!string.equals("word/footnotes.xml")) continue;
                documentProperties.images = ParseDOCX.parseFootnotes(zipFile.getInputStream(zipEntry));
            }
        }
        finally {
            zipFile.close();
        }
        return documentProperties;
    }

    public static boolean containsErrorCondition(File file) throws IOException {
        try {
            return ParseDOCX.containsErrorCondition(file, 37090L);
        }
        catch (XPathException xPathException) {
            throw new IOException(xPathException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IOException(parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new IOException(sAXException);
        }
    }

    public static boolean containsErrorCondition(File file, long l) throws IOException, ParserConfigurationException, SAXException, XPathExpressionException {
        DocumentProperties documentProperties = ParseDOCX.parse(file);
        if (documentProperties.images != null) {
            for (long[] lArray : documentProperties.images) {
                if (documentProperties.pageSize[0] - lArray[0] > l && documentProperties.pageSize[1] - lArray[1] > l) continue;
                return true;
            }
        }
        return false;
    }

    public static long[] parseDocument(InputStream inputStream) throws IOException, SAXException, ParserConfigurationException {
        DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        if (DMProperties.getBoolean("docmosis.data.xml.blockExternalEntities", true)) {
            documentBuilder.setEntityResolver(new _A());
        }
        Document document = documentBuilder.parse(inputStream);
        Node node = document.getElementsByTagName("w:pgSz").item(0);
        Node node2 = document.getElementsByTagName("w:pgMar").item(0);
        return new long[]{(ParseDOCX.extractLong(node.getAttributes().getNamedItem("w:w").getNodeValue()) - ParseDOCX.extractLong(node2.getAttributes().getNamedItem("w:left").getNodeValue()) - ParseDOCX.extractLong(node2.getAttributes().getNamedItem("w:right").getNodeValue())) * 635L, (ParseDOCX.extractLong(node.getAttributes().getNamedItem("w:h").getNodeValue()) - ParseDOCX.extractLong(node2.getAttributes().getNamedItem("w:top").getNodeValue()) - ParseDOCX.extractLong(node2.getAttributes().getNamedItem("w:bottom").getNodeValue())) * 635L};
    }

    private static long extractLong(String string) {
        long l = 0L;
        try {
            string = string.trim().toLowerCase();
            if (string.endsWith("px") || string.endsWith("pt")) {
                string = string.substring(0, string.length() - 2);
            }
            l = (long)Double.parseDouble(string);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return l;
    }

    private static double extractDouble(String string) {
        double d = 0.0;
        try {
            string = string.trim().toLowerCase();
            if (string.startsWith("width:")) {
                string = string.substring(6, string.length());
            }
            if (string.startsWith("height:")) {
                string = string.substring(7, string.length());
            }
            if (string.endsWith("px") || string.endsWith("pt")) {
                string = string.substring(0, string.length() - 2);
            }
            d = Double.parseDouble(string);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return d;
    }

    public static List<long[]> parseFootnotes(InputStream inputStream) throws IOException, SAXException, ParserConfigurationException, XPathExpressionException {
        DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        if (DMProperties.getBoolean("docmosis.data.xml.blockExternalEntities", true)) {
            documentBuilder.setEntityResolver(new _A());
        }
        final Document document = documentBuilder.parse(inputStream);
        XPath xPath = XPathFactory.newInstance().newXPath();
        xPath.setNamespaceContext(new NamespaceContext(){

            @Override
            public String getNamespaceURI(String string) {
                return document.lookupNamespaceURI(string);
            }

            @Override
            public String getPrefix(String string) {
                return document.lookupPrefix(string);
            }

            @Override
            public Iterator<String> getPrefixes(String string) {
                return null;
            }
        });
        String string = "/footnotes/footnote//drawing/inline/extent";
        NodeList nodeList = (NodeList)xPath.compile(string).evaluate(document, XPathConstants.NODESET);
        ArrayList<long[]> arrayList = new ArrayList<long[]>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            arrayList.add(new long[]{ParseDOCX.extractLong(nodeList.item(i).getAttributes().getNamedItem("cx").getNodeValue()), ParseDOCX.extractLong(nodeList.item(i).getAttributes().getNamedItem("cy").getNodeValue())});
        }
        String string2 = "/footnotes/footnote//pict/shape";
        NodeList nodeList2 = (NodeList)xPath.compile(string2).evaluate(document, XPathConstants.NODESET);
        for (int i = 0; i < nodeList2.getLength(); ++i) {
            String string3 = nodeList2.item(i).getAttributes().getNamedItem("style").getNodeValue();
            if (!StringUtilities.hasValue(string3)) continue;
            String[] stringArray = ParseDOCX.extractWidthHeight(string3);
            arrayList.add(new long[]{(long)(ParseDOCX.extractDouble(stringArray[0]) * 20.0 * 635.0), (long)(ParseDOCX.extractDouble(stringArray[1]) * 20.0 * 635.0)});
        }
        return arrayList;
    }

    private static String[] extractWidthHeight(String string) {
        String[] stringArray = string.split(";");
        String string2 = "";
        String string3 = "";
        for (String string4 : stringArray) {
            if (string4.startsWith("width:")) {
                string2 = string4;
            }
            if (!string4.startsWith("height:")) continue;
            string3 = string4;
        }
        return new String[]{string2, string3};
    }

    public static void main(String[] stringArray) throws IOException, ParserConfigurationException, SAXException, XPathExpressionException {
        for (String string : stringArray) {
            System.out.println(ParseDOCX.containsErrorCondition(new File(string)) ? string + " has error" : string + " is ok");
        }
    }

    public static long pt20thsToEMUs(long l) {
        return l * 635L;
    }

    private static class _A
    implements EntityResolver {
        private _A() {
        }

        @Override
        public InputSource resolveEntity(String string, String string2) {
            A.warn("XML external entity resolution ignored:[" + string + "],[" + string2 + "]");
            InputSource inputSource = new InputSource(new ByteArrayInputStream("".getBytes()));
            return inputSource;
        }
    }
}

