/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.template.security.crash.footnoteimage;

import com.docmosis.template.security.crash.TemplateDefenceCheck;
import com.docmosis.template.security.crash.footnoteimage.ParseDOCX;
import com.docmosis.template.security.crash.footnoteimage.ParseRTF;
import com.docmosis.util.FileUtilities;
import java.io.File;
import java.io.IOException;

public class FootnotesImageCrashCheck
implements TemplateDefenceCheck {
    private static final String C = "Failed template with known issues";

    @Override
    public void check(File file) throws IOException {
        try {
            if (FileUtilities.isDocxFormat(file) && ParseDOCX.containsErrorCondition(file)) {
                throw new IOException(C);
            }
            if (FileUtilities.isRtfFormat(file) && ParseRTF.containsErrorCondition(file)) {
                throw new IOException(C);
            }
        }
        catch (RuntimeException runtimeException) {
            log.warn("TemplateDefence failed to check template with FootnotesImageCrashCheck due to RuntimeException");
        }
    }
}

