/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.template.population.render;

import com.docmosis.util.StringUtilities;
import com.docmosis.util.locale.LocaleUtils;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;

public class NumberRendererUtil {
    public static String format(String string, String string2) throws LocaleUtils.UnknownLocaleException, BadValueException {
        return NumberRendererUtil.format(string, string2, null);
    }

    public static String format(String string, String string2, String string3) throws LocaleUtils.UnknownLocaleException, BadValueException {
        return NumberRendererUtil.format(string, string2, string3, true);
    }

    public static String format(String string, String string2, String string3, boolean bl) throws LocaleUtils.UnknownLocaleException, BadValueException {
        Locale locale = LocaleUtils.localeStringToLocale(string3);
        return NumberRendererUtil.format(string, string2, string3, bl, locale != null);
    }

    public static String format(String string, String string2, String string3, boolean bl, boolean bl2) throws LocaleUtils.UnknownLocaleException, BadValueException {
        if (StringUtilities.isEmpty(string) || StringUtilities.isEmpty(string2)) {
            return string;
        }
        Locale locale = LocaleUtils.localeStringToLocale(string3);
        Number number = new ParsedNumber(string, bl ? locale : (Locale)null).B;
        if (number == null) {
            throw new BadValueException(string);
        }
        return NumberRendererUtil.format(number, string2, locale, bl2);
    }

    public static String format(Number number, String string, String string2) throws LocaleUtils.UnknownLocaleException, BadValueException {
        return NumberRendererUtil.format(number, string, LocaleUtils.localeStringToLocale(string2), true);
    }

    public static String format(Number number, String string, Locale locale, boolean bl) throws LocaleUtils.UnknownLocaleException, BadValueException {
        String string2;
        try {
            DecimalFormat decimalFormat = new DecimalFormat();
            if (locale != null) {
                decimalFormat.setDecimalFormatSymbols(new DecimalFormatSymbols(locale));
            }
            try {
                if (bl) {
                    decimalFormat.applyLocalizedPattern(string);
                } else {
                    decimalFormat.applyPattern(string);
                }
            }
            catch (RuntimeException runtimeException) {
                throw new BadValueException((bl ? "Localized format" : "Format") + " [" + string + "] cannot be applied to " + (locale == null ? "the default locale" : "locale [" + locale.toString() + "]"));
            }
            string2 = decimalFormat.format(number);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new BadValueException("Cannot format value \"" + number + "\" to format: \"" + string + "\".");
        }
        return string2;
    }

    public static class BadValueException
    extends Exception {
        public BadValueException(String string) {
            super("Cannot format as a number:\"" + string + "\"");
        }
    }

    public static class ParsedNumber {
        private final NumberFormat A;
        private final Number B;

        public ParsedNumber(String string, String string2) throws LocaleUtils.UnknownLocaleException {
            this(string, LocaleUtils.localeStringToLocale(string2));
        }

        public ParsedNumber(String string, Locale locale) {
            ParsedNumber parsedNumber = this.tryCurrency(string, locale);
            if (parsedNumber == null) {
                parsedNumber = this.tryNumber(string, locale);
            }
            if (parsedNumber != null) {
                this.A = parsedNumber.A;
                this.B = parsedNumber.B;
            } else {
                this.A = null;
                this.B = null;
            }
        }

        public Number getNumber() {
            return this.B;
        }

        private ParsedNumber(NumberFormat numberFormat, Number number) {
            this.A = numberFormat;
            this.B = number;
        }

        private ParsedNumber tryCurrency(String string, Locale locale) {
            if (locale != null) {
                try {
                    NumberFormat numberFormat = NumberFormat.getCurrencyInstance(locale);
                    this.setParseBigDecimal(numberFormat);
                    Number number = numberFormat.parse(string);
                    return new ParsedNumber(NumberFormat.getCurrencyInstance(), number);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            try {
                NumberFormat numberFormat = NumberFormat.getCurrencyInstance();
                this.setParseBigDecimal(numberFormat);
                Number number = numberFormat.parse(string);
                return new ParsedNumber(NumberFormat.getCurrencyInstance(), number);
            }
            catch (ParseException parseException) {
                return null;
            }
        }

        private ParsedNumber tryNumber(String string, Locale locale) {
            if (locale != null) {
                try {
                    NumberFormat numberFormat = NumberFormat.getInstance(locale);
                    this.setParseBigDecimal(numberFormat);
                    Number number = numberFormat.parse(string);
                    return new ParsedNumber(NumberFormat.getInstance(), number);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            try {
                NumberFormat numberFormat = NumberFormat.getInstance();
                this.setParseBigDecimal(numberFormat);
                Number number = numberFormat.parse(string);
                return new ParsedNumber(NumberFormat.getInstance(), number);
            }
            catch (ParseException parseException) {
                return null;
            }
        }

        private void setParseBigDecimal(NumberFormat numberFormat) {
            if (numberFormat instanceof DecimalFormat) {
                ((DecimalFormat)numberFormat).setParseBigDecimal(true);
            }
        }

        public String toString() {
            return this.A.format(this.B);
        }

        public String formatWith(NumberFormat numberFormat) {
            return numberFormat.format(this.B);
        }
    }
}

