/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.template.population.render;

import com.docmosis.template.population.render.FieldDetails;
import com.docmosis.template.population.render.FieldRenderer;
import com.docmosis.template.population.render.FieldRendererException;
import com.docmosis.template.population.render.NumberRendererUtil;
import com.docmosis.template.population.render.RenderedField;
import com.docmosis.util.locale.LocaleUtils;
import java.util.Locale;

public class NumberRenderer
implements FieldRenderer {
    @Override
    public RenderedField render(FieldDetails fieldDetails, RenderedField renderedField) throws FieldRendererException {
        block15: {
            if (!(fieldDetails.getValueObject() != null && fieldDetails.getValueClass() != null || fieldDetails.getFieldValue() != null && !"".equals(fieldDetails.getFieldValue().trim()))) {
                return renderedField;
            }
            String[] stringArray = fieldDetails.getRendererParams();
            String string = null;
            String string2 = null;
            boolean bl = true;
            if (stringArray != null) {
                if (stringArray.length > 3) {
                    throw new FieldRendererException("Renderer:" + fieldDetails.getRendererName() + " can have at most three parameters");
                }
                if (stringArray[0] == null) {
                    throw new FieldRendererException("Renderer:" + fieldDetails.getRendererName() + " unexpected null first parameter");
                }
                if (stringArray.length >= 1) {
                    string = stringArray[0];
                }
                if (stringArray.length >= 2) {
                    string2 = stringArray[1];
                }
                if (stringArray.length > 2) {
                    bl = Boolean.valueOf(stringArray[2]);
                }
            }
            try {
                Number number;
                if (fieldDetails.getValueObject() instanceof Number) {
                    number = (Number)fieldDetails.getValueObject();
                } else {
                    number = new NumberRendererUtil.ParsedNumber(fieldDetails.getFieldValue(), bl ? string2 : null).getNumber();
                    if (number == null) {
                        throw new FieldRendererException("Renderer:" + fieldDetails.getRendererName() + " Can't parse value as a number: \"" + fieldDetails.getFieldValue() + "\".");
                    }
                }
                if (stringArray == null) {
                    renderedField.setValue(String.valueOf(number));
                    break block15;
                }
                try {
                    Locale locale = LocaleUtils.localeStringToLocale(string2);
                    String string3 = NumberRendererUtil.format(number, string, locale, true);
                    renderedField.setValue(string3);
                }
                catch (NumberRendererUtil.BadValueException badValueException) {
                    throw new FieldRendererException("Renderer:" + fieldDetails.getRendererName() + " unknown format: \"" + stringArray[0] + "\".");
                }
            }
            catch (LocaleUtils.UnknownLocaleException unknownLocaleException) {
                throw new FieldRendererException("Renderer:" + fieldDetails.getRendererName() + " \"" + string2 + "\" is not a country or language name/code");
            }
        }
        return renderedField;
    }
}

