/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.template.population.render;

import com.docmosis.util.DMProperties;
import com.docmosis.util.DateUtilities;
import com.docmosis.util.StringUtilities;
import com.docmosis.util.locale.LocaleUtils;
import com.docmosis.util.logging.LogManager;
import com.docmosis.util.logging.Logger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.TimeZone;

public class DateRendererUtil {
    private static final Logger D = LogManager.getLogger(DateRendererUtil.class);
    private static final _B E = new _B();
    private static final String A = DMProperties.getString("docmosis.renderer.defaultDateFormat", "dd MMM yyyy");
    private final String[] C = DMProperties.getStringArray(new String[]{"docmosis.renderer.extendedDateInputFormats", "docmosis.renderer.defaultDateInputFormats"}, ";");
    private static final boolean G = DMProperties.getBoolean("docmosis.renderer.dateInputFormatStrict", true);
    private static final boolean F = DMProperties.getBoolean("docmosis.renderer.dateInputFormatLogDiagnostics", false);
    private static final boolean H = DMProperties.getBoolean("docmosis.renderer.dateDisableTimezoneDataPersistence", false);
    private final boolean B = DMProperties.getBoolean("docmosis.renderer.dateInputFormatStrict.acceptNonStrict", true);

    public String format(String string, String string2, String string3) throws CannotParseDateException, InvalidDateFormatException {
        return this.format(string, string2, string3, null, null);
    }

    public String format(String string, String string2, String string3, String string4, String string5) throws CannotParseDateException, InvalidDateFormatException {
        return this.format(string, string2, string3, string4, string5, false, false);
    }

    public String format(String string, String string2, String string3, String string4, String string5, boolean bl, boolean bl2) throws CannotParseDateException, InvalidDateFormatException {
        String[] stringArray;
        if (string3 == null) {
            stringArray = this.C;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = string3;
        }
        String[] stringArray3 = stringArray;
        _A _A2 = this.parseDate(string, stringArray3, G, string5, bl2);
        if (_A2 == null && G && this.B) {
            _A2 = this.parseDate(string, stringArray3, false, string5, bl2);
        }
        if (_A2 == null) {
            throw new CannotParseDateException("value=\"" + string + "\" formats applied=[" + StringUtilities.arrayToString(stringArray3, ",", "\"") + "]");
        }
        TimeZone timeZone = _A2.B;
        if (H) {
            timeZone = null;
        }
        return this.format(_A2.A, string2, timeZone, string4, bl);
    }

    public String add(String string, int n, DateUtilities.Unit unit, String string2, String string3) throws CannotParseDateException, InvalidDateFormatException {
        String[] stringArray;
        if (string3 == null) {
            stringArray = this.C;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = string3;
        }
        String[] stringArray3 = stringArray;
        _A _A2 = this.parseDate(string, stringArray3, G);
        if (_A2 == null && G && this.B) {
            _A2 = this.parseDate(string, stringArray3, false);
        }
        if (_A2 == null) {
            throw new CannotParseDateException("value=\"" + string + "\" formats applied=[" + StringUtilities.arrayToString(stringArray3, ",", "\"") + "]");
        }
        _A2.A(n, unit);
        TimeZone timeZone = _A2.B;
        if (H) {
            timeZone = null;
        }
        return this.format(_A2.A, string2, timeZone, null, false);
    }

    public double diff(String string, String string2, DateUtilities.Unit unit, String string3) throws CannotParseDateException, InvalidDateFormatException {
        String[] stringArray;
        if (string3 == null) {
            stringArray = this.C;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = string3;
        }
        String[] stringArray3 = stringArray;
        _A _A2 = this.parseDate(string, stringArray3, G);
        if (_A2 == null && G && this.B) {
            _A2 = this.parseDate(string, stringArray3, false);
        }
        if (_A2 == null) {
            throw new CannotParseDateException("value=\"" + string + "\" formats applied=[" + StringUtilities.arrayToString(stringArray3, ",", "\"") + "]");
        }
        _A _A3 = this.parseDate(string2, stringArray3, G);
        if (_A3 == null && G && this.B) {
            _A3 = this.parseDate(string2, stringArray3, false);
        }
        if (_A3 == null) {
            throw new CannotParseDateException("value=\"" + string2 + "\" formats applied=[" + StringUtilities.arrayToString(stringArray3, ",", "\"") + "]");
        }
        double d = unit.diff(_A2.A, _A3.A);
        return d;
    }

    public _A parseDate(String string, String[] stringArray, boolean bl) throws InvalidDateFormatException {
        return this.parseDate(string, stringArray, bl, null, false);
    }

    public _A parseDate(String string, String[] stringArray, boolean bl, String string2, boolean bl2) throws InvalidDateFormatException {
        _A _A2 = null;
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                SimpleDateFormat simpleDateFormat = this.getFormatter(stringArray[i], string2, bl2);
                try {
                    Date date = simpleDateFormat.parse(string);
                    if (bl) {
                        String string3 = simpleDateFormat.format(date);
                        if (string.equalsIgnoreCase(string3)) {
                            _A2 = new _A(date, simpleDateFormat.getTimeZone());
                            break;
                        }
                        if (!F) continue;
                        D.info("Strict match failed using [" + stringArray[i] + "]. " + "[" + string + "] != [" + string3 + "]");
                        continue;
                    }
                    _A2 = new _A(date, simpleDateFormat.getTimeZone());
                    break;
                }
                catch (ParseException parseException) {
                    if (!F) continue;
                    D.info("Format [" + stringArray[i] + "] could not parse [" + string + "]: " + parseException.getMessage());
                }
            }
        }
        return _A2;
    }

    public String format(Date date, String string) throws InvalidDateFormatException {
        return this.format(date, string, null, null, false);
    }

    public String format(Date date, String string, TimeZone timeZone) throws InvalidDateFormatException {
        return this.format(date, string, timeZone, null, false);
    }

    public String format(Date date, String string, TimeZone timeZone, String string2, boolean bl) throws InvalidDateFormatException {
        SimpleDateFormat simpleDateFormat;
        SimpleDateFormat simpleDateFormat2 = simpleDateFormat = string == null ? this.getFormatter(A, string2, bl) : this.getFormatter(string, string2, bl);
        if (timeZone != null) {
            simpleDateFormat.setTimeZone(timeZone);
        }
        return simpleDateFormat.format(date);
    }

    private SimpleDateFormat getFormatter(String string, String string2, boolean bl) throws InvalidDateFormatException {
        DateFormatMapKey dateFormatMapKey = new DateFormatMapKey(string, string2, bl);
        SimpleDateFormat simpleDateFormat = E.A(dateFormatMapKey);
        if (simpleDateFormat == null) {
            try {
                simpleDateFormat = string2 == null ? new SimpleDateFormat("") : new SimpleDateFormat("", LocaleUtils.localeStringToLocale(string2));
                if (bl) {
                    simpleDateFormat.applyLocalizedPattern(string);
                } else {
                    simpleDateFormat.applyPattern(string);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new InvalidDateFormatException("The date format \"" + string + "\" " + "can not be applied " + (string2 == null ? "" : "for locale " + string2 + " ") + "as a " + (bl ? "localized " : "") + "format pattern");
            }
            catch (LocaleUtils.UnknownLocaleException unknownLocaleException) {
                throw new InvalidDateFormatException("The given locale \"" + string2 + "\" is invalid", unknownLocaleException);
            }
            catch (RuntimeException runtimeException) {
                throw new InvalidDateFormatException("An error occurred formatting \"" + string + "\" is invalid:" + runtimeException.getMessage(), runtimeException);
            }
            E.A(dateFormatMapKey, simpleDateFormat);
        }
        return simpleDateFormat;
    }

    public static class InvalidDateFormatException
    extends Exception {
        public InvalidDateFormatException(String string) {
            super(string);
        }

        public InvalidDateFormatException(String string, Throwable throwable) {
            super(string, throwable);
        }
    }

    public static class CannotParseDateException
    extends Exception {
        public CannotParseDateException(String string) {
            super(string);
        }

        @Override
        public String getMessage() {
            return "Cannot parse date:" + super.getMessage();
        }
    }

    private static class _A {
        private final Date A;
        private final TimeZone B;

        public _A(Date date, TimeZone timeZone) {
            this.A = date;
            this.B = timeZone;
        }

        public void A(int n, DateUtilities.Unit unit) {
            this.A.setTime(unit.add(n, this.A.getTime(), this.B));
        }
    }

    public static class DateFormatMapKey {
        private final String C;
        private final String B;
        private final Boolean A;

        public DateFormatMapKey(String string, String string2, boolean bl) {
            this.C = string;
            this.B = string2;
            this.A = bl;
        }

        public String getDateFormat() {
            return this.C;
        }

        public String getLocale() {
            return this.B;
        }

        public boolean getApplyLocalizedPattern() {
            return this.A;
        }

        public int hashCode() {
            int n = 31;
            int n2 = 1;
            n2 = 31 * n2 + (this.A == null ? 0 : this.A.hashCode());
            n2 = 31 * n2 + (this.C == null ? 0 : this.C.hashCode());
            n2 = 31 * n2 + (this.B == null ? 0 : this.B.hashCode());
            return n2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            DateFormatMapKey dateFormatMapKey = (DateFormatMapKey)object;
            if (this.A == null ? dateFormatMapKey.A != null : !this.A.equals(dateFormatMapKey.A)) {
                return false;
            }
            if (this.C == null ? dateFormatMapKey.C != null : !this.C.equals(dateFormatMapKey.C)) {
                return false;
            }
            return !(this.B == null ? dateFormatMapKey.B != null : !this.B.equals(dateFormatMapKey.B));
        }
    }

    private static class _B {
        private static final ThreadLocal A = new ThreadLocal(){

            protected Object initialValue() {
                return new HashMap();
            }
        };

        private _B() {
        }

        public SimpleDateFormat A(DateFormatMapKey dateFormatMapKey) {
            return (SimpleDateFormat)((HashMap)A.get()).get(dateFormatMapKey);
        }

        public void A(DateFormatMapKey dateFormatMapKey, SimpleDateFormat simpleDateFormat) {
            ((HashMap)A.get()).put(dateFormatMapKey, simpleDateFormat);
        }
    }
}

