/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.template.population.render;

import com.docmosis.template.population.render.DateRendererUtil;
import com.docmosis.template.population.render.FieldDetails;
import com.docmosis.template.population.render.FieldRenderer;
import com.docmosis.template.population.render.FieldRendererException;
import com.docmosis.template.population.render.RenderedField;
import java.util.Date;
import java.util.TimeZone;

public class DateRenderer
implements FieldRenderer {
    @Override
    public RenderedField render(FieldDetails fieldDetails, RenderedField renderedField) throws FieldRendererException {
        if (!(fieldDetails.getValueObject() != null && fieldDetails.getValueClass() != null || fieldDetails.getFieldValue() != null && !"".equals(fieldDetails.getFieldValue().trim()))) {
            return renderedField;
        }
        String[] stringArray = fieldDetails.getRendererParams();
        String string = null;
        String string2 = null;
        if (stringArray != null && stringArray.length != 0) {
            if (stringArray.length < 3) {
                string = stringArray[0];
                if (stringArray.length > 1) {
                    string2 = stringArray[1];
                }
            } else {
                throw new FieldRendererException("Renderer:" + fieldDetails.getRendererName() + " can have at most two parameters");
            }
        }
        String string3 = null;
        if (fieldDetails.getValueObject() instanceof Date) {
            Date date = (Date)fieldDetails.getValueObject();
            try {
                TimeZone timeZone = null;
                string3 = new DateRendererUtil().format(date, string, timeZone);
            }
            catch (DateRendererUtil.InvalidDateFormatException invalidDateFormatException) {
                throw new FieldRendererException(invalidDateFormatException.getMessage());
            }
        }
        try {
            string3 = new DateRendererUtil().format(fieldDetails.getFieldValue(), string, string2);
        }
        catch (DateRendererUtil.CannotParseDateException cannotParseDateException) {
            throw new FieldRendererException("Can't parse field into a date (field=\"" + fieldDetails.getFieldName() + "\" " + cannotParseDateException.getMessage() + ")");
        }
        catch (DateRendererUtil.InvalidDateFormatException invalidDateFormatException) {
            throw new FieldRendererException(invalidDateFormatException.getMessage());
        }
        renderedField.setValue(string3);
        return renderedField;
    }
}

