/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.template.population.render;

import com.docmosis.template.population.render.FieldDetails;
import com.docmosis.template.population.render.FieldRenderer;
import com.docmosis.template.population.render.FieldRendererException;
import com.docmosis.template.population.render.RenderedField;
import com.docmosis.util.DMProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class BooleanRenderer
implements FieldRenderer {
    private static final HashMap FORMATS = new HashMap();
    private static final String VALIDFORMATS;
    private final String[] TRUE_VALUE_PROPERTIES = DMProperties.getStringArray(new String[]{"docmosis.renderer.extendedBooleanTrueValues", "docmosis.renderer.defaultBooleanTrueValues"}, ";");
    private final Set TRUE_VALUE_PROPERTIES_LOOKUP = new HashSet();

    public BooleanRenderer() {
        if (this.TRUE_VALUE_PROPERTIES != null) {
            for (int i = 0; i < this.TRUE_VALUE_PROPERTIES.length; ++i) {
                this.TRUE_VALUE_PROPERTIES_LOOKUP.add(this.TRUE_VALUE_PROPERTIES[i].toLowerCase());
            }
        }
    }

    @Override
    public RenderedField render(FieldDetails fieldDetails, RenderedField renderedField) throws FieldRendererException {
        Boolean bl = this.valueLooksTrue(fieldDetails.getFieldValue());
        String[] stringArray = fieldDetails.getRendererParams();
        if (stringArray == null) {
            renderedField.setValue(String.valueOf(bl));
        } else {
            if (stringArray.length != 1) {
                throw new FieldRendererException("Renderer:" + fieldDetails.getRendererName() + " can have at most one parameter");
            }
            if (stringArray[0] == null) {
                throw new FieldRendererException("Renderer:" + fieldDetails.getRendererName() + " unexpected null parameter");
            }
            Formatter formatter = (Formatter)FORMATS.get(stringArray[0].toLowerCase());
            if (formatter == null) {
                throw new FieldRendererException("Renderer:" + fieldDetails.getRendererName() + " unknown format: \"" + stringArray[0] + "\".  Valid formats are: " + VALIDFORMATS);
            }
            renderedField.setValue(formatter.format(bl));
        }
        return renderedField;
    }

    private Boolean valueLooksTrue(String string) {
        string = string == null ? null : string.toLowerCase();
        Boolean bl = Boolean.valueOf(string) != false || this.TRUE_VALUE_PROPERTIES_LOOKUP.contains(string) ? Boolean.TRUE : Boolean.FALSE;
        return bl;
    }

    static {
        FORMATS.put("yn", new Formatter("Y", "N"));
        FORMATS.put("ynlc", new Formatter("y", "n"));
        FORMATS.put("yesnouc", new Formatter("YES", "NO"));
        FORMATS.put("yesnolc", new Formatter("yes", "no"));
        FORMATS.put("yesno", new Formatter("Yes", "No"));
        FORMATS.put("wingdings1", new Formatter(String.valueOf('\u00fc'), String.valueOf('\u00fb')));
        FORMATS.put("wingdings2", new Formatter(String.valueOf('\u00fe'), String.valueOf('\u00a8')));
        FORMATS.put("dingbats1", new Formatter(String.valueOf('\u2713'), String.valueOf('\u2717')));
        FORMATS.put("dingbats2", new Formatter(String.valueOf('\u2714'), String.valueOf('\u2718')));
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = FORMATS.keySet().iterator();
        while (iterator.hasNext()) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append('\"').append(iterator.next()).append('\"');
        }
        VALIDFORMATS = stringBuffer.toString();
    }

    private static class Formatter {
        private String trueVal;
        private String falseVal;

        public Formatter(String string, String string2) {
            this.trueVal = string;
            this.falseVal = string2;
        }

        public String format(Boolean bl) {
            if (Boolean.TRUE.equals(bl)) {
                return this.trueVal;
            }
            return this.falseVal;
        }
    }
}

