/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.template.population.openoffice;

import com.docmosis.template.TemplateParseException;
import com.docmosis.template.analysis.ParsedField;
import com.docmosis.template.analysis.openoffice.expression.DocmosisExpression;
import com.docmosis.template.population.openoffice.ContentStreamPopulatorObfImpl;
import com.docmosis.template.population.openoffice.PopulationContext;

public class PopulationVariable {
    final ParsedField.NameTerm[] valueTerms;
    final PopulationContext ctx;
    final ParsedField.Expression expression;
    final String expressionValue;

    public PopulationVariable(ParsedField.NameTerm[] nameTermArray, PopulationContext populationContext, ContentStreamPopulatorObfImpl contentStreamPopulatorObfImpl) throws TemplateParseException {
        this(nameTermArray, null, populationContext, contentStreamPopulatorObfImpl);
    }

    public PopulationVariable(ParsedField.Expression expression, PopulationContext populationContext, ContentStreamPopulatorObfImpl contentStreamPopulatorObfImpl) throws TemplateParseException {
        this(null, expression, populationContext, contentStreamPopulatorObfImpl);
    }

    private PopulationVariable(ParsedField.NameTerm[] nameTermArray, ParsedField.Expression expression, PopulationContext populationContext, ContentStreamPopulatorObfImpl contentStreamPopulatorObfImpl) throws TemplateParseException {
        this.valueTerms = nameTermArray;
        this.expression = expression;
        this.ctx = populationContext;
        if (expression != null) {
            DocmosisExpression docmosisExpression = new DocmosisExpression(populationContext, contentStreamPopulatorObfImpl);
            try {
                this.expressionValue = docmosisExpression.evaluate(expression.getExpressionString());
            }
            catch (TemplateParseException templateParseException) {
                String string = "Unable to evaluate field expression [" + expression.getExpressionString() + "]:" + templateParseException.getMessage();
                throw new TemplateParseException(expression.getExpressionString(), new String[]{string});
            }
        } else {
            this.expressionValue = null;
        }
    }

    public ParsedField.Expression getExpression() {
        return this.expression;
    }
}

