/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.template.population.openoffice;

import com.docmosis.template.analysis.ParsedField;
import com.docmosis.template.analysis.RangeIterator;
import com.docmosis.template.analysis.SimpleTemplateImage;
import com.docmosis.template.analysis.SimpleTemplateRepeatableSection;
import com.docmosis.template.analysis.SteppableRangeIterator;
import com.docmosis.template.analysis.TemplateSection;
import com.docmosis.template.analysis.barcode.BarcodeException;
import com.docmosis.template.analysis.barcode.BarcodeGenerator;
import com.docmosis.template.analysis.barcode.BarcodeGeneratorFactory;
import com.docmosis.template.analysis.barcode.BarcodeInfo;
import com.docmosis.template.analysis.barcode.BarcodeInfoFactory;
import com.docmosis.template.analysis.barcode.BarcodeType;
import com.docmosis.template.population.DataProvider;
import com.docmosis.template.population.DataProviderBuilder;
import com.docmosis.template.population.DataProvisionFetchException;
import com.docmosis.template.population.DataProvisionNotFoundException;
import com.docmosis.template.population.ImageSupplier;
import com.docmosis.template.population.ImageSupplierInfo;
import com.docmosis.template.population.RepeatingSectionGroups;
import com.docmosis.template.population.openoffice.ContentStreamPopulatorObfImpl;
import com.docmosis.template.population.openoffice.PopulationVariable;
import com.docmosis.template.population.render.DataProvisionMetaDataCollector;
import com.docmosis.util.DMProperties;
import com.docmosis.util.Equivalence;
import com.docmosis.util.logging.LogManager;
import com.docmosis.util.logging.Logger;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class PopulationContext
implements Cloneable {
    private static final Logger D = LogManager.getLogger(PopulationContext.class);
    private static final boolean B = DMProperties.getBoolean("docmosis.populator.error.delegate.logErrors", true);
    private PopulationContext E;
    private String C;
    private TemplateSection G;
    private DataProvider F;
    private PopulationIndex A = new PopulationIndex();
    protected Map populationVariables;
    private Set I;
    private Map<String, RepeatingSectionGroups> H;

    public PopulationContext(DataProvider dataProvider) {
        this(dataProvider, null);
    }

    public PopulationContext(DataProvider dataProvider, Map map) {
        this.F = dataProvider;
        this.populationVariables = map;
    }

    static PopulationContext cloneIt(PopulationContext populationContext) {
        try {
            return (PopulationContext)populationContext.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            D.error("Unexpected", cloneNotSupportedException);
            return null;
        }
    }

    protected Object clone() throws CloneNotSupportedException {
        PopulationContext populationContext = (PopulationContext)super.clone();
        if (this.E != null) {
            populationContext.E = (PopulationContext)this.E.clone();
        }
        if (this.A != null) {
            populationContext.A = (PopulationIndex)this.A.clone();
        }
        populationContext.populationVariables = this.populationVariables;
        populationContext.I = this.I;
        populationContext.C = this.C;
        populationContext.G = this.G;
        populationContext.F = this.F;
        populationContext.H = this.H;
        return populationContext;
    }

    public PopulationContext getParentContext() {
        return this.E;
    }

    public int getCurrentIndex() {
        return this.A.getDataIndex();
    }

    public int getSize() {
        return this.A.getSize();
    }

    public int getItemNumber() {
        return this.A.getRangeIndex() + 1;
    }

    public int getRowNumber() {
        return this.A.getRowNumber();
    }

    public int getRowIndex() {
        return this.A.getRowNumber() - 1;
    }

    public PopulationContext startSection(TemplateSection templateSection, ParsedField.NameTerm nameTerm, int n) {
        PopulationContext populationContext;
        String string;
        String string2 = string = nameTerm == null ? null : nameTerm.getLookupName();
        if (string != null) {
            DataProvider dataProvider = this.F == null || string == null || nameTerm.isGrouped() && this.getGroupRangeIterator(nameTerm) == null ? this.F : this.getDataProvider(nameTerm, n);
            populationContext = new PopulationContext(dataProvider);
            populationContext.C = string;
        } else {
            populationContext = new PopulationContext(this.F);
            populationContext.C = this.C;
        }
        if (nameTerm.isGrouped()) {
            populationContext.setGroupIdx(nameTerm, this.getGroupIdx(nameTerm));
            populationContext.setGroups(nameTerm, this.getGroups(nameTerm));
        }
        populationContext.E = this;
        populationContext.G = templateSection;
        return populationContext;
    }

    public PopulationContext endSection(TemplateSection templateSection) {
        return this.E;
    }

    public void setCurrentIndex(SteppableRangeIterator steppableRangeIterator) {
        this.A.setIndexes(steppableRangeIterator.rangeIndex(), steppableRangeIterator.dataIndex(), steppableRangeIterator.rowIdx() + 1, steppableRangeIterator.rowCount(), steppableRangeIterator.size());
    }

    public PopulationIndex getTableRepeatingIndex() {
        PopulationIndex populationIndex = null;
        PopulationContext populationContext = this;
        while (!(populationContext == null || populationContext.G instanceof SimpleTemplateRepeatableSection && ((SimpleTemplateRepeatableSection)populationContext.G).isDerivedFromRepeatingTableRow())) {
            populationContext = populationContext.E;
        }
        if (populationContext != null) {
            populationIndex = populationContext.A;
        }
        return populationIndex;
    }

    public ParsedField.NameTerm getRepeatingNameTerm() {
        ParsedField.NameTerm nameTerm = null;
        PopulationContext populationContext = this;
        while (populationContext != null && !(populationContext.G instanceof SimpleTemplateRepeatableSection)) {
            populationContext = populationContext.E;
        }
        if (populationContext != null) {
            nameTerm = new ParsedField.NameTerm(((SimpleTemplateRepeatableSection)populationContext.G).getParsedFieldDetails().getLastTerm());
        }
        return nameTerm;
    }

    public DataProvider[] getDataProviderLineage() {
        ArrayList<DataProvider> arrayList = new ArrayList<DataProvider>();
        PopulationContext populationContext = this;
        while (populationContext != null) {
            arrayList.add(populationContext.F);
            populationContext = populationContext.E;
        }
        DataProvider[] dataProviderArray = new DataProvider[arrayList.size()];
        arrayList.toArray(dataProviderArray);
        return dataProviderArray;
    }

    public String getString(ParsedField.NameTerm nameTerm) {
        if (this.F == null) {
            return null;
        }
        String string = nameTerm != null ? nameTerm.getLookupName() : "";
        try {
            DataProvisionMetaDataCollector.get().setNameTerm(nameTerm);
            return this.F.getString(string);
        }
        catch (DataProvisionNotFoundException dataProvisionNotFoundException) {
            if (B) {
                D.error("Cannot fetch data", dataProvisionNotFoundException);
            }
            DataProvisionMetaDataCollector.failNotFound(dataProvisionNotFoundException.getReflectedDelegateClass(), dataProvisionNotFoundException.getReflectedDelegate(), dataProvisionNotFoundException.getMessage(), null);
            this.addSuggestions(string, _A.E);
        }
        catch (DataProvisionFetchException dataProvisionFetchException) {
            if (B) {
                D.error("Cannot fetch data", dataProvisionFetchException);
            }
            DataProvisionMetaDataCollector.failFetchError(dataProvisionFetchException.getReflectedDelegateClass(), dataProvisionFetchException.getReflectedDelegate(), dataProvisionFetchException.getMessage(), null, dataProvisionFetchException);
        }
        catch (RuntimeException runtimeException) {
            if (B) {
                D.error("Cannot fetch data", runtimeException);
            }
            DataProvisionMetaDataCollector.failFetchError(null, null, "Cannot fetch data:" + runtimeException.getMessage(), null, runtimeException);
        }
        return null;
    }

    private void addSuggestions1(String string, String string2, _A _A2) {
        block13: {
            if (this.F == null) {
                return;
            }
            try {
                boolean bl = false;
                if (_A2.equals(_A.E)) {
                    bl = this.F.hasStringKey(string + "." + string2);
                } else if (_A2.equals(_A.A)) {
                    bl = this.F.hasBooleanKey(string + "." + string2);
                } else if (_A2.equals(_A.D)) {
                    bl = this.F.hasDataProviderKey(string + "." + string2);
                } else if (_A2.equals(_A.B)) {
                    bl = this.F.hasImageKey(string + "." + string2);
                } else {
                    return;
                }
                if (bl) {
                    DataProvisionMetaDataCollector.addErrorSuggestion("Did you mean " + string + "." + string2 + "?");
                    return;
                }
                int n = string.lastIndexOf(46);
                if (n != -1 && n < string.length() - 1) {
                    this.addSuggestions1(string.substring(0, n), string2, _A2);
                }
            }
            catch (RuntimeException runtimeException) {
                if (!B) break block13;
                D.error(runtimeException);
            }
        }
    }

    private void addSuggestions(String string, _A _A2) {
        if (string == null) {
            return;
        }
        int n = string.lastIndexOf(46);
        if (n != -1 && n < string.length() - 1) {
            this.addSuggestions1(string.substring(0, n), string.substring(n + 1), _A2);
        }
    }

    public DataProvider getDataProvider(ParsedField.NameTerm nameTerm, int n) {
        if (this.F == null) {
            return null;
        }
        boolean bl = nameTerm != null && nameTerm.isVariable() && ContentStreamPopulatorObfImpl.o.nameEquals(nameTerm.getLookupName());
        String string = nameTerm == null || bl ? "" : nameTerm.getLookupName();
        try {
            DataProvisionMetaDataCollector.get().setNameTerm(nameTerm);
            return this.F.getDataProvider(string, n);
        }
        catch (DataProvisionNotFoundException dataProvisionNotFoundException) {
            if (B) {
                D.error("Cannot fetch data", dataProvisionNotFoundException);
            }
            DataProvisionMetaDataCollector.failNotFound(dataProvisionNotFoundException.getReflectedDelegateClass(), dataProvisionNotFoundException.getReflectedDelegate(), dataProvisionNotFoundException.getMessage(), null);
            this.addSuggestions(string, _A.D);
        }
        catch (DataProvisionFetchException dataProvisionFetchException) {
            if (B) {
                D.error("Cannot fetch data", dataProvisionFetchException);
            }
            DataProvisionMetaDataCollector.failFetchError(dataProvisionFetchException.getReflectedDelegateClass(), dataProvisionFetchException.getReflectedDelegate(), dataProvisionFetchException.getMessage(), null, dataProvisionFetchException);
        }
        catch (RuntimeException runtimeException) {
            if (B) {
                D.error("Cannot fetch data", runtimeException);
            }
            DataProvisionMetaDataCollector.failFetchError(null, null, "Cannot fetch data:" + runtimeException.getMessage(), null, runtimeException);
        }
        return null;
    }

    public boolean getBoolean(ParsedField.NameTerm nameTerm) {
        if (this.F == null) {
            return false;
        }
        String string = nameTerm != null ? nameTerm.getLookupName() : "";
        try {
            DataProvisionMetaDataCollector.get().setNameTerm(nameTerm);
            return this.F.getBoolean(string);
        }
        catch (DataProvisionNotFoundException dataProvisionNotFoundException) {
            if (B) {
                D.error("Cannot fetch data", dataProvisionNotFoundException);
            }
            DataProvisionMetaDataCollector.failNotFound(dataProvisionNotFoundException.getReflectedDelegateClass(), dataProvisionNotFoundException.getReflectedDelegate(), dataProvisionNotFoundException.getMessage(), null);
            this.addSuggestions(string, _A.A);
        }
        catch (DataProvisionFetchException dataProvisionFetchException) {
            if (B) {
                D.error("Cannot fetch data", dataProvisionFetchException);
            }
            DataProvisionMetaDataCollector.failFetchError(dataProvisionFetchException.getReflectedDelegateClass(), dataProvisionFetchException.getReflectedDelegate(), dataProvisionFetchException.getMessage(), null, dataProvisionFetchException);
        }
        catch (RuntimeException runtimeException) {
            if (B) {
                D.error("Cannot fetch data", runtimeException);
            }
            DataProvisionMetaDataCollector.failFetchError(null, null, "Cannot fetch data:" + runtimeException.getMessage(), null, runtimeException);
        }
        return false;
    }

    public InputStream getImage(ParsedField.NameTerm nameTerm, ImageSupplier imageSupplier, SimpleTemplateImage simpleTemplateImage) throws ImageSupplier.ImageSupplierException, BarcodeException {
        boolean bl;
        boolean bl2 = bl = simpleTemplateImage != null && simpleTemplateImage.getBarcodeInfo() != null;
        if (this.F == null && !bl) {
            return null;
        }
        String string = nameTerm != null ? nameTerm.getLookupName() : "";
        try {
            Object object;
            String string2;
            if (nameTerm.isLiteral()) {
                string2 = String.valueOf(nameTerm.getLiteral());
            } else {
                DataProvisionMetaDataCollector.get().setNameTerm(nameTerm);
                string2 = this.F != null ? this.F.getString(string) : null;
            }
            if (DataProvisionMetaDataCollector.get().getValue() instanceof InputStream) {
                return (InputStream)DataProvisionMetaDataCollector.get().getValue();
            }
            if (imageSupplier != null && ((ImageSupplierInfo)(object = imageSupplier.getImage(string, string2))).isImageSupplied()) {
                return ((ImageSupplierInfo)object).getImageStream();
            }
            object = BarcodeInfoFactory.getBarcodeType(string2);
            if (simpleTemplateImage.getBarcodeInfo() != null || object != null) {
                BarcodeGenerator barcodeGenerator;
                if (object == null) {
                    object = simpleTemplateImage.getBarcodeInfo().getType();
                }
                if (string2 != null && object != null && string2.length() > ((BarcodeType)object).getMaxDataLen()) {
                    throw new BarcodeException("Barcode value too long (" + string2.length() + " chars)", new String[]{"Reduce the barcode data to below " + ((BarcodeType)object).getMaxDataLen() + " characters"});
                }
                BarcodeInfo barcodeInfo = BarcodeInfoFactory.generate(simpleTemplateImage.getBarcodeInfo(), string2);
                if (barcodeInfo != null && (barcodeGenerator = BarcodeGeneratorFactory.getGenerator(barcodeInfo.getType())) != null) {
                    return barcodeGenerator.generate(barcodeInfo);
                }
            }
            DataProvisionMetaDataCollector.get().setNameTerm(nameTerm);
            return this.F.getImage(string);
        }
        catch (DataProvisionNotFoundException dataProvisionNotFoundException) {
            if (B) {
                D.error("Cannot fetch data", dataProvisionNotFoundException);
            }
            DataProvisionMetaDataCollector.failNotFound(dataProvisionNotFoundException.getReflectedDelegateClass(), dataProvisionNotFoundException.getReflectedDelegate(), dataProvisionNotFoundException.getMessage(), null);
            this.addSuggestions(string, _A.B);
        }
        catch (DataProvisionFetchException dataProvisionFetchException) {
            if (B) {
                D.error("Cannot fetch data", dataProvisionFetchException);
            }
            DataProvisionMetaDataCollector.failFetchError(dataProvisionFetchException.getReflectedDelegateClass(), dataProvisionFetchException.getReflectedDelegate(), dataProvisionFetchException.getMessage(), null, dataProvisionFetchException);
        }
        catch (RuntimeException runtimeException) {
            if (B) {
                D.error("Cannot fetch data", runtimeException);
            }
            DataProvisionMetaDataCollector.failFetchError(null, null, "Cannot fetch data:" + runtimeException.getMessage(), null, runtimeException);
        }
        return null;
    }

    public int getDataProviderCount(ParsedField.NameTerm nameTerm) {
        if (this.F == null) {
            return 0;
        }
        boolean bl = nameTerm != null && nameTerm.isVariable() && ContentStreamPopulatorObfImpl.o.nameEquals(nameTerm.getLookupName());
        String string = nameTerm == null || bl ? "" : nameTerm.getLookupName();
        try {
            DataProvisionMetaDataCollector.get().setNameTerm(nameTerm);
            return this.F.getDataProviderCount(string);
        }
        catch (DataProvisionNotFoundException dataProvisionNotFoundException) {
            if (B) {
                D.error("Cannot fetch data", dataProvisionNotFoundException);
            }
            DataProvisionMetaDataCollector.failNotFound(dataProvisionNotFoundException.getReflectedDelegateClass(), dataProvisionNotFoundException.getReflectedDelegate(), dataProvisionNotFoundException.getMessage(), null);
            this.addSuggestions(string, _A.D);
        }
        catch (DataProvisionFetchException dataProvisionFetchException) {
            if (B) {
                D.error("Cannot fetch data", dataProvisionFetchException);
            }
            DataProvisionMetaDataCollector.failFetchError(dataProvisionFetchException.getReflectedDelegateClass(), dataProvisionFetchException.getReflectedDelegate(), dataProvisionFetchException.getMessage(), null, dataProvisionFetchException);
        }
        catch (RuntimeException runtimeException) {
            if (B) {
                D.error("Cannot fetch data", runtimeException);
            }
            DataProvisionMetaDataCollector.failFetchError(null, null, "Cannot fetch data:" + runtimeException.getMessage(), null, runtimeException);
        }
        return 0;
    }

    public PopulationVariable getVariable(String string) {
        if (this.populationVariables != null && this.populationVariables.containsKey(string)) {
            return (PopulationVariable)this.populationVariables.get(string);
        }
        if (this.E != null) {
            return this.E.getVariable(string);
        }
        return null;
    }

    public void clearTempVariables() {
        if (this.I != null) {
            Iterator iterator = this.I.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                this.populationVariables.remove(string);
                iterator.remove();
            }
        }
    }

    public Map getTempVariables() {
        HashMap hashMap = new HashMap();
        if (this.I != null) {
            for (String string : this.I) {
                hashMap.put(string, this.populationVariables.get(string));
            }
        }
        return hashMap;
    }

    public void addTempVariables(Map map) {
        if (!map.isEmpty()) {
            for (String string : map.keySet()) {
                this.setVariable(string, (PopulationVariable)map.get(string), true);
            }
        }
    }

    public PopulationVariable isTempVariable(String string) {
        if (this.I != null && this.I.contains(string)) {
            return (PopulationVariable)this.populationVariables.get(string);
        }
        if (this.E != null) {
            return this.E.isTempVariable(string);
        }
        return null;
    }

    public void setVariable(String string, PopulationVariable populationVariable, boolean bl) {
        if (this.populationVariables == null) {
            this.populationVariables = new HashMap();
        }
        this.populationVariables.put(string, populationVariable);
        if (bl) {
            if (this.I == null) {
                this.I = new HashSet();
            }
            this.I.add(string);
        }
        if (!bl) {
            PopulationContext.updateVariableInParentContexts(this.E, string, populationVariable);
        }
    }

    private static void updateVariableInParentContexts(PopulationContext populationContext, String string, PopulationVariable populationVariable) {
        if (populationContext != null) {
            if (populationContext.populationVariables != null && populationContext.populationVariables.containsKey(string)) {
                populationContext.setVariable(string, populationVariable, false);
            } else {
                PopulationContext.updateVariableInParentContexts(populationContext.E, string, populationVariable);
            }
        }
    }

    public RepeatingSectionGroups.Group[] getGroups(ParsedField.NameTerm nameTerm) {
        RepeatingSectionGroups repeatingSectionGroups;
        if (this.H != null && (repeatingSectionGroups = this.H.get(nameTerm.getFullTerm())) != null) {
            return repeatingSectionGroups.getGroups();
        }
        return null;
    }

    public void setGroups(ParsedField.NameTerm nameTerm, RepeatingSectionGroups.Group[] groupArray) {
        if (this.H == null) {
            this.H = new HashMap<String, RepeatingSectionGroups>();
        }
        this.H.put(nameTerm.getFullTerm(), new RepeatingSectionGroups(groupArray));
    }

    public int getGroupIdx(ParsedField.NameTerm nameTerm) {
        RepeatingSectionGroups repeatingSectionGroups;
        if (this.H != null && (repeatingSectionGroups = this.H.get(nameTerm.getFullTerm())) != null) {
            return repeatingSectionGroups.getGroupIdx();
        }
        return -1;
    }

    public void setGroupIdx(ParsedField.NameTerm nameTerm, int n) {
        RepeatingSectionGroups repeatingSectionGroups;
        if (this.H != null && (repeatingSectionGroups = this.H.get(nameTerm.getFullTerm())) != null) {
            repeatingSectionGroups.setGroupIdx(n);
        }
    }

    public RangeIterator getGroupRangeIterator(ParsedField.NameTerm nameTerm) {
        RepeatingSectionGroups repeatingSectionGroups;
        if (this.H != null && (repeatingSectionGroups = this.H.get(nameTerm.getFullTerm())) != null) {
            return repeatingSectionGroups.getGroupRangeIterator();
        }
        return null;
    }

    public String toStringPretty() {
        return this.F != null ? this.F.toStringPretty() : "";
    }

    public String toStringPretty(ParsedField.NameTerm nameTerm) {
        String string;
        String string2 = string = nameTerm != null ? nameTerm.getLookupName() : "";
        if (this.F != null) {
            if (this.F.hasDataProviderKey(string)) {
                DataProviderBuilder dataProviderBuilder = new DataProviderBuilder();
                for (int i = 0; i < this.F.getDataProviderCount(string); ++i) {
                    dataProviderBuilder.add(this.F.getDataProvider(string, i), string);
                }
                return dataProviderBuilder.getDataProvider().toStringPretty();
            }
            if (this.F.hasStringKey(string)) {
                return this.F.getString(string);
            }
            return this.F.toStringPretty();
        }
        return "";
    }

    private static class _A {
        public static final _A E = new _A("getString");
        public static final _A A = new _A("getBoolean");
        public static final _A D = new _A("getDP");
        public static final _A B = new _A("getImage");
        private final String C;

        public _A(String string) {
            this.C = string;
        }

        public boolean equals(Object object) {
            return object instanceof _A && Equivalence.equivalentObjects(this.C, ((_A)object).C);
        }

        public int hashCode() {
            return this.C == null ? 0 : this.C.hashCode();
        }
    }

    public static class PopulationIndex
    implements Cloneable {
        private int A;
        private int E;
        private int B;
        private int D;
        private int C;

        protected Object clone() throws CloneNotSupportedException {
            return super.clone();
        }

        public void setIndexes(int n, int n2, int n3, int n4, int n5) {
            this.A = n;
            this.E = n2;
            this.B = n3;
            this.D = n4;
            this.C = n5;
        }

        public int getSize() {
            return this.C;
        }

        public boolean isEvenRow() {
            return this.B % 2 == 0;
        }

        public boolean isOnlyRow() {
            return this.D == 1;
        }

        public boolean isFirstRow() {
            return this.B == 1;
        }

        public boolean isLastRow() {
            return this.B == this.D;
        }

        public int getRowNumber() {
            return this.B;
        }

        public int getRowCount() {
            return this.D;
        }

        public int getDataIndex() {
            return this.E;
        }

        public int getRangeIndex() {
            return this.A;
        }
    }
}

