/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.template.population.openoffice;

import com.docmosis.template.analysis.ImageAnalysis;
import com.docmosis.template.analysis.list.ListStyles;
import com.docmosis.template.analysis.openoffice.ODFTemplateAnalysis;
import com.docmosis.template.population.DataProvider;
import com.docmosis.template.population.PopulatedFilesCollection;
import com.docmosis.template.population.PopulationException;
import com.docmosis.template.population.PopulationTask;
import com.docmosis.template.population.Populator;
import com.docmosis.template.population.openoffice.ContentStreamPopulatorObfImpl;
import com.docmosis.template.population.openoffice.ODFPopulationInformation;
import com.docmosis.template.population.openoffice.PopulationContext;
import com.docmosis.template.population.openoffice.StreamTransferer;
import com.docmosis.util.DMProperties;
import com.docmosis.util.FileUtilities;
import com.docmosis.util.J;
import com.docmosis.util.MultiInputStreamReader;
import com.docmosis.util.logging.LogManager;
import com.docmosis.util.logging.Logger;
import com.docmosis.util.pipeline.DataTask;
import com.docmosis.util.pipeline.TaskException;
import com.docmosis.util.pipeline.impl.BasicStreamDataWorker;
import com.docmosis.util.thirdparty.ImageInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ODFExplodedTemplatePopulator
extends BasicStreamDataWorker
implements Populator {
    private static final Logger J = LogManager.getLogger(ODFExplodedTemplatePopulator.class);
    private static final String F = "docmosis.populator.format.rtf.imageTotalSizeLimit";
    private static final String L = "docmosis.populator.metaFile.processing.enabled";
    private static final String H = "<draw:image ";
    private static final String G = "xlink:href=\"";
    private final long K = DMProperties.getLong("docmosis.populator.format.rtf.imageTotalSizeLimit", 10000000L);
    private final boolean I = DMProperties.getBoolean("docmosis.populator.metaFile.processing.enabled", false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processTask(DataTask dataTask) throws IOException, TaskException {
        if (!(dataTask instanceof PopulationTask)) {
            throw new TaskException("Task given is not a PopulationTask");
        }
        PopulationTask populationTask = (PopulationTask)dataTask;
        MultiInputStreamReader multiInputStreamReader = new MultiInputStreamReader(populationTask.getInputStream());
        if (!multiInputStreamReader.nextStream()) {
            throw new IOException("Stream is not in exploded format.  Expected content.");
        }
        _A _A2 = null;
        _A _A3 = null;
        File file = null;
        _A _A4 = null;
        File file2 = null;
        long l = System.currentTimeMillis();
        try {
            ImageAnalysis.ImageDetail[] imageDetailArray;
            boolean bl = populationTask.isRtfFormatBeingGenerated() && this.K > 0L;
            ImageAnalysis imageAnalysis = populationTask.getTemplate().getAnalysis().getTemplateImages();
            _C _C2 = null;
            if (bl) {
                _C2 = new _C();
                if (imageAnalysis != null && (imageDetailArray = imageAnalysis.getImages()) != null) {
                    for (int i = 0; i < imageDetailArray.length; ++i) {
                        _C2.A(imageDetailArray[i]);
                    }
                }
            }
            imageDetailArray = populationTask.getPopulatedFilesCollection();
            String string = populationTask.getBookmarkName();
            boolean bl2 = imageDetailArray.size() > 0;
            file2 = FileUtilities.createTempFile("dm_", bl2 ? ".odt" : "pop");
            AtomicBoolean atomicBoolean = new AtomicBoolean(false);
            AtomicBoolean atomicBoolean2 = new AtomicBoolean(false);
            PopulatedFilesCollection.PopulatedFile populatedFile = imageDetailArray.add(string, file2, false, null, atomicBoolean, atomicBoolean2);
            populatedFile.setBasedOnTemplateId(populationTask.getTemplate().getId());
            populatedFile.setSensitivityLabelInfo(populationTask.getTemplate().getAnalysis().getSensitivityLabelInfo());
            if (J.isDebugEnabled()) {
                J.debug("added template file [" + file2.getName() + "] to insert at bookmark [" + string + "]");
            }
            _A2 = this.processContent(multiInputStreamReader, populationTask, bl, _C2, atomicBoolean, atomicBoolean2);
            populatedFile.setEmptyDocumentCreated(_A2.B.isEmptyDocumentCreated());
            long l2 = System.currentTimeMillis();
            J.debug("content population took:" + (l2 - l));
            long l3 = l2;
            if (!multiInputStreamReader.nextStream()) {
                throw new IOException("Stream is not in exploded format.  Expected styles");
            }
            _A3 = this.processStyles(multiInputStreamReader, populationTask, bl, _C2, _A2);
            l2 = System.currentTimeMillis();
            J.debug("style population took:" + (l2 - l3));
            l3 = l2;
            if (!multiInputStreamReader.nextStream()) {
                throw new IOException("Stream is not in exploded format.  Expected manifest");
            }
            file = this.processManifest(multiInputStreamReader, populationTask, _A2, _A3);
            l2 = System.currentTimeMillis();
            J.debug("manifest population took:" + (l2 - l3));
            if (this.I) {
                l3 = l2;
                if (!multiInputStreamReader.nextStream()) {
                    throw new IOException("Stream is not in exploded format.  Expected meta");
                }
                _A4 = this.processMeta(multiInputStreamReader, populationTask, _A2);
                l2 = System.currentTimeMillis();
                J.debug("meta population took:" + (l2 - l3));
            }
            l3 = l2;
            if (!multiInputStreamReader.nextStream()) {
                throw new IOException("Stream is not in exploded format.  Expected main ODF.");
            }
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(file2);
                this.processODF(multiInputStreamReader, fileOutputStream, _A2, _A3, file, _A4, populationTask, bl, _C2);
            }
            catch (Throwable throwable) {
                FileUtilities.close(fileOutputStream);
                throw throwable;
            }
            FileUtilities.close(fileOutputStream);
            while (multiInputStreamReader.read(this.buffer) != -1) {
            }
            if (_A2.B.isErrorsDetected() || _A3.B.isErrorsDetected()) {
                populationTask.setErrorsDetectedInDocument(true);
            }
            l2 = System.currentTimeMillis();
            J.debug("odf staging took:" + (l2 - l3));
            J.debug("Populated in " + (l2 - l));
            if (multiInputStreamReader.nextStream()) {
                throw new IOException("Stream is expected to be finished");
            }
        }
        catch (Throwable throwable) {
            _A.A(_A2);
            _A.A(_A3);
            _A.A(_A4);
            FileUtilities.delete(file);
            throw throwable;
        }
        _A.A(_A2);
        _A.A(_A3);
        _A.A(_A4);
        FileUtilities.delete(file);
        multiInputStreamReader = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private _A processContent(InputStream inputStream, PopulationTask populationTask, boolean bl, _C _C2, AtomicBoolean atomicBoolean, AtomicBoolean atomicBoolean2) throws IOException, TaskException {
        FileOutputStream fileOutputStream = null;
        boolean bl2 = false;
        File file = FileUtilities.createTempFile("dm_", "pop");
        ODFPopulationInformation oDFPopulationInformation = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            ContentStreamPopulatorObfImpl contentStreamPopulatorObfImpl = new ContentStreamPopulatorObfImpl(inputStream, fileOutputStream, populationTask.getTemplate().getAnalysis(), populationTask.getDataProvider(), populationTask.getRendererRegistry(), false, populationTask.getPopulatedFilesCollection(), populationTask.getTemplate().getId(), populationTask.getTemplateMergeCoordinates(), populationTask.populationErrorsFatal(), populationTask.getTemplateStore(), populationTask.getImageSupplier(), populationTask.getImageScalingDefault(), populationTask.getRequestedFormats(), populationTask.isProcessStringMarkup(), null, new ListStyles(), populationTask.getRenderedListIds(), populationTask.getListResetInfo(), populationTask.getFieldTextColourOverrideStyleName());
            oDFPopulationInformation = contentStreamPopulatorObfImpl.A((PopulationContext)populationTask.getPopulationContext());
            if (bl) {
                FileUtilities.close(fileOutputStream);
                ODFExplodedTemplatePopulator.countImageReferences(file, _C2);
            }
            if (contentStreamPopulatorObfImpl.C()) {
                atomicBoolean.set(true);
            }
            if (contentStreamPopulatorObfImpl.H()) {
                atomicBoolean2.set(true);
            }
            bl2 = true;
        }
        catch (Throwable throwable) {
            FileUtilities.close(fileOutputStream);
            if (!bl2) {
                FileUtilities.delete(file);
            }
            throw throwable;
        }
        FileUtilities.close(fileOutputStream);
        if (!bl2) {
            FileUtilities.delete(file);
        }
        return new _A(file, oDFPopulationInformation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void countImageReferences(File file, _C _C2) throws IOException {
        int n = DMProperties.getInt("docmosis.stream.buffer.size", 4096);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), Charset.forName("UTF-8")), n);
        boolean bl = false;
        boolean bl2 = true;
        try {
            int n2;
            J j = new J(1000);
            while ((n2 = bufferedReader.read()) != -1) {
                char c = (char)n2;
                if (c == '<') {
                    j.B(c);
                    bl = true;
                    bl2 = true;
                    continue;
                }
                if (c == '>') {
                    boolean bl3;
                    j.B(c);
                    boolean bl4 = bl3 = bl2 && j.C(H);
                    if (bl3) {
                        int n3 = j.D(G);
                        if (n3 == -1) {
                            J.warn("Cannot find image name attribute processing RTF result");
                        } else {
                            int n4 = j.A("\"", n3 += G.length());
                            if (n4 == -1) {
                                J.warn("Cannot find end of image name attribute processing RTF result");
                            } else {
                                String string = j.B(n3, n4 - n3);
                                if (!string.startsWith("./ObjectReplacements/")) {
                                    if (string.startsWith("Pictures/")) {
                                        string = string.substring("Pictures/".length());
                                    }
                                    _C2.A(string);
                                }
                            }
                        }
                    }
                    bl = false;
                    j.B();
                    continue;
                }
                if (!bl || !bl2) continue;
                j.B(c);
                if (j.E() != H.length() || j.C(H)) continue;
                bl2 = false;
                j.B();
            }
        }
        finally {
            FileUtilities.close(bufferedReader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private _A processStyles(InputStream inputStream, PopulationTask populationTask, boolean bl, _C _C2, _A _A2) throws IOException, TaskException {
        FileOutputStream fileOutputStream = null;
        boolean bl2 = false;
        File file = FileUtilities.createTempFile("dm_", "pop");
        ODFPopulationInformation oDFPopulationInformation = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            Map map = _A2.B.getPopulationVariables();
            ContentStreamPopulatorObfImpl contentStreamPopulatorObfImpl = new ContentStreamPopulatorObfImpl(inputStream, fileOutputStream, populationTask.getTemplate().getAnalysis().getStyleAnalysis(), populationTask.getDataProvider(), populationTask.getRendererRegistry(), true, populationTask.getPopulatedFilesCollection(), populationTask.getTemplate().getId(), populationTask.getTemplateMergeCoordinates(), populationTask.populationErrorsFatal(), populationTask.getTemplateStore(), populationTask.getImageSupplier(), populationTask.getImageScalingDefault(), populationTask.getRequestedFormats(), populationTask.isProcessStringMarkup(), map, _A2.B.getListStyles(), populationTask.getRenderedListIds(), populationTask.getListResetInfo(), _A2.B.getFieldTextColourOverrideStyleName());
            oDFPopulationInformation = contentStreamPopulatorObfImpl.A((PopulationContext)populationTask.getPopulationContext());
            if (bl) {
                FileUtilities.close(fileOutputStream);
                ODFExplodedTemplatePopulator.countImageReferences(file, _C2);
            }
            bl2 = true;
        }
        catch (Throwable throwable) {
            FileUtilities.close(fileOutputStream);
            if (!bl2) {
                FileUtilities.delete(file);
            }
            throw throwable;
        }
        FileUtilities.close(fileOutputStream);
        if (!bl2) {
            FileUtilities.delete(file);
        }
        return new _A(file, oDFPopulationInformation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File processManifest(InputStream inputStream, PopulationTask populationTask, _A _A2, _A _A3) throws IOException, TaskException {
        FileOutputStream fileOutputStream = null;
        boolean bl = false;
        File file = FileUtilities.createTempFile("dm_", "pop");
        try {
            fileOutputStream = new FileOutputStream(file);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, Charset.forName("UTF-8"));
            StreamTransferer streamTransferer = new StreamTransferer(new InputStreamReader(inputStream, Charset.forName("UTF-8")), outputStreamWriter);
            long l = ((ODFTemplateAnalysis)populationTask.getTemplate().getAnalysis()).getManifestAnalysis().getPictureInsertionPoint();
            if (l != 0L) {
                streamTransferer.streamTo(l);
                Map map = _A2.B.getPicturesToAdd();
                if (map != null && !map.isEmpty()) {
                    for (String string : map.keySet()) {
                        outputStreamWriter.write(" <manifest:file-entry manifest:media-type=\"image/jpeg\" manifest:full-path=\"" + string + "\"/>");
                    }
                }
                if ((map = _A3.B.getPicturesToAdd()) != null && !map.isEmpty()) {
                    for (String string : map.keySet()) {
                        outputStreamWriter.write(" <manifest:file-entry manifest:media-type=\"image/jpeg\" manifest:full-path=\"" + string + "\"/>");
                    }
                }
            }
            streamTransferer.streamToEnd();
            streamTransferer.flush();
            bl = true;
        }
        catch (Throwable throwable) {
            FileUtilities.close(fileOutputStream);
            if (!bl) {
                FileUtilities.delete(file);
            }
            throw throwable;
        }
        FileUtilities.close(fileOutputStream);
        if (!bl) {
            FileUtilities.delete(file);
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private _A processMeta(InputStream inputStream, PopulationTask populationTask, _A _A2) throws IOException, TaskException {
        FileOutputStream fileOutputStream = null;
        boolean bl = false;
        File file = FileUtilities.createTempFile("dm_", "pop");
        ODFPopulationInformation oDFPopulationInformation = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            Map map = _A2.B.getPopulationVariables();
            ContentStreamPopulatorObfImpl contentStreamPopulatorObfImpl = new ContentStreamPopulatorObfImpl(inputStream, fileOutputStream, populationTask.getTemplate().getAnalysis().getMetaAnalysis(), populationTask.getDataProvider(), populationTask.getRendererRegistry(), true, populationTask.getPopulatedFilesCollection(), populationTask.getTemplate().getId(), populationTask.getTemplateMergeCoordinates(), populationTask.populationErrorsFatal(), populationTask.getTemplateStore(), populationTask.getImageSupplier(), populationTask.getImageScalingDefault(), populationTask.getRequestedFormats(), populationTask.isProcessStringMarkup(), map, null, populationTask.getRenderedListIds(), populationTask.getListResetInfo(), null);
            oDFPopulationInformation = contentStreamPopulatorObfImpl.A((PopulationContext)populationTask.getPopulationContext());
            bl = true;
        }
        catch (Throwable throwable) {
            FileUtilities.close(fileOutputStream);
            if (!bl) {
                FileUtilities.delete(file);
            }
            throw throwable;
        }
        FileUtilities.close(fileOutputStream);
        if (!bl) {
            FileUtilities.delete(file);
        }
        return new _A(file, oDFPopulationInformation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processODF(InputStream inputStream, OutputStream outputStream, _A _A2, _A _A3, File file, _A _A4, PopulationTask populationTask, boolean bl, _C _C2) throws IOException, TaskException {
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        ZipOutputStream zipOutputStream = null;
        FileInputStream fileInputStream = null;
        boolean bl2 = false;
        try {
            int n;
            ZipEntry zipEntry;
            zipOutputStream = new ZipOutputStream(outputStream);
            boolean bl3 = false;
            boolean bl4 = false;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                bl2 = true;
                bl4 = zipEntry.getName().startsWith("Pictures/");
                if (!bl3 && bl4) {
                    bl3 = true;
                }
                if (_A2.B.isPictureToRemove(zipEntry.getName()) || _A3.B.isPictureToRemove(zipEntry.getName())) continue;
                InputStream inputStream2 = zipInputStream;
                File file2 = null;
                FileInputStream fileInputStream2 = null;
                try {
                    int n2;
                    if (bl4 && bl) {
                        ImageAnalysis.ImageDetail imageDetail;
                        String string = zipEntry.getName().substring("Pictures/".length());
                        if (_C2.B(string) != null) {
                            imageDetail = _C2.B(string).A;
                        } else {
                            _D _D2 = ODFExplodedTemplatePopulator.getImageInfo(string, zipInputStream);
                            imageDetail = _D2.A;
                            file2 = _D2.B;
                            fileInputStream2 = new FileInputStream(file2);
                            inputStream2 = fileInputStream2;
                        }
                        _C2.A(imageDetail);
                    }
                    zipOutputStream.putNextEntry(new ZipEntry(zipEntry.getName()));
                    while ((n2 = ((InputStream)inputStream2).read(this.buffer)) != -1) {
                        zipOutputStream.write(this.buffer, 0, n2);
                    }
                    zipOutputStream.closeEntry();
                }
                finally {
                    FileUtilities.close(fileInputStream2);
                    FileUtilities.delete(file2);
                }
            }
            zipInputStream.closeEntry();
            zipInputStream = null;
            if (!bl2) {
                throw new TaskException(new PopulationException("ODF Stream expected"));
            }
            ODFExplodedTemplatePopulator.addPictures(_A2.B.getPicturesToAdd(), this.buffer, zipOutputStream, bl, _C2);
            ODFExplodedTemplatePopulator.addPictures(_A3.B.getPicturesToAdd(), this.buffer, zipOutputStream, bl, _C2);
            if (bl) {
                _C2.B();
                long l = _C2.A();
                if (l > this.K) {
                    throw new IOException("RTF format is not compatible with large images.  You will need to reduce the size of the images used in your template or your data if producing RTF format documents. The total size limit is " + this.K + " bytes and this document is " + l + ".  The property " + "\"" + F + "\" controls this limit (-1 disables).");
                }
            }
            zipEntry = new ZipEntry("content.xml");
            zipOutputStream.putNextEntry(new ZipEntry(zipEntry.getName()));
            fileInputStream = new FileInputStream(_A2.A);
            while ((n = fileInputStream.read(this.buffer)) != -1) {
                zipOutputStream.write(this.buffer, 0, n);
            }
            FileUtilities.close(fileInputStream);
            zipOutputStream.closeEntry();
            zipEntry = new ZipEntry("styles.xml");
            zipOutputStream.putNextEntry(new ZipEntry(zipEntry.getName()));
            fileInputStream = new FileInputStream(_A3.A);
            while ((n = fileInputStream.read(this.buffer)) != -1) {
                zipOutputStream.write(this.buffer, 0, n);
            }
            FileUtilities.close(fileInputStream);
            zipOutputStream.closeEntry();
            zipEntry = new ZipEntry("META-INF/manifest.xml");
            zipOutputStream.putNextEntry(new ZipEntry(zipEntry.getName()));
            fileInputStream = new FileInputStream(file);
            while ((n = fileInputStream.read(this.buffer)) != -1) {
                zipOutputStream.write(this.buffer, 0, n);
            }
            FileUtilities.close(fileInputStream);
            zipOutputStream.closeEntry();
            if (this.I && _A4 != null) {
                zipEntry = new ZipEntry("meta.xml");
                zipOutputStream.putNextEntry(new ZipEntry(zipEntry.getName()));
                fileInputStream = new FileInputStream(_A4.A);
                while ((n = fileInputStream.read(this.buffer)) != -1) {
                    zipOutputStream.write(this.buffer, 0, n);
                }
                FileUtilities.close(fileInputStream);
                zipOutputStream.closeEntry();
            }
            zipOutputStream.finish();
            zipInputStream = null;
            zipOutputStream = null;
        }
        catch (Throwable throwable) {
            zipInputStream = null;
            zipOutputStream = null;
            FileUtilities.close(fileInputStream);
            throw throwable;
        }
        FileUtilities.close(fileInputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addPictures(Map map, byte[] byArray, ZipOutputStream zipOutputStream, boolean bl, _C _C2) throws IOException {
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                String string = (String)entry.getKey();
                InputStream inputStream = (InputStream)entry.getValue();
                if (inputStream == null) continue;
                File file = null;
                try {
                    int n;
                    if (bl) {
                        String string2 = string;
                        if (string2.startsWith("Pictures/")) {
                            string2 = string2.substring("Pictures/".length());
                        }
                        _D _D2 = ODFExplodedTemplatePopulator.getImageInfo(string2, inputStream);
                        _C2.A(_D2.A);
                        file = _D2.B;
                        inputStream = new FileInputStream(file);
                    }
                    zipOutputStream.putNextEntry(new ZipEntry(string));
                    while ((n = inputStream.read(byArray)) != -1) {
                        zipOutputStream.write(byArray, 0, n);
                    }
                    zipOutputStream.closeEntry();
                }
                catch (Throwable throwable) {
                    FileUtilities.close(inputStream);
                    FileUtilities.delete(file);
                    throw throwable;
                }
                FileUtilities.close(inputStream);
                FileUtilities.delete(file);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static _D getImageInfo(String string, InputStream inputStream) throws IOException {
        _D _D2;
        FileInputStream fileInputStream = null;
        File file = null;
        try {
            _D _D3;
            file = FileUtilities.createTempFile("dmp", "img");
            FileUtilities.streamOut(inputStream, file);
            fileInputStream = new FileInputStream(file);
            ImageInfo imageInfo = new ImageInfo();
            imageInfo.setInput(fileInputStream);
            if (!imageInfo.check()) {
                throw new IOException("Cannot determine image info for name:" + string);
            }
            _D2 = _D3 = new _D(string, imageInfo, file);
        }
        catch (Throwable throwable) {
            FileUtilities.close(fileInputStream);
            throw throwable;
        }
        FileUtilities.close(fileInputStream);
        return _D2;
    }

    @Override
    public void setDataProvider(DataProvider dataProvider) {
    }

    @Override
    protected String getModuleTimingId() {
        return "population";
    }

    private static class _D {
        private ImageAnalysis.ImageDetail A;
        private File B;

        public _D(String string, ImageInfo imageInfo, File file) {
            this.A = new ImageAnalysis.ImageDetail(string, file.length(), imageInfo.getWidth(), imageInfo.getHeight(), imageInfo.getBitsPerPixel());
            this.B = file;
        }
    }

    private static class _B {
        private int B;
        private ImageAnalysis.ImageDetail A;

        private _B() {
        }

        public void A() {
            ++this.B;
        }

        public void A(ImageAnalysis.ImageDetail imageDetail) {
            this.A = imageDetail;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("detail=[").append(this.A == null ? "<null>" : this.A.toString()).append("] ").append("count=").append(this.B);
            return stringBuffer.toString();
        }
    }

    private static class _C {
        private final Map A = new HashMap();

        private _C() {
        }

        private _B B(String string) {
            _B _B2 = (_B)this.A.get(string);
            if (_B2 == null) {
                _B2 = new _B();
                this.A.put(string, _B2);
            }
            return _B2;
        }

        private void B() {
            for (Map.Entry entry : this.A.entrySet()) {
                _B _B2 = (_B)entry.getValue();
                if (_B2 != null && _B2.A != null) continue;
                J.warn("Incomplete image check when processing RTF (image=[" + entry.getKey() + "])");
            }
        }

        public void A(String string) {
            _B _B2 = this.B(string);
            _B2.A();
        }

        public void A(ImageAnalysis.ImageDetail imageDetail) {
            _B _B2 = this.B(imageDetail.getName());
            _B2.A(imageDetail);
        }

        public long A() {
            long l = 0L;
            for (Map.Entry entry : this.A.entrySet()) {
                _B _B2 = (_B)entry.getValue();
                l += (long)_B2.B * _B2.A.memSize();
            }
            return l;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            for (Map.Entry entry : this.A.entrySet()) {
                stringBuffer.append("name=[").append(entry.getKey()).append("] ");
                _B _B2 = (_B)entry.getValue();
                stringBuffer.append(_B2.toString());
                ++n;
            }
            StringBuffer stringBuffer2 = new StringBuffer();
            stringBuffer2.append(this.getClass().getName()).append('@').append(System.identityHashCode(this)).append(':');
            stringBuffer2.append("totalMemSize=").append(this.A());
            stringBuffer2.append(" items=").append(n);
            stringBuffer2.append(' ').append(stringBuffer);
            return stringBuffer2.toString();
        }
    }

    private static class _A {
        File A;
        ODFPopulationInformation B;

        public _A(File file, ODFPopulationInformation oDFPopulationInformation) {
            this.A = file;
            this.B = oDFPopulationInformation;
        }

        public void A() {
            FileUtilities.delete(this.A);
        }

        public static void A(_A _A2) {
            if (_A2 != null) {
                _A2.A();
            }
        }
    }
}

