/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.template.population.data;

import com.docmosis.template.population.MutableDataProvider;
import com.docmosis.template.population.StringInterceptor;
import com.docmosis.template.population.StringInterceptorException;
import com.docmosis.util.Base64Helper;
import com.docmosis.util.DMProperties;
import java.io.ByteArrayInputStream;

public class Base64ImageStringInterceptor
implements StringInterceptor {
    public static final String FIELD_IMAGE_BASE64_ENCODED_PREFIX = DMProperties.getString("docmosis.data.provider.builder.base64Image.prefix", "image:base64:");
    public static final boolean FIELD_IMAGE_BASE64_ALLOW_FOR_DATA_URI_SCHEME = DMProperties.getBoolean("docmosis.data.provider.builder.base64Image.allowForDataURIScheme", true);
    public static final boolean FIELD_IMAGE_BASE64_PROCESSING_TERMINUS = DMProperties.getBoolean("docmosis.data.provider.builder.base64Image.processingTerminus", false);
    public static final boolean FIELD_IMAGE_BASE64_ADD_STRINGS = DMProperties.getBoolean("docmosis.data.provider.builder.base64Image.addStrings", false);
    public static final String DATA_URI_SCHEME_PREFIX = "data:";
    public static final String DATA_URI_SCHEME_BASE_64_EXTENSION = ";base64,";
    private static final Base64ImageStringInterceptor D = new Base64ImageStringInterceptor(FIELD_IMAGE_BASE64_ENCODED_PREFIX, FIELD_IMAGE_BASE64_ALLOW_FOR_DATA_URI_SCHEME, FIELD_IMAGE_BASE64_PROCESSING_TERMINUS, FIELD_IMAGE_BASE64_ADD_STRINGS);
    private final String C;
    private final boolean B;
    private final boolean E;
    private final boolean A;

    public Base64ImageStringInterceptor(String string, boolean bl, boolean bl2, boolean bl3) {
        if (string == null) {
            throw new NullPointerException("Cannot set a null prefix");
        }
        this.C = string;
        this.E = bl;
        this.B = bl2;
        this.A = bl3;
    }

    public static Base64ImageStringInterceptor getDefaultInstance() {
        return D;
    }

    @Override
    public boolean process(String string, String string2, MutableDataProvider mutableDataProvider) throws StringInterceptorException {
        if (string2 != null) {
            if (string2.startsWith(this.C)) {
                if (this.A) {
                    mutableDataProvider.setString(string, string2);
                }
                string2 = string2.substring(this.C.length());
                string2 = string2.trim();
                try {
                    byte[] byArray = Base64Helper.toBytes(string2);
                    mutableDataProvider.setImage(string, new ByteArrayInputStream(byArray));
                    return this.B;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new StringInterceptorException("Unable to decode image data for key:" + string, illegalArgumentException, false);
                }
            }
            if (this.E && string2.startsWith(DATA_URI_SCHEME_PREFIX) && string2.contains(DATA_URI_SCHEME_BASE_64_EXTENSION)) {
                if (this.A) {
                    mutableDataProvider.setString(string, string2);
                }
                String string3 = string2.substring(string2.indexOf(DATA_URI_SCHEME_BASE_64_EXTENSION) + DATA_URI_SCHEME_BASE_64_EXTENSION.length());
                string3 = string3.trim();
                try {
                    byte[] byArray = Base64Helper.toBytes(string3);
                    mutableDataProvider.setImage(string, new ByteArrayInputStream(byArray));
                    return this.B;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new StringInterceptorException("Unable to decode image data for key:" + string, illegalArgumentException, false);
                }
            }
        }
        return false;
    }
}

