/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.template.population;

import com.docmosis.template.population.DataProvider;
import com.docmosis.template.population.DataProviderBuilder;
import com.docmosis.template.population.MemoryDataProvider;
import com.docmosis.template.population.MutableDataProvider;
import com.docmosis.template.population.StringInterceptor;
import com.docmosis.template.population.XMLNodeFilter;
import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XMLDataProvider
extends MemoryDataProvider {
    private static final String L = "data";
    private static String N = "value";
    private Set M;

    public XMLDataProvider() {
    }

    public XMLDataProvider(Document document, XMLNodeFilter xMLNodeFilter, boolean bl, StringInterceptor[] stringInterceptorArray) {
        XMLDataProvider.buildFromXML(document, xMLNodeFilter, this, bl, stringInterceptorArray);
    }

    @Override
    public void cleanup() {
        super.cleanup();
        this.M = null;
    }

    public Document toXML() throws ParserConfigurationException {
        return XMLDataProvider.toXML(this);
    }

    public static Document toXML(MemoryDataProvider memoryDataProvider) throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        if (XMLDataProvider.hasOwnRoot(memoryDataProvider)) {
            XMLDataProvider.addElementsToDocument(memoryDataProvider, document, document);
        } else {
            Element element = document.createElement(L);
            document.appendChild(element);
            XMLDataProvider.addElementsToDocument(memoryDataProvider, element, document);
        }
        document.normalize();
        return document;
    }

    private static boolean hasOwnRoot(MemoryDataProvider memoryDataProvider) {
        boolean bl = true;
        Set set = memoryDataProvider.getDataProviderKeys();
        if (set == null || set.size() != 1 || memoryDataProvider.getDataProviderCount((String)set.toArray()[0]) > 1) {
            bl = false;
        }
        return bl;
    }

    protected static void addElementsToDocument(MemoryDataProvider memoryDataProvider, Node node, Document document) {
        Element element;
        String string;
        Object object;
        Object object2;
        Set set = memoryDataProvider.getStringKeys();
        if (set != null) {
            object2 = set.iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                string = memoryDataProvider.getString((String)object);
                if (set.size() == 1 && N.equals(object)) {
                    Text text = document.createTextNode(string);
                    node.appendChild(text);
                    continue;
                }
                boolean bl = memoryDataProvider instanceof XMLDataProvider && ((XMLDataProvider)memoryDataProvider).M != null && ((XMLDataProvider)memoryDataProvider).M.contains(object);
                if (bl) continue;
                element = document.createElement((String)object);
                Text text = document.createTextNode(string);
                element.appendChild(text);
                node.appendChild(element);
            }
        }
        if ((object2 = memoryDataProvider.getDataProviderKeys()) != null) {
            object = object2.iterator();
            while (object.hasNext()) {
                string = (String)object.next();
                for (int i = 0; i < memoryDataProvider.getDataProviderCount(string); ++i) {
                    element = document.createElement(string);
                    XMLDataProvider.addElementsToDocument((MemoryDataProvider)memoryDataProvider.getDataProvider(string, i), element, document);
                    node.appendChild(element);
                }
            }
        }
    }

    private static void buildFromXML(Document document, XMLNodeFilter xMLNodeFilter, XMLDataProvider object, boolean bl, StringInterceptor[] stringInterceptorArray) {
        Object object2;
        Node node;
        NodeList nodeList = document.getChildNodes();
        if (nodeList == null || nodeList.getLength() == 0) {
            return;
        }
        if (bl) {
            node = nodeList.item(0);
            object2 = new XMLDataProvider();
            ((MemoryDataProvider)object).addDataProvider(node.getNodeName(), (DataProvider)object2);
            XMLDataProvider.addAttributes(node.getAttributes(), (XMLDataProvider)object2, stringInterceptorArray);
            object = object2;
        }
        node = nodeList.item(0);
        object2 = node.getChildNodes();
        XMLDataProvider.buildFromXML((NodeList)object2, node.getAttributes(), xMLNodeFilter, (XMLDataProvider)object, stringInterceptorArray, null);
    }

    private static XMLDataProvider buildFromXML(NodeList nodeList, NamedNodeMap namedNodeMap, XMLNodeFilter xMLNodeFilter, XMLDataProvider xMLDataProvider, StringInterceptor[] stringInterceptorArray, DataProvider dataProvider) {
        XMLDataProvider.addAttributes(namedNodeMap, xMLDataProvider, stringInterceptorArray);
        if (nodeList != null) {
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node = nodeList.item(i);
                if (xMLNodeFilter != null && !xMLNodeFilter.accept(node)) continue;
                if (node.getNodeType() == 1) {
                    xMLDataProvider.addDataProvider(node.getNodeName(), XMLDataProvider.buildFromXML(node.getChildNodes(), node.getAttributes(), xMLNodeFilter, new XMLDataProvider(), stringInterceptorArray, xMLDataProvider));
                    continue;
                }
                if (node.getNodeType() != 3 && node.getNodeType() != 4) continue;
                String string = node.getNodeValue();
                if (string != null && !"".equals(string.trim())) {
                    DataProviderBuilder.addStringCheckInterceptors(xMLDataProvider, N, string, stringInterceptorArray);
                }
                if (n != 1 && (i != 1 || n != 3 || !XMLDataProvider.isEmptyTextNode(nodeList.item(0)) || !XMLDataProvider.isEmptyTextNode(nodeList.item(2))) || !(dataProvider instanceof MutableDataProvider) || node.getParentNode() == null || dataProvider.hasStringKey(node.getParentNode().getNodeName())) continue;
                DataProviderBuilder.addStringCheckInterceptors((MutableDataProvider)dataProvider, node.getParentNode().getNodeName(), string, stringInterceptorArray);
                if (!(dataProvider instanceof XMLDataProvider)) continue;
                ((XMLDataProvider)dataProvider).setInjectedAttributeString(node.getParentNode().getNodeName());
            }
        }
        return xMLDataProvider;
    }

    private static boolean isEmptyTextNode(Node node) {
        return node.getNodeType() == 3 && node.getNodeValue() != null && "".equals(node.getNodeValue().trim());
    }

    private static void addAttributes(NamedNodeMap namedNodeMap, XMLDataProvider xMLDataProvider, StringInterceptor[] stringInterceptorArray) {
        if (namedNodeMap != null) {
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Node node = namedNodeMap.item(i);
                DataProviderBuilder.addStringCheckInterceptors(xMLDataProvider, node.getNodeName(), node.getNodeValue(), stringInterceptorArray);
            }
        }
    }

    public void setInjectedAttributeString(String string) {
        if (this.M == null) {
            this.M = new HashSet();
        }
        string = XMLDataProvider.getRealKey(string);
        this.M.add(string);
    }

    @Override
    public String toStringPretty() {
        try {
            Document document = this.toXML();
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.setURIResolver(new _A());
            StreamResult streamResult = new StreamResult(new StringWriter());
            transformer.transform(new DOMSource(document), streamResult);
            String string = streamResult.getWriter().toString();
            return string;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static class _A
    implements URIResolver {
        private _A() {
        }

        @Override
        public Source resolve(String string, String string2) throws TransformerException {
            StreamSource streamSource = new StreamSource(new ByteArrayInputStream("".getBytes()));
            return streamSource;
        }
    }
}

