/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.template.population;

import com.docmosis.template.population.MutableDataProvider;
import com.docmosis.template.population.SQLDataItem;
import com.docmosis.template.population.SQLDataProvider;
import com.docmosis.util.SqlUtilities;
import com.docmosis.util.logging.LogManager;
import com.docmosis.util.logging.Logger;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Date;

public class SimpleSQLDataProviderPopulator {
    private static final Logger A = LogManager.getLogger(SimpleSQLDataProviderPopulator.class);

    private SimpleSQLDataProviderPopulator() {
    }

    public static void populateDataProvider(MutableDataProvider mutableDataProvider, ResultSet resultSet, String string) throws SQLException {
        int n;
        if (resultSet == null) {
            A.warn("Passed in a null result set.");
            return;
        }
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        if (resultSetMetaData.getColumnCount() == 0) {
            A.warn("Passed in a result set with no columns.");
            return;
        }
        int n2 = resultSetMetaData.getColumnCount();
        String[] stringArray = new String[n2];
        Class[] classArray = new Class[n2];
        for (n = 0; n < n2; ++n) {
            stringArray[n] = resultSetMetaData.getColumnName(n + 1);
            try {
                classArray[n] = Class.forName(resultSetMetaData.getColumnClassName(n + 1));
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                A.warn("Could not find class: " + resultSetMetaData.getColumnClassName(n + 1) + ". Defaulting to java.lang.Object.");
                classArray[n] = Object.class;
            }
        }
        n = 0;
        while (resultSet.next()) {
            SimpleSQLDataProviderPopulator.addRow(mutableDataProvider, resultSet, string, n++, n2, stringArray, classArray);
        }
    }

    private static void addRow(MutableDataProvider mutableDataProvider, ResultSet resultSet, String string, int n, int n2, String[] stringArray, Class[] classArray) throws SQLException {
        SQLDataProvider sQLDataProvider = new SQLDataProvider();
        for (int i = 0; i < n2; ++i) {
            Object object = SqlUtilities.getSQLObject(resultSet, stringArray[i], classArray[i]);
            SQLDataItem sQLDataItem = null;
            if (object != null) {
                Class clazz = object instanceof Date ? Date.class : classArray[i];
                sQLDataItem = new SQLDataItem(clazz, object);
                sQLDataItem = new SQLDataItem(classArray[i], object);
            }
            sQLDataProvider.setDataItem(stringArray[i], sQLDataItem);
        }
        mutableDataProvider.addDataProvider(string, sQLDataProvider);
    }
}

