/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.template.population;

import com.docmosis.template.population.DataProvider;
import com.docmosis.template.population.DataProvisionNotFoundException;
import com.docmosis.template.population.ReflectiveArrayDataProvider;
import com.docmosis.template.population.ReflectiveCollectionDataProvider;
import com.docmosis.template.population.ReflectiveListDataProvider;
import com.docmosis.template.population.ReflectiveObjectDataProvider;
import com.docmosis.template.population.SingleValueDataProvider;
import com.docmosis.template.population.format.DataFormatter;
import com.docmosis.template.population.format.DateDataFormatter;
import com.docmosis.util.logging.Logger;
import com.docmosis.util.reflection.MethodReflectionHelper;
import java.io.InputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class ReflectiveDataProvider
implements DataProvider,
Serializable {
    private static final String LOG_PREFIX = "#Reflective call#";
    private static final Set PRIMITIVE_CLASSES = new HashSet();
    protected static final MethodReflectionHelper METHOD_REFLECTION_HELPER;
    protected final Object reflectedDelegate;
    protected final Class reflectedDelegateClass;
    protected final boolean forgiving;
    protected final DataFormatManager dataFormatManager;

    public static ReflectiveDataProvider getInstance(Object object) {
        return ReflectiveDataProvider.getInstance(object, true);
    }

    public static ReflectiveDataProvider getWrappedInstance(Object object) {
        return ReflectiveDataProvider.getInstance(object, true, null, true);
    }

    public static ReflectiveDataProvider getInstance(Object object, boolean bl) {
        return ReflectiveDataProvider.getInstance(object, bl, null);
    }

    static ReflectiveDataProvider getInstance(Object object, boolean bl, DataFormatManager dataFormatManager) {
        return ReflectiveDataProvider.getInstance(object, bl, dataFormatManager, false);
    }

    static ReflectiveDataProvider getInstance(Object object, boolean bl, DataFormatManager dataFormatManager, boolean bl2) {
        if (object == null) {
            throw new DataProvisionNotFoundException("Cannot reflect a null delegate object", object, object == null ? null : object.getClass());
        }
        if (!bl2 && ReflectiveDataProvider.isPrimitive(object)) {
            return new SingleValueDataProvider(object, bl, dataFormatManager);
        }
        if (object instanceof List) {
            return new ReflectiveListDataProvider(object, bl, dataFormatManager);
        }
        if (object instanceof Collection) {
            return new ReflectiveCollectionDataProvider(object, bl, dataFormatManager);
        }
        if (object instanceof Object[]) {
            return new ReflectiveArrayDataProvider(object, bl, dataFormatManager);
        }
        return new ReflectiveObjectDataProvider(object, bl, dataFormatManager);
    }

    protected ReflectiveDataProvider(Object object, boolean bl, DataFormatManager dataFormatManager) {
        this.reflectedDelegate = object;
        this.reflectedDelegateClass = this.reflectedDelegate.getClass();
        this.forgiving = bl;
        this.dataFormatManager = dataFormatManager == null ? new DataFormatManager() : dataFormatManager;
    }

    public Object getDelegate() {
        return this.reflectedDelegate;
    }

    public boolean isForgiving() {
        return this.forgiving;
    }

    @Override
    public abstract boolean hasBooleanKey(String var1);

    @Override
    public abstract boolean getBoolean(String var1);

    @Override
    public abstract boolean hasDataProviderKey(String var1);

    @Override
    public abstract DataProvider getDataProvider(String var1, int var2);

    @Override
    public abstract int getDataProviderCount(String var1);

    @Override
    public abstract boolean hasImageKey(String var1);

    @Override
    public abstract InputStream getImage(String var1);

    @Override
    public abstract boolean hasStringKey(String var1);

    @Override
    public abstract String getString(String var1) throws DataProvisionNotFoundException;

    public void setDataFormatter(Class clazz, DataFormatter dataFormatter) {
        if (dataFormatter == null) {
            this.dataFormatManager.removeFormatter(clazz);
        } else {
            this.dataFormatManager.setFormatter(clazz, dataFormatter);
        }
    }

    public void setDateFormat(SimpleDateFormat simpleDateFormat) {
        if (simpleDateFormat == null) {
            this.dataFormatManager.removeFormatter(Date.class);
        } else {
            this.dataFormatManager.setFormatter(Date.class, new DateDataFormatter(simpleDateFormat.toPattern()));
        }
    }

    public void setDateFormat(String string) {
        this.dataFormatManager.setFormatter(Date.class, new DateDataFormatter(string));
    }

    protected static boolean isPrimitive(Object object) {
        return object != null && PRIMITIVE_CLASSES.contains(object.getClass());
    }

    protected static boolean isPrimitiveArray(Object object) {
        return object != null && object.getClass().getComponentType() != null;
    }

    protected void logCall(Logger logger, String string, String string2) {
        if (logger.isDebugEnabled()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(LOG_PREFIX).append(" calling ").append(string);
            stringBuffer.append("(\"").append(string2).append("\") on delegate:");
            this.appendDelegateInfo(stringBuffer);
            logger.debug(stringBuffer.toString());
        }
    }

    protected void logCall(Logger logger, String string, String string2, int n) {
        if (logger.isDebugEnabled()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(LOG_PREFIX).append(" calling ").append(string);
            stringBuffer.append("(\"").append(string2).append("\", ").append(n).append(") on delegate:");
            this.appendDelegateInfo(stringBuffer);
            logger.debug(stringBuffer.toString());
        }
    }

    private void appendDelegateInfo(StringBuffer stringBuffer) {
        if (this.reflectedDelegate == null) {
            stringBuffer.append("<null>");
        } else {
            String string = this.reflectedDelegate.getClass().getName();
            int n = string.lastIndexOf(46);
            if (n != -1 && n < string.length()) {
                string = string.substring(n + 1);
            }
            stringBuffer.append(string).append('@').append(System.identityHashCode(this.reflectedDelegate));
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName()).append('@').append(System.identityHashCode(this)).append('\n');
        stringBuffer.append("delegate=");
        if (this.reflectedDelegate == null) {
            stringBuffer.append("<null>\n");
        } else {
            stringBuffer.append(this.reflectedDelegate.getClass().getName()).append('@').append(System.identityHashCode(this.reflectedDelegate)).append('\n');
        }
        return stringBuffer.toString();
    }

    @Override
    public String toStringPretty() {
        if (this.reflectedDelegate != null) {
            return this.reflectedDelegate.toString();
        }
        return null;
    }

    static {
        PRIMITIVE_CLASSES.add(String.class);
        PRIMITIVE_CLASSES.add(Boolean.class);
        PRIMITIVE_CLASSES.add(Long.class);
        PRIMITIVE_CLASSES.add(Short.class);
        PRIMITIVE_CLASSES.add(Float.class);
        PRIMITIVE_CLASSES.add(Double.class);
        PRIMITIVE_CLASSES.add(Number.class);
        PRIMITIVE_CLASSES.add(Integer.class);
        PRIMITIVE_CLASSES.add(Character.class);
        PRIMITIVE_CLASSES.add(Byte.class);
        PRIMITIVE_CLASSES.add(Object.class);
        PRIMITIVE_CLASSES.add(Date.class);
        METHOD_REFLECTION_HELPER = new MethodReflectionHelper();
    }

    protected static class DataFormatManager
    implements DataFormatter {
        private Map formatters = new HashMap();

        protected DataFormatManager() {
        }

        public void setFormatter(Class clazz, DataFormatter dataFormatter) {
            this.formatters.put(clazz, dataFormatter);
        }

        public void removeFormatter(Class clazz) {
            this.formatters.remove(clazz);
        }

        @Override
        public String format(Class clazz, Object object, String string, Class clazz2) {
            DataFormatter dataFormatter = (DataFormatter)this.formatters.get(clazz);
            if (dataFormatter == null) {
                if (object == null) {
                    return null;
                }
                return String.valueOf(object);
            }
            return dataFormatter.format(clazz, object, string, clazz2);
        }
    }
}

