/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.template.population;

import com.docmosis.template.analysis.ParsedField;
import com.docmosis.template.population.DataProvider;
import com.docmosis.template.population.ReflectiveDataProvider;
import com.docmosis.template.population.render.DataProvisionMetaDataCollector;
import com.docmosis.util.DataProviderUtilities;
import com.docmosis.util.logging.LogManager;
import com.docmosis.util.logging.Logger;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class ReflectiveCollectionDataProvider
extends ReflectiveDataProvider {
    private static final Logger log = LogManager.getLogger(ReflectiveCollectionDataProvider.class);
    protected Collection delegateCollection;
    private Iterator iterator;
    private int iteratorIdx;

    protected ReflectiveCollectionDataProvider(Object object, boolean bl, ReflectiveDataProvider.DataFormatManager dataFormatManager) {
        super(object, bl, dataFormatManager);
        this.delegateCollection = (Collection)object;
    }

    @Override
    public DataProvider getDataProvider(String string, int n) {
        this.logCall(log, "getDataProvider", string, n);
        int n2 = -1;
        if (this.delegateCollection != null) {
            n2 = this.delegateCollection.size();
            if (n >= n2) {
                throw new IndexOutOfBoundsException(this.reflectedDelegateClass.getName() + ":" + this.reflectedDelegate.hashCode() + " Index:" + n + ", Size:" + n2);
            }
            if (this.iterator == null || n <= this.iteratorIdx) {
                this.iterator = this.delegateCollection.iterator();
                this.iteratorIdx = -1;
            }
            Object var4_4 = null;
            while (this.iteratorIdx < n && this.iteratorIdx < n2) {
                var4_4 = this.iterator.next();
                ++this.iteratorIdx;
            }
            if (var4_4 != null) {
                return ReflectiveCollectionDataProvider.getInstance(var4_4, this.forgiving, this.dataFormatManager);
            }
        }
        return null;
    }

    @Override
    public int getDataProviderCount(String string) {
        this.logCall(log, "getDataProviderCount", string);
        return this.delegateCollection == null ? 0 : this.delegateCollection.size();
    }

    @Override
    public boolean hasDataProviderKey(String string) {
        this.logCall(log, "hasDataProviderKey", string);
        return this.delegateCollection != null;
    }

    @Override
    public boolean getBoolean(String string) {
        this.logCall(log, "getBoolean", string);
        if (DataProviderUtilities.isCallForIsEmpty(string)) {
            if (this.delegateCollection == null) {
                return true;
            }
            return this.delegateCollection.isEmpty();
        }
        return false;
    }

    @Override
    public InputStream getImage(String string) {
        this.logCall(log, "getImage", string);
        return null;
    }

    @Override
    public String getString(String string) {
        this.logCall(log, "getString", string);
        if (DataProviderUtilities.isCallForSize(string)) {
            if (this.delegateCollection == null) {
                return "0";
            }
            return Integer.toString(this.delegateCollection.size());
        }
        if (DataProviderUtilities.isCallForIsEmpty(string)) {
            if (this.delegateCollection == null) {
                return Boolean.toString(true);
            }
            return Boolean.toString(this.delegateCollection.isEmpty());
        }
        if (DataProviderUtilities.isCallForIndexOf(string)) {
            if (this.delegateCollection == null || !(this.delegateCollection instanceof List)) {
                return "-1";
            }
            if (DataProvisionMetaDataCollector.get() == null) {
                throw new IllegalStateException("Unexpected error - no meta data");
            }
            ParsedField.NameTerm nameTerm = DataProvisionMetaDataCollector.get().getNameTerm();
            String string2 = DataProviderUtilities.getIndexOfTerm(nameTerm.getFullTerm());
            if (string2 == null) {
                throw new IllegalStateException("Unexpected error - no lookup term");
            }
            return String.valueOf(((List)this.delegateCollection).indexOf(string2));
        }
        return this.delegateCollection == null ? null : this.delegateCollection.toString();
    }

    @Override
    public boolean hasBooleanKey(String string) {
        this.logCall(log, "hasBooleanKey", string);
        return DataProviderUtilities.isCallForIsEmpty(string);
    }

    @Override
    public boolean hasImageKey(String string) {
        this.logCall(log, "hasImageKey", string);
        return false;
    }

    @Override
    public boolean hasStringKey(String string) {
        this.logCall(log, "hasStringKey", string);
        return true;
    }

    @Override
    public String toStringPretty() {
        if (this.delegateCollection != null) {
            return Arrays.deepToString(this.delegateCollection.toArray());
        }
        return null;
    }
}

