/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.template.population;

import com.docmosis.template.population.DataProvider;
import com.docmosis.template.population.ReflectiveDataProvider;
import com.docmosis.util.DataProviderUtilities;
import com.docmosis.util.logging.LogManager;
import com.docmosis.util.logging.Logger;
import java.io.InputStream;
import java.util.Arrays;

public class ReflectiveArrayDataProvider
extends ReflectiveDataProvider {
    private static final Logger log = LogManager.getLogger(ReflectiveArrayDataProvider.class);
    private Object[] delegateArray;

    protected ReflectiveArrayDataProvider(Object object, boolean bl, ReflectiveDataProvider.DataFormatManager dataFormatManager) {
        super(object, bl, dataFormatManager);
        this.delegateArray = (Object[])object;
    }

    @Override
    public DataProvider getDataProvider(String string, int n) {
        this.logCall(log, "getDataProvider", string, n);
        int n2 = -1;
        if (this.delegateArray != null) {
            n2 = this.delegateArray.length;
            if (n >= n2) {
                throw new IndexOutOfBoundsException(this.reflectedDelegateClass.getName() + ":" + this.reflectedDelegate.hashCode() + " Index:" + n + ", Size:" + n2);
            }
            return ReflectiveArrayDataProvider.getInstance(this.delegateArray[n], this.forgiving, this.dataFormatManager);
        }
        return null;
    }

    @Override
    public int getDataProviderCount(String string) {
        this.logCall(log, "getDataProviderCount", string);
        return this.delegateArray == null ? 0 : this.delegateArray.length;
    }

    @Override
    public boolean hasDataProviderKey(String string) {
        this.logCall(log, "hasDataProviderKey", string);
        return this.delegateArray != null;
    }

    @Override
    public boolean getBoolean(String string) {
        this.logCall(log, "getBoolean", string);
        if (DataProviderUtilities.isCallForIsEmpty(string)) {
            if (this.delegateArray == null) {
                return true;
            }
            return this.delegateArray.length == 0;
        }
        return false;
    }

    @Override
    public InputStream getImage(String string) {
        this.logCall(log, "getImage", string);
        return null;
    }

    @Override
    public String getString(String string) {
        this.logCall(log, "getString", string);
        if (DataProviderUtilities.isCallForSize(string)) {
            if (this.delegateArray == null) {
                return "0";
            }
            return Integer.toString(this.delegateArray.length);
        }
        if (DataProviderUtilities.isCallForIsEmpty(string)) {
            if (this.delegateArray == null) {
                return Boolean.toString(true);
            }
            return Boolean.toString(this.delegateArray.length == 0);
        }
        if (DataProviderUtilities.isCallForIndexOf(string)) {
            String string2 = DataProviderUtilities.getIndexOfTerm(string);
            if (this.delegateArray != null) {
                for (int i = 0; i < this.delegateArray.length; ++i) {
                    if (this.delegateArray[i] == null || !this.delegateArray[i].equals(string2)) continue;
                    return String.valueOf(i);
                }
            }
            return "-1";
        }
        return this.delegateArray == null ? null : this.delegateArray.toString();
    }

    @Override
    public boolean hasBooleanKey(String string) {
        this.logCall(log, "hasBooleanKey", string);
        return DataProviderUtilities.isCallForIsEmpty(string);
    }

    @Override
    public boolean hasImageKey(String string) {
        this.logCall(log, "hasImageKey", string);
        return "size".equals(string) || "size()".equals(string) || "length".equals(string) || "length()".equals(string);
    }

    @Override
    public boolean hasStringKey(String string) {
        this.logCall(log, "hasStringKey", string);
        return true;
    }

    @Override
    public String toStringPretty() {
        if (this.delegateArray != null) {
            return Arrays.deepToString(this.delegateArray);
        }
        return null;
    }
}

