/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.template.population;

import com.docmosis.template.analysis.sensitivitylabel.SensitivityLabelInfo;
import com.docmosis.template.analysis.sensitivitylabel.SensitivityLabelItem;
import com.docmosis.template.analysis.sensitivitylabel.SensitivityLabelType;
import com.docmosis.template.store.TemplateIdentifier;
import com.docmosis.util.DMProperties;
import com.docmosis.util.FileUtilities;
import java.io.Externalizable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;

public class PopulatedFilesCollection
implements Serializable {
    private static final int A = DMProperties.getInt("docmosis.stream.buffer.size", 4096);
    protected ArrayList populatedFiles = new ArrayList();

    public PopulatedFile add(String string, File file, boolean bl, String string2, AtomicBoolean atomicBoolean, AtomicBoolean atomicBoolean2) {
        return this.add(string, file, bl, false, string2, atomicBoolean, atomicBoolean2, null);
    }

    public PopulatedFile add(String string, File file, boolean bl, boolean bl2, String string2, AtomicBoolean atomicBoolean, AtomicBoolean atomicBoolean2, SensitivityLabelInfo sensitivityLabelInfo) {
        if (!file.isAbsolute()) {
            file = new File(file.getAbsolutePath());
        }
        PopulatedFile populatedFile = new PopulatedFile(string, file, bl, string2, atomicBoolean, atomicBoolean2, sensitivityLabelInfo);
        populatedFile.setIsTemplate(bl2);
        this.add(populatedFile);
        return populatedFile;
    }

    public void add(PopulatedFile populatedFile) {
        this.populatedFiles.add(populatedFile);
    }

    public void clear() {
        this.populatedFiles.clear();
    }

    public int size() {
        return this.populatedFiles.size();
    }

    public PopulatedFile[] getFiles() {
        PopulatedFile[] populatedFileArray = new PopulatedFile[this.populatedFiles.size()];
        this.populatedFiles.toArray(populatedFileArray);
        return populatedFileArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("populatedFiles:");
        if (this.populatedFiles.size() == 0) {
            stringBuffer.append("<none>");
        } else {
            stringBuffer.append("[");
            Iterator iterator = this.populatedFiles.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(((PopulatedFile)iterator.next()).toString());
                if (!iterator.hasNext()) continue;
                stringBuffer.append(",");
            }
            stringBuffer.append("]");
        }
        return stringBuffer.toString();
    }

    public void cleanup() {
        if (this.populatedFiles != null) {
            Iterator iterator = this.populatedFiles.iterator();
            while (iterator.hasNext()) {
                ((PopulatedFile)iterator.next()).cleanup();
            }
            this.populatedFiles = null;
        }
    }

    public static void cleanup(PopulatedFilesCollection populatedFilesCollection) {
        if (populatedFilesCollection != null) {
            populatedFilesCollection.cleanup();
        }
    }

    public void setStreamingFiles(boolean bl) {
        if (this.populatedFiles != null && !this.populatedFiles.isEmpty()) {
            Iterator iterator = this.populatedFiles.iterator();
            while (iterator.hasNext()) {
                ((PopulatedFile)iterator.next()).setStreamFileContents(bl);
            }
        }
    }

    public static class PopulatedFile
    implements Externalizable {
        protected String bookmarkName;
        protected File file;
        protected boolean neverDelete;
        protected boolean streamFileContents;
        protected boolean isTemplate;
        protected String origFileName;
        protected String markerLineToRemove;
        protected AtomicBoolean populationInjectedLeadingParaForMasterStyles;
        protected AtomicBoolean populationInjectedTrailingParaForSingleLineSubTemplate;
        protected TemplateIdentifier basedOnTemplateId;
        protected boolean emptyDocumentCreated;
        protected SensitivityLabelInfo sensitivityLabelInfo;
        protected transient boolean isBeingCoordinated;
        protected transient boolean padToEvenPageRequested;
        protected transient boolean padToOddPageRequested;
        protected transient boolean newFileRequested;
        protected transient String newFileName;

        public PopulatedFile() {
        }

        public PopulatedFile(String string, File file, boolean bl, String string2, AtomicBoolean atomicBoolean, AtomicBoolean atomicBoolean2, SensitivityLabelInfo sensitivityLabelInfo) {
            this.bookmarkName = string;
            this.file = file;
            this.origFileName = file.getName();
            this.neverDelete = bl;
            this.markerLineToRemove = string2;
            this.populationInjectedLeadingParaForMasterStyles = atomicBoolean;
            this.populationInjectedTrailingParaForSingleLineSubTemplate = atomicBoolean2;
            this.sensitivityLabelInfo = sensitivityLabelInfo;
        }

        public String getBookmarkName() {
            return this.bookmarkName;
        }

        public File getFile() {
            return this.file;
        }

        public boolean isTemplate() {
            return this.isTemplate;
        }

        public String getOrigFileName() {
            return this.origFileName;
        }

        public void setIsTemplate(boolean bl) {
            this.isTemplate = bl;
        }

        public TemplateIdentifier getBasedOnTemplateId() {
            return this.basedOnTemplateId;
        }

        public void setBasedOnTemplateId(TemplateIdentifier templateIdentifier) {
            this.basedOnTemplateId = templateIdentifier;
        }

        public String toString() {
            return this.bookmarkName + ":" + (this.file == null ? "<null>" : this.file.getPath());
        }

        private void cleanup() {
            if (!this.neverDelete) {
                FileUtilities.delete(this.file);
            }
        }

        private void setStreamFileContents(boolean bl) {
            this.streamFileContents = bl;
        }

        public String getMarkerLineToRemove() {
            return this.markerLineToRemove;
        }

        public AtomicBoolean getPopulationInjectedLeadingParaForMasterStyles() {
            return this.populationInjectedLeadingParaForMasterStyles;
        }

        public AtomicBoolean getPopulationInjectedTrailingParaForSingleLineSubTemplate() {
            return this.populationInjectedTrailingParaForSingleLineSubTemplate;
        }

        public boolean isPadToEvenPageRequested() {
            return this.padToEvenPageRequested;
        }

        public void setPadToEvenPageRequested(boolean bl) {
            this.padToEvenPageRequested = bl;
        }

        public boolean isPadToOddPageRequested() {
            return this.padToOddPageRequested;
        }

        public void setPadToOddPageRequested(boolean bl) {
            this.padToOddPageRequested = bl;
        }

        public boolean isNewFileRequested() {
            return this.newFileRequested;
        }

        public void setNewFileRequested(boolean bl) {
            this.newFileRequested = bl;
        }

        public String getNewFileName() {
            return this.newFileName;
        }

        public void setNewFileName(String string) {
            this.newFileName = string;
        }

        public boolean isBeingCoordinated() {
            return this.isBeingCoordinated;
        }

        public void setBeingCoordinated(boolean bl) {
            this.isBeingCoordinated = bl;
        }

        public boolean isEmptyDocumentCreated() {
            return this.emptyDocumentCreated;
        }

        public void setEmptyDocumentCreated(boolean bl) {
            this.emptyDocumentCreated = bl;
        }

        public SensitivityLabelInfo getSensitivityLabelInfo() {
            return this.sensitivityLabelInfo;
        }

        public void setSensitivityLabelInfo(SensitivityLabelInfo sensitivityLabelInfo) {
            this.sensitivityLabelInfo = sensitivityLabelInfo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            Object object;
            String string;
            Object object2;
            int n;
            this.bookmarkName = (String)objectInput.readObject();
            this.isTemplate = objectInput.readBoolean();
            this.origFileName = (String)objectInput.readObject();
            this.markerLineToRemove = (String)objectInput.readObject();
            this.populationInjectedLeadingParaForMasterStyles = (AtomicBoolean)objectInput.readObject();
            this.populationInjectedTrailingParaForSingleLineSubTemplate = (AtomicBoolean)objectInput.readObject();
            String string2 = (String)objectInput.readObject();
            this.basedOnTemplateId = string2 == null ? null : TemplateIdentifier.fromPath(string2);
            this.emptyDocumentCreated = objectInput.readBoolean();
            int n2 = objectInput.readInt();
            if (n2 != -1) {
                SensitivityLabelItem[] sensitivityLabelItemArray = new SensitivityLabelItem[n2];
                for (n = 0; n < n2; ++n) {
                    object2 = SensitivityLabelType.valueOf(objectInput.readUTF());
                    string = objectInput.readUTF();
                    object = objectInput.readUTF();
                    sensitivityLabelItemArray[n] = new SensitivityLabelItem((SensitivityLabelType)object2, string, (String)object);
                }
                this.sensitivityLabelInfo = new SensitivityLabelInfo(sensitivityLabelItemArray);
            } else {
                this.sensitivityLabelInfo = null;
            }
            boolean bl = objectInput.readBoolean();
            if (bl) {
                n = DMProperties.getBoolean("docmosis.converter.remote.file.transfer.preserveExtensions", true) ? 1 : 0;
                object2 = n != 0 ? FileUtilities.getFilenameExtension(this.origFileName) : "";
                string = "ext" + ("".equals(object2) ? "" : "." + (String)object2);
                this.file = FileUtilities.createTempFile("dm_", string);
                object = new byte[A];
                FileOutputStream fileOutputStream = new FileOutputStream(this.file);
                try {
                    int n3;
                    while ((n3 = objectInput.read((byte[])object)) != -1) {
                        fileOutputStream.write((byte[])object, 0, n3);
                    }
                    fileOutputStream.flush();
                }
                finally {
                    FileUtilities.close(fileOutputStream);
                }
            } else {
                String string3 = (String)objectInput.readObject();
                this.file = new File(string3);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            int n;
            objectOutput.writeObject(this.bookmarkName);
            objectOutput.writeBoolean(this.isTemplate);
            objectOutput.writeObject(this.origFileName);
            objectOutput.writeObject(this.markerLineToRemove);
            objectOutput.writeObject(this.populationInjectedLeadingParaForMasterStyles);
            objectOutput.writeObject(this.populationInjectedTrailingParaForSingleLineSubTemplate);
            objectOutput.writeObject(this.basedOnTemplateId == null ? null : this.basedOnTemplateId.getFullPath());
            objectOutput.writeBoolean(this.emptyDocumentCreated);
            int n2 = this.sensitivityLabelInfo != null && this.sensitivityLabelInfo.getSensitivityLabels() != null ? this.sensitivityLabelInfo.getSensitivityLabels().length : -1;
            objectOutput.writeInt(n2);
            if (n2 != -1) {
                SensitivityLabelItem[] objectArray = this.sensitivityLabelInfo.getSensitivityLabels();
                n = objectArray.length;
                for (int fileInputStream = 0; fileInputStream < n; ++fileInputStream) {
                    SensitivityLabelItem sensitivityLabelItem = objectArray[fileInputStream];
                    objectOutput.writeUTF(sensitivityLabelItem.getSensitivityLabelType().name());
                    objectOutput.writeUTF(sensitivityLabelItem.getKey());
                    objectOutput.writeUTF(sensitivityLabelItem.getSensitivityLabelXML());
                }
            }
            objectOutput.writeBoolean(this.streamFileContents);
            if (this.streamFileContents) {
                byte[] byArray = new byte[A];
                FileInputStream fileInputStream = new FileInputStream(this.file);
                try {
                    while ((n = fileInputStream.read(byArray)) != -1) {
                        objectOutput.write(byArray, 0, n);
                    }
                    objectOutput.flush();
                }
                finally {
                    FileUtilities.close(fileInputStream);
                }
            } else {
                objectOutput.writeObject(this.file.getPath());
            }
        }
    }
}

